/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.internal.Streams;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.mojang.datafixers.DataFixer;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.FileUtil;
import net.minecraft.SharedConstants;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementProgress;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.CriterionProgress;
import net.minecraft.advancements.CriterionTrigger;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundSelectAdvancementsTabPacket;
import net.minecraft.network.protocol.game.ClientboundUpdateAdvancementsPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.ServerAdvancementManager;
import net.minecraft.server.advancements.AdvancementVisibilityEvaluator;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.players.PlayerList;
import net.minecraft.util.datafix.DataFixTypes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.GameRules;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.player.AdvancementEvent;
import org.slf4j.Logger;

public class PlayerAdvancements {
    private static final Logger f_135958_ = LogUtils.getLogger();
    private static final Gson f_135959_ = new GsonBuilder().registerTypeAdapter(AdvancementProgress.class, (Object)new AdvancementProgress.Serializer()).registerTypeAdapter(ResourceLocation.class, (Object)new ResourceLocation.Serializer()).setPrettyPrinting().create();
    private static final TypeToken<Map<ResourceLocation, AdvancementProgress>> f_135960_ = new TypeToken<Map<ResourceLocation, AdvancementProgress>>(){};
    private final DataFixer f_135961_;
    private final PlayerList f_135962_;
    private final Path f_263766_;
    private final Map<Advancement, AdvancementProgress> f_263740_ = new LinkedHashMap<Advancement, AdvancementProgress>();
    private final Set<Advancement> f_135965_ = new HashSet<Advancement>();
    private final Set<Advancement> f_135967_ = new HashSet<Advancement>();
    private final Set<Advancement> f_263821_ = new HashSet<Advancement>();
    private ServerPlayer f_135968_;
    @Nullable
    private Advancement f_135969_;
    private boolean f_135970_ = true;

    public PlayerAdvancements(DataFixer p_265655_, PlayerList p_265703_, ServerAdvancementManager p_265166_, Path p_265268_, ServerPlayer p_265673_) {
        this.f_135961_ = p_265655_;
        this.f_135962_ = p_265703_;
        this.f_263766_ = p_265268_;
        this.f_135968_ = p_265673_;
        this.m_136006_(p_265166_);
    }

    public void m_135979_(ServerPlayer p_135980_) {
        this.f_135968_ = p_135980_;
    }

    public void m_135978_() {
        for (CriterionTrigger<?> criteriontrigger : CriteriaTriggers.m_10594_()) {
            criteriontrigger.m_5656_(this);
        }
    }

    public void m_135981_(ServerAdvancementManager p_135982_) {
        this.m_135978_();
        this.f_263740_.clear();
        this.f_135965_.clear();
        this.f_263821_.clear();
        this.f_135967_.clear();
        this.f_135970_ = true;
        this.f_135969_ = null;
        this.m_136006_(p_135982_);
    }

    private void m_135994_(ServerAdvancementManager p_135995_) {
        for (Advancement advancement : p_135995_.m_136028_()) {
            this.m_136004_(advancement);
        }
    }

    private void m_136002_(ServerAdvancementManager p_136003_) {
        for (Advancement advancement : p_136003_.m_136028_()) {
            if (!advancement.m_138325_().isEmpty()) continue;
            this.m_135988_(advancement, "");
            advancement.m_138321_().m_9989_(this.f_135968_);
        }
    }

    private void m_136006_(ServerAdvancementManager p_136007_) {
        if (Files.isRegularFile(this.f_263766_, new LinkOption[0])) {
            try (JsonReader jsonreader = new JsonReader((Reader)Files.newBufferedReader(this.f_263766_, StandardCharsets.UTF_8));){
                jsonreader.setLenient(false);
                Dynamic dynamic = new Dynamic((DynamicOps)JsonOps.INSTANCE, (Object)Streams.parse((JsonReader)jsonreader));
                int i = dynamic.get("DataVersion").asInt(1343);
                dynamic = dynamic.remove("DataVersion");
                dynamic = DataFixTypes.ADVANCEMENTS.m_264140_(this.f_135961_, dynamic, i);
                Map map = (Map)f_135959_.getAdapter(f_135960_).fromJsonTree((JsonElement)dynamic.getValue());
                if (map == null) {
                    throw new JsonParseException("Found null for advancements");
                }
                map.entrySet().stream().sorted(Map.Entry.comparingByValue()).forEach(p_265663_ -> {
                    Advancement advancement = p_136007_.m_136041_((ResourceLocation)p_265663_.getKey());
                    if (advancement == null) {
                        f_135958_.warn("Ignored advancement '{}' in progress file {} - it doesn't exist anymore?", p_265663_.getKey(), (Object)this.f_263766_);
                    } else {
                        this.m_135985_(advancement, (AdvancementProgress)p_265663_.getValue());
                        this.f_135967_.add(advancement);
                        this.m_264423_(advancement);
                    }
                });
            }
            catch (JsonParseException jsonparseexception) {
                f_135958_.error("Couldn't parse player advancements in {}", (Object)this.f_263766_, (Object)jsonparseexception);
            }
            catch (IOException ioexception) {
                f_135958_.error("Couldn't access player advancements in {}", (Object)this.f_263766_, (Object)ioexception);
            }
        }
        this.m_136002_(p_136007_);
        this.m_135994_(p_136007_);
    }

    public void m_135991_() {
        LinkedHashMap<ResourceLocation, AdvancementProgress> map = new LinkedHashMap<ResourceLocation, AdvancementProgress>();
        for (Map.Entry<Advancement, AdvancementProgress> entry : this.f_263740_.entrySet()) {
            AdvancementProgress advancementprogress = entry.getValue();
            if (!advancementprogress.m_8206_()) continue;
            map.put(entry.getKey().m_138327_(), advancementprogress);
        }
        JsonElement jsonelement = f_135959_.toJsonTree(map);
        jsonelement.getAsJsonObject().addProperty("DataVersion", (Number)SharedConstants.m_183709_().m_183476_().m_193006_());
        try {
            FileUtil.m_257659_(this.f_263766_.getParent());
            try (BufferedWriter writer = Files.newBufferedWriter(this.f_263766_, StandardCharsets.UTF_8, new OpenOption[0]);){
                f_135959_.toJson(jsonelement, (Appendable)writer);
            }
        }
        catch (IOException ioexception) {
            f_135958_.error("Couldn't save player advancements to {}", (Object)this.f_263766_, (Object)ioexception);
        }
    }

    public boolean m_135988_(Advancement p_135989_, String p_135990_) {
        if (this.f_135968_ instanceof FakePlayer) {
            return false;
        }
        boolean flag = false;
        AdvancementProgress advancementprogress = this.m_135996_(p_135989_);
        boolean flag1 = advancementprogress.m_8193_();
        if (advancementprogress.m_8196_(p_135990_)) {
            this.m_136008_(p_135989_);
            this.f_135967_.add(p_135989_);
            flag = true;
            ForgeEventFactory.onAdvancementProgressedEvent((Player)this.f_135968_, (Advancement)p_135989_, (AdvancementProgress)advancementprogress, (String)p_135990_, (AdvancementEvent.AdvancementProgressEvent.ProgressType)AdvancementEvent.AdvancementProgressEvent.ProgressType.GRANT);
            if (!flag1 && advancementprogress.m_8193_()) {
                p_135989_.m_138321_().m_9989_(this.f_135968_);
                if (p_135989_.m_138320_() != null && p_135989_.m_138320_().m_14996_() && this.f_135968_.m_9236_().m_46469_().m_46207_(GameRules.f_46153_)) {
                    this.f_135962_.m_240416_(Component.m_237110_("chat.type.advancement." + p_135989_.m_138320_().m_14992_().m_15548_(), this.f_135968_.m_5446_(), p_135989_.m_138330_()), false);
                }
                ForgeEventFactory.onAdvancementEarnedEvent((Player)this.f_135968_, (Advancement)p_135989_);
            }
        }
        if (!flag1 && advancementprogress.m_8193_()) {
            this.m_264423_(p_135989_);
        }
        return flag;
    }

    public boolean m_135998_(Advancement p_135999_, String p_136000_) {
        boolean flag = false;
        AdvancementProgress advancementprogress = this.m_135996_(p_135999_);
        boolean flag1 = advancementprogress.m_8193_();
        if (advancementprogress.m_8209_(p_136000_)) {
            this.m_136004_(p_135999_);
            this.f_135967_.add(p_135999_);
            flag = true;
            ForgeEventFactory.onAdvancementProgressedEvent((Player)this.f_135968_, (Advancement)p_135999_, (AdvancementProgress)advancementprogress, (String)p_136000_, (AdvancementEvent.AdvancementProgressEvent.ProgressType)AdvancementEvent.AdvancementProgressEvent.ProgressType.REVOKE);
        }
        if (flag1 && !advancementprogress.m_8193_()) {
            this.m_264423_(p_135999_);
        }
        return flag;
    }

    private void m_264423_(Advancement p_265528_) {
        this.f_263821_.add(p_265528_.m_264348_());
    }

    private void m_136004_(Advancement p_136005_) {
        AdvancementProgress advancementprogress = this.m_135996_(p_136005_);
        if (!advancementprogress.m_8193_()) {
            for (Map.Entry<String, Criterion> entry : p_136005_.m_138325_().entrySet()) {
                CriterionTrigger<CriterionTriggerInstance> criteriontrigger;
                CriterionTriggerInstance criteriontriggerinstance;
                CriterionProgress criterionprogress = advancementprogress.m_8214_(entry.getKey());
                if (criterionprogress == null || criterionprogress.m_12911_() || (criteriontriggerinstance = entry.getValue().m_11416_()) == null || (criteriontrigger = CriteriaTriggers.m_10597_(criteriontriggerinstance.m_7294_())) == null) continue;
                criteriontrigger.m_6467_(this, new CriterionTrigger.Listener<CriterionTriggerInstance>(criteriontriggerinstance, p_136005_, entry.getKey()));
            }
        }
    }

    private void m_136008_(Advancement p_136009_) {
        AdvancementProgress advancementprogress = this.m_135996_(p_136009_);
        for (Map.Entry<String, Criterion> entry : p_136009_.m_138325_().entrySet()) {
            CriterionTrigger<CriterionTriggerInstance> criteriontrigger;
            CriterionTriggerInstance criteriontriggerinstance;
            CriterionProgress criterionprogress = advancementprogress.m_8214_(entry.getKey());
            if (criterionprogress == null || !criterionprogress.m_12911_() && !advancementprogress.m_8193_() || (criteriontriggerinstance = entry.getValue().m_11416_()) == null || (criteriontrigger = CriteriaTriggers.m_10597_(criteriontriggerinstance.m_7294_())) == null) continue;
            criteriontrigger.m_6468_(this, new CriterionTrigger.Listener<CriterionTriggerInstance>(criteriontriggerinstance, p_136009_, entry.getKey()));
        }
    }

    public void m_135992_(ServerPlayer p_135993_) {
        if (this.f_135970_ || !this.f_263821_.isEmpty() || !this.f_135967_.isEmpty()) {
            HashMap<ResourceLocation, AdvancementProgress> map = new HashMap<ResourceLocation, AdvancementProgress>();
            HashSet<Advancement> set = new HashSet<Advancement>();
            HashSet<ResourceLocation> set1 = new HashSet<ResourceLocation>();
            for (Advancement advancement : this.f_263821_) {
                this.m_264265_(advancement, set, set1);
            }
            this.f_263821_.clear();
            for (Advancement advancement1 : this.f_135967_) {
                if (!this.f_135965_.contains(advancement1)) continue;
                map.put(advancement1.m_138327_(), this.f_263740_.get(advancement1));
            }
            this.f_135967_.clear();
            if (!(map.isEmpty() && set.isEmpty() && set1.isEmpty())) {
                p_135993_.f_8906_.m_9829_(new ClientboundUpdateAdvancementsPacket(this.f_135970_, set, set1, map));
            }
        }
        this.f_135970_ = false;
    }

    public void m_135983_(@Nullable Advancement p_135984_) {
        Advancement advancement = this.f_135969_;
        this.f_135969_ = p_135984_ != null && p_135984_.m_138319_() == null && p_135984_.m_138320_() != null ? p_135984_ : null;
        if (advancement != this.f_135969_) {
            this.f_135968_.f_8906_.m_9829_(new ClientboundSelectAdvancementsTabPacket(this.f_135969_ == null ? null : this.f_135969_.m_138327_()));
        }
    }

    public AdvancementProgress m_135996_(Advancement p_135997_) {
        AdvancementProgress advancementprogress = this.f_263740_.get(p_135997_);
        if (advancementprogress == null) {
            advancementprogress = new AdvancementProgress();
            this.m_135985_(p_135997_, advancementprogress);
        }
        return advancementprogress;
    }

    private void m_135985_(Advancement p_135986_, AdvancementProgress p_135987_) {
        p_135987_.m_8198_(p_135986_.m_138325_(), p_135986_.m_138329_());
        this.f_263740_.put(p_135986_, p_135987_);
    }

    private void m_264265_(Advancement p_265158_, Set<Advancement> p_265206_, Set<ResourceLocation> p_265593_) {
        AdvancementVisibilityEvaluator.m_264099_(p_265158_, p_265787_ -> this.m_135996_((Advancement)p_265787_).m_8193_(), (p_265247_, p_265330_) -> {
            if (p_265330_) {
                if (this.f_135965_.add(p_265247_)) {
                    p_265206_.add(p_265247_);
                    if (this.f_263740_.containsKey(p_265247_)) {
                        this.f_135967_.add(p_265247_);
                    }
                }
            } else if (this.f_135965_.remove(p_265247_)) {
                p_265593_.add(p_265247_.m_138327_());
            }
        });
    }
}

