/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.data.loot;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.advancements.critereon.DamageSourcePredicate;
import net.minecraft.advancements.critereon.EntityFlagsPredicate;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.EntitySubPredicate;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.loot.LootTableSubProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.animal.FrogVariant;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootTableReference;
import net.minecraft.world.level.storage.loot.predicates.DamageSourceCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;

public abstract class EntityLootSubProvider
implements LootTableSubProvider {
    protected static final EntityPredicate.Builder f_244460_ = EntityPredicate.Builder.m_36633_().m_36642_(EntityFlagsPredicate.Builder.m_33713_().m_33714_(true).m_33716_());
    private static final Set<EntityType<?>> f_244591_ = ImmutableSet.of(EntityType.f_20532_, EntityType.f_20529_, EntityType.f_20460_, EntityType.f_20528_, EntityType.f_20492_);
    private final FeatureFlagSet f_265862_;
    private final FeatureFlagSet f_266009_;
    private final Map<EntityType<?>, Map<ResourceLocation, LootTable.Builder>> f_244213_ = Maps.newHashMap();

    protected EntityLootSubProvider(FeatureFlagSet p_251971_) {
        this(p_251971_, p_251971_);
    }

    protected EntityLootSubProvider(FeatureFlagSet p_266989_, FeatureFlagSet p_267138_) {
        this.f_265862_ = p_266989_;
        this.f_266009_ = p_267138_;
    }

    protected static LootTable.Builder m_246752_(ItemLike p_249422_) {
        return LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_(ConstantValue.m_165692_(1.0f)).m_79076_(LootItem.m_79579_(p_249422_))).m_79161_(LootPool.m_79043_().m_165133_(ConstantValue.m_165692_(1.0f)).m_79076_(LootTableReference.m_79776_(EntityType.f_20520_.m_20677_())));
    }

    public abstract void m_246942_();

    protected Stream<EntityType<?>> getKnownEntityTypes() {
        return BuiltInRegistries.f_256780_.m_123024_();
    }

    @Override
    public void m_245126_(BiConsumer<ResourceLocation, LootTable.Builder> p_251751_) {
        this.m_246942_();
        HashSet set = Sets.newHashSet();
        this.getKnownEntityTypes().map(EntityType::m_204041_).forEach(p_266624_ -> {
            EntityType entitytype = (EntityType)p_266624_.m_203334_();
            if (entitytype.m_245993_(this.f_265862_)) {
                if (this.m_245552_(entitytype)) {
                    Map<ResourceLocation, LootTable.Builder> map = this.f_244213_.remove(entitytype);
                    ResourceLocation resourcelocation = entitytype.m_20677_();
                    if (!(resourcelocation.equals(BuiltInLootTables.f_78712_) || !entitytype.m_245993_(this.f_266009_) || map != null && map.containsKey(resourcelocation))) {
                        throw new IllegalStateException(String.format(Locale.ROOT, "Missing loottable '%s' for '%s'", resourcelocation, p_266624_.m_205785_().m_135782_()));
                    }
                    if (map != null) {
                        map.forEach((p_250376_, p_250972_) -> {
                            if (!set.add(p_250376_)) {
                                throw new IllegalStateException(String.format(Locale.ROOT, "Duplicate loottable '%s' for '%s'", p_250376_, p_266624_.m_205785_().m_135782_()));
                            }
                            p_251751_.accept((ResourceLocation)p_250376_, (LootTable.Builder)p_250972_);
                        });
                    }
                } else {
                    Map<ResourceLocation, LootTable.Builder> map1 = this.f_244213_.remove(entitytype);
                    if (map1 != null) {
                        throw new IllegalStateException(String.format(Locale.ROOT, "Weird loottables '%s' for '%s', not a LivingEntity so should not have loot", map1.keySet().stream().map(ResourceLocation::toString).collect(Collectors.joining(",")), p_266624_.m_205785_().m_135782_()));
                    }
                }
            }
        });
        if (!this.f_244213_.isEmpty()) {
            throw new IllegalStateException("Created loot tables for entities not supported by datapack: " + this.f_244213_.keySet());
        }
    }

    protected boolean m_245552_(EntityType<?> p_249029_) {
        return f_244591_.contains(p_249029_) || p_249029_.m_20674_() != MobCategory.MISC;
    }

    protected LootItemCondition.Builder m_245873_() {
        return DamageSourceCondition.m_81589_(DamageSourcePredicate.Builder.m_25471_().m_148231_(EntityPredicate.Builder.m_36633_().m_36636_(EntityType.f_217012_)));
    }

    protected LootItemCondition.Builder m_247253_(FrogVariant p_249403_) {
        return DamageSourceCondition.m_81589_(DamageSourcePredicate.Builder.m_25471_().m_148231_(EntityPredicate.Builder.m_36633_().m_36636_(EntityType.f_217012_).m_218800_(EntitySubPredicate.m_218833_(p_249403_))));
    }

    protected void m_245309_(EntityType<?> p_248740_, LootTable.Builder p_249440_) {
        this.m_247520_(p_248740_, p_248740_.m_20677_(), p_249440_);
    }

    protected void m_247520_(EntityType<?> p_252130_, ResourceLocation p_251706_, LootTable.Builder p_249357_) {
        this.f_244213_.computeIfAbsent(p_252130_, p_251466_ -> new HashMap()).put(p_251706_, p_249357_);
    }
}

