/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.data;

import com.google.common.collect.ImmutableMap;
import com.google.common.hash.HashCode;
import com.google.common.hash.Hashing;
import com.mojang.logging.LogUtils;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.WorldVersion;
import net.minecraft.data.CachedOutput;
import org.apache.commons.lang3.mutable.MutableInt;
import org.slf4j.Logger;

public class HashCache {
    static final Logger f_123926_ = LogUtils.getLogger();
    private static final String f_236078_ = "// ";
    private final Path f_236079_;
    private final Path f_236080_;
    private final String f_236081_;
    private final Map<String, ProviderCache> f_252445_;
    private final Map<String, ProviderCache> originalCaches;
    private final Set<String> f_236083_ = new HashSet<String>();
    private final Set<Path> f_236084_ = new HashSet<Path>();
    private final int f_236085_;
    private int f_252434_;

    private Path m_252859_(String p_254395_) {
        return this.f_236080_.resolve(Hashing.sha1().hashString((CharSequence)p_254395_, StandardCharsets.UTF_8).toString());
    }

    public HashCache(Path p_236087_, Collection<String> p_253748_, WorldVersion p_236089_) throws IOException {
        this.f_236081_ = p_236089_.m_132493_();
        this.f_236079_ = p_236087_;
        this.f_236080_ = p_236087_.resolve(".cache");
        Files.createDirectories(this.f_236080_, new FileAttribute[0]);
        HashMap<String, ProviderCache> map = new HashMap<String, ProviderCache>();
        int i = 0;
        for (String s : p_253748_) {
            Path path = this.m_252859_(s);
            this.f_236084_.add(path);
            ProviderCache hashcache$providercache = HashCache.m_236092_(p_236087_, path);
            map.put(s, hashcache$providercache);
            i += hashcache$providercache.m_236133_();
        }
        this.f_252445_ = map;
        this.originalCaches = Map.copyOf(this.f_252445_);
        this.f_236085_ = i;
    }

    private static ProviderCache m_236092_(Path p_236093_, Path p_236094_) {
        if (Files.isReadable(p_236094_)) {
            try {
                return ProviderCache.m_236139_(p_236093_, p_236094_);
            }
            catch (Exception exception) {
                f_123926_.warn("Failed to parse cache {}, discarding", (Object)p_236094_, (Object)exception);
            }
        }
        return new ProviderCache("unknown", (ImmutableMap<Path, HashCode>)ImmutableMap.of());
    }

    public boolean m_253256_(String p_254319_) {
        ProviderCache hashcache$providercache = this.f_252445_.get(p_254319_);
        return hashcache$providercache == null || !hashcache$providercache.f_236126_.equals(this.f_236081_);
    }

    public CompletableFuture<UpdateResult> m_253234_(String p_253944_, UpdateFunction p_254321_) {
        ProviderCache hashcache$providercache = this.f_252445_.get(p_253944_);
        if (hashcache$providercache == null) {
            throw new IllegalStateException("Provider not registered: " + p_253944_);
        }
        CacheUpdater hashcache$cacheupdater = new CacheUpdater(p_253944_, this.f_236081_, hashcache$providercache);
        return p_254321_.m_252999_(hashcache$cacheupdater).thenApply(p_253376_ -> hashcache$cacheupdater.m_253164_());
    }

    public void m_253116_(UpdateResult p_253725_) {
        this.f_252445_.put(p_253725_.f_252422_(), p_253725_.f_252528_());
        this.f_236083_.add(p_253725_.f_252422_());
        this.f_252434_ += p_253725_.f_252492_();
    }

    public void m_123937_() throws IOException {
        HashSet<Path> set = new HashSet<Path>();
        this.f_252445_.forEach((p_253378_, p_253379_) -> {
            if (this.f_236083_.contains(p_253378_)) {
                Path path = this.m_252859_((String)p_253378_);
                if (!p_253379_.equals(this.originalCaches.get(p_253378_)) || !Files.exists(path, new LinkOption[0])) {
                    p_253379_.m_236142_(this.f_236079_, path, DateTimeFormatter.ISO_LOCAL_DATE_TIME.format(LocalDateTime.now()) + "\t" + p_253378_);
                }
            }
            set.addAll((Collection<Path>)p_253379_.f_236127_().keySet());
        });
        set.add(this.f_236079_.resolve("version.json"));
        MutableInt mutableint = new MutableInt();
        MutableInt mutableint1 = new MutableInt();
        try (Stream<Path> stream = Files.walk(this.f_236079_, new FileVisitOption[0]);){
            stream.forEach(p_236106_ -> {
                if (!Files.isDirectory(p_236106_, new LinkOption[0]) && !this.f_236084_.contains(p_236106_)) {
                    mutableint.increment();
                    if (!set.contains(p_236106_)) {
                        try {
                            Files.delete(p_236106_);
                        }
                        catch (IOException ioexception) {
                            f_123926_.warn("Failed to delete file {}", p_236106_, (Object)ioexception);
                        }
                        mutableint1.increment();
                    }
                }
            });
        }
        f_123926_.info("Caching: total files: {}, old count: {}, new count: {}, removed stale: {}, written: {}", new Object[]{mutableint, this.f_236085_, set.size(), mutableint1, this.f_252434_});
    }

    record ProviderCache(String f_236126_, ImmutableMap<Path, HashCode> f_236127_) {
        @Nullable
        public HashCode m_236134_(Path p_236135_) {
            return (HashCode)this.f_236127_.get((Object)p_236135_);
        }

        public int m_236133_() {
            return this.f_236127_.size();
        }

        public static ProviderCache m_236139_(Path p_236140_, Path p_236141_) throws IOException {
            try (BufferedReader bufferedreader = Files.newBufferedReader(p_236141_, StandardCharsets.UTF_8);){
                String s = bufferedreader.readLine();
                if (!s.startsWith(HashCache.f_236078_)) {
                    throw new IllegalStateException("Missing cache file header");
                }
                String[] astring = s.substring(HashCache.f_236078_.length()).split("\t", 2);
                String s1 = astring[0];
                ImmutableMap.Builder builder = ImmutableMap.builder();
                bufferedreader.lines().forEach(p_253382_ -> {
                    int i = p_253382_.indexOf(32);
                    builder.put((Object)p_236140_.resolve(p_253382_.substring(i + 1)), (Object)HashCode.fromString((String)p_253382_.substring(0, i)));
                });
                ProviderCache providerCache = new ProviderCache(s1, (ImmutableMap<Path, HashCode>)builder.build());
                return providerCache;
            }
        }

        public void m_236142_(Path p_236143_, Path p_236144_, String p_236145_) {
            try (BufferedWriter bufferedwriter = Files.newBufferedWriter(p_236144_, StandardCharsets.UTF_8, new OpenOption[0]);){
                bufferedwriter.write(HashCache.f_236078_);
                bufferedwriter.write(this.f_236126_);
                bufferedwriter.write(9);
                bufferedwriter.write(p_236145_);
                bufferedwriter.newLine();
                for (Map.Entry entry : this.f_236127_.entrySet().stream().sorted(Map.Entry.comparingByKey()).toList()) {
                    bufferedwriter.write(((HashCode)entry.getValue()).toString());
                    bufferedwriter.write(32);
                    bufferedwriter.write(p_236143_.relativize((Path)entry.getKey()).toString().replace("\\", "/"));
                    bufferedwriter.newLine();
                }
            }
            catch (IOException ioexception) {
                f_123926_.warn("Unable write cachefile {}: {}", (Object)p_236144_, (Object)ioexception);
            }
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{ProviderCache.class, "version;data", "f_236126_", "f_236127_"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{ProviderCache.class, "version;data", "f_236126_", "f_236127_"}, this);
        }

        @Override
        public final boolean equals(Object p_236153_) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{ProviderCache.class, "version;data", "f_236126_", "f_236127_"}, this, p_236153_);
        }
    }

    class CacheUpdater
    implements CachedOutput {
        private final String f_252505_;
        private final ProviderCache f_236113_;
        private final ProviderCacheBuilder f_236114_;
        private final AtomicInteger f_236115_ = new AtomicInteger();
        private volatile boolean f_252460_;

        CacheUpdater(String p_253971_, String p_254002_, ProviderCache p_254244_) {
            this.f_252505_ = p_253971_;
            this.f_236113_ = p_254244_;
            this.f_236114_ = new ProviderCacheBuilder(p_254002_);
        }

        private boolean m_236119_(Path p_236120_, HashCode p_236121_) {
            return !Objects.equals(this.f_236113_.m_236134_(p_236120_), p_236121_) || !Files.exists(p_236120_, new LinkOption[0]);
        }

        @Override
        public void m_213871_(Path p_236123_, byte[] p_236124_, HashCode p_236125_) throws IOException {
            if (this.f_252460_) {
                throw new IllegalStateException("Cannot write to cache as it has already been closed");
            }
            if (this.m_236119_(p_236123_, p_236125_)) {
                this.f_236115_.incrementAndGet();
                Files.createDirectories(p_236123_.getParent(), new FileAttribute[0]);
                Files.write(p_236123_, p_236124_, new OpenOption[0]);
            }
            this.f_236114_.m_252796_(p_236123_, p_236125_);
        }

        public UpdateResult m_253164_() {
            this.f_252460_ = true;
            return new UpdateResult(this.f_252505_, this.f_236114_.m_252979_(), this.f_236115_.get());
        }
    }

    @FunctionalInterface
    public static interface UpdateFunction {
        public CompletableFuture<?> m_252999_(CachedOutput var1);
    }

    public record UpdateResult(String f_252422_, ProviderCache f_252528_, int f_252492_) {
        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{UpdateResult.class, "providerId;cache;writes", "f_252422_", "f_252528_", "f_252492_"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{UpdateResult.class, "providerId;cache;writes", "f_252422_", "f_252528_", "f_252492_"}, this);
        }

        @Override
        public final boolean equals(Object p_253838_) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{UpdateResult.class, "providerId;cache;writes", "f_252422_", "f_252528_", "f_252492_"}, this, p_253838_);
        }
    }

    record ProviderCacheBuilder(String f_252424_, ConcurrentMap<Path, HashCode> f_252466_) {
        ProviderCacheBuilder(String p_254186_) {
            this(p_254186_, new ConcurrentHashMap<Path, HashCode>());
        }

        public void m_252796_(Path p_254121_, HashCode p_254288_) {
            this.f_252466_.put(p_254121_, p_254288_);
        }

        public ProviderCache m_252979_() {
            return new ProviderCache(this.f_252424_, (ImmutableMap<Path, HashCode>)ImmutableMap.copyOf(this.f_252466_));
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{ProviderCacheBuilder.class, "version;data", "f_252424_", "f_252466_"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{ProviderCacheBuilder.class, "version;data", "f_252424_", "f_252466_"}, this);
        }

        @Override
        public final boolean equals(Object p_254241_) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{ProviderCacheBuilder.class, "version;data", "f_252424_", "f_252466_"}, this, p_254241_);
        }
    }
}

