/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.resources.model;

import com.google.common.base.Preconditions;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.io.BufferedReader;
import java.io.Reader;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.Util;
import net.minecraft.client.color.block.BlockColors;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.block.BlockModelShaper;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.resources.model.AtlasSet;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.model.geometry.GeometryLoaderManager;
import org.slf4j.Logger;

@OnlyIn(value=Dist.CLIENT)
public class ModelManager
implements PreparableReloadListener,
AutoCloseable {
    private static final Logger f_243848_ = LogUtils.getLogger();
    private static final Map<ResourceLocation, ResourceLocation> f_244614_ = Map.of(Sheets.f_110737_, new ResourceLocation("banner_patterns"), Sheets.f_110736_, new ResourceLocation("beds"), Sheets.f_110740_, new ResourceLocation("chests"), Sheets.f_110738_, new ResourceLocation("shield_patterns"), Sheets.f_110739_, new ResourceLocation("signs"), Sheets.f_110735_, new ResourceLocation("shulker_boxes"), Sheets.f_265912_, new ResourceLocation("armor_trims"), Sheets.f_271463_, new ResourceLocation("decorated_pot"), TextureAtlas.f_118259_, new ResourceLocation("blocks"));
    private Map<ResourceLocation, BakedModel> f_119397_ = new HashMap<ResourceLocation, BakedModel>();
    private final AtlasSet f_119398_;
    private final BlockModelShaper f_119399_;
    private final BlockColors f_119401_;
    private int f_119402_;
    private BakedModel f_119403_;
    private Object2IntMap<BlockState> f_119404_;
    private ModelBakery modelBakery;

    public ModelManager(TextureManager p_119406_, BlockColors p_119407_, int p_119408_) {
        this.f_119401_ = p_119407_;
        this.f_119402_ = p_119408_;
        this.f_119399_ = new BlockModelShaper(this);
        this.f_119398_ = new AtlasSet(f_244614_, p_119406_);
    }

    public BakedModel getModel(ResourceLocation modelLocation) {
        return this.f_119397_.getOrDefault(modelLocation, this.f_119403_);
    }

    public BakedModel m_119422_(ModelResourceLocation p_119423_) {
        return this.f_119397_.getOrDefault(p_119423_, this.f_119403_);
    }

    public BakedModel m_119409_() {
        return this.f_119403_;
    }

    public BlockModelShaper m_119430_() {
        return this.f_119399_;
    }

    @Override
    public final CompletableFuture<Void> m_5540_(PreparableReloadListener.PreparationBarrier p_249079_, ResourceManager p_251134_, ProfilerFiller p_250336_, ProfilerFiller p_252324_, Executor p_250550_, Executor p_249221_) {
        p_250336_.m_7242_();
        GeometryLoaderManager.init();
        CompletableFuture<Map<ResourceLocation, BlockModel>> completablefuture = ModelManager.m_246704_(p_251134_, p_250550_);
        CompletableFuture<Map<ResourceLocation, List<ModelBakery.LoadedJson>>> completablefuture1 = ModelManager.m_246899_(p_251134_, p_250550_);
        CompletionStage completablefuture2 = completablefuture.thenCombineAsync(completablefuture1, (p_251201_, p_251281_) -> new ModelBakery(this.f_119401_, p_250336_, (Map<ResourceLocation, BlockModel>)p_251201_, (Map<ResourceLocation, List<ModelBakery.LoadedJson>>)p_251281_), p_250550_);
        Map<ResourceLocation, CompletableFuture<AtlasSet.StitchResult>> map = this.f_119398_.m_247721_(p_251134_, this.f_119402_, p_250550_);
        return ((CompletableFuture)((CompletableFuture)((CompletableFuture)CompletableFuture.allOf((CompletableFuture[])Stream.concat(map.values().stream(), Stream.of(completablefuture2)).toArray(CompletableFuture[]::new)).thenApplyAsync(arg_0 -> this.m_246937_(p_250336_, map, (CompletableFuture)completablefuture2, arg_0), p_250550_)).thenCompose(p_252255_ -> p_252255_.f_244037_.thenApply(p_251581_ -> p_252255_))).thenCompose(p_249079_::m_6769_)).thenAcceptAsync(p_252252_ -> this.m_247616_((ReloadState)p_252252_, p_252324_), p_249221_);
    }

    private static CompletableFuture<Map<ResourceLocation, BlockModel>> m_246704_(ResourceManager p_251361_, Executor p_252189_) {
        return CompletableFuture.supplyAsync(() -> ModelBakery.f_244378_.m_247457_(p_251361_), p_252189_).thenCompose(p_250597_ -> {
            ArrayList<CompletableFuture<Pair>> list = new ArrayList<CompletableFuture<Pair>>(p_250597_.size());
            for (Map.Entry entry : p_250597_.entrySet()) {
                list.add(CompletableFuture.supplyAsync(() -> {
                    Pair pair;
                    block8: {
                        BufferedReader reader = ((Resource)entry.getValue()).m_215508_();
                        try {
                            pair = Pair.of((Object)((ResourceLocation)entry.getKey()), (Object)BlockModel.m_111461_(reader));
                            if (reader == null) break block8;
                        }
                        catch (Throwable throwable) {
                            try {
                                if (reader != null) {
                                    try {
                                        ((Reader)reader).close();
                                    }
                                    catch (Throwable throwable2) {
                                        throwable.addSuppressed(throwable2);
                                    }
                                }
                                throw throwable;
                            }
                            catch (Exception exception) {
                                f_243848_.error("Failed to load model {}", entry.getKey(), (Object)exception);
                                return null;
                            }
                        }
                        ((Reader)reader).close();
                    }
                    return pair;
                }, p_252189_));
            }
            return Util.m_137567_(list).thenApply(p_250813_ -> p_250813_.stream().filter(Objects::nonNull).collect(Collectors.toUnmodifiableMap(Pair::getFirst, Pair::getSecond)));
        });
    }

    private static CompletableFuture<Map<ResourceLocation, List<ModelBakery.LoadedJson>>> m_246899_(ResourceManager p_252084_, Executor p_249943_) {
        return CompletableFuture.supplyAsync(() -> ModelBakery.f_244202_.m_246760_(p_252084_), p_249943_).thenCompose(p_250744_ -> {
            ArrayList<CompletableFuture<Pair>> list = new ArrayList<CompletableFuture<Pair>>(p_250744_.size());
            for (Map.Entry entry : p_250744_.entrySet()) {
                list.add(CompletableFuture.supplyAsync(() -> {
                    List list1 = (List)entry.getValue();
                    ArrayList<ModelBakery.LoadedJson> list2 = new ArrayList<ModelBakery.LoadedJson>(list1.size());
                    for (Resource resource : list1) {
                        try {
                            BufferedReader reader = resource.m_215508_();
                            try {
                                JsonObject jsonobject = GsonHelper.m_13859_(reader);
                                list2.add(new ModelBakery.LoadedJson(resource.m_215506_(), (JsonElement)jsonobject));
                            }
                            finally {
                                if (reader == null) continue;
                                ((Reader)reader).close();
                            }
                        }
                        catch (Exception exception) {
                            f_243848_.error("Failed to load blockstate {} from pack {}", new Object[]{entry.getKey(), resource.m_215506_(), exception});
                        }
                    }
                    return Pair.of((Object)((ResourceLocation)entry.getKey()), list2);
                }, p_249943_));
            }
            return Util.m_137567_(list).thenApply(p_248966_ -> p_248966_.stream().filter(Objects::nonNull).collect(Collectors.toUnmodifiableMap(Pair::getFirst, Pair::getSecond)));
        });
    }

    private ReloadState m_245476_(ProfilerFiller p_252136_, Map<ResourceLocation, AtlasSet.StitchResult> p_250646_, ModelBakery p_248945_) {
        p_252136_.m_6180_("load");
        p_252136_.m_6182_("baking");
        HashMultimap multimap = HashMultimap.create();
        p_248945_.m_245909_((arg_0, arg_1) -> ModelManager.m_246294_(p_250646_, (Multimap)multimap, arg_0, arg_1));
        multimap.asMap().forEach((p_250493_, p_252017_) -> f_243848_.warn("Missing textures in model {}:\n{}", p_250493_, (Object)p_252017_.stream().sorted(Material.f_244523_).map(p_248692_ -> "    " + p_248692_.m_119193_() + ":" + p_248692_.m_119203_()).collect(Collectors.joining("\n"))));
        p_252136_.m_6182_("forge_modify_baking_result");
        ForgeHooksClient.onModifyBakingResult(p_248945_.m_119251_(), (ModelBakery)p_248945_);
        p_252136_.m_6182_("dispatch");
        Map<ResourceLocation, BakedModel> map = p_248945_.m_119251_();
        BakedModel bakedmodel = map.get(ModelBakery.f_119230_);
        IdentityHashMap<BlockState, BakedModel> map1 = new IdentityHashMap<BlockState, BakedModel>();
        for (Block block : BuiltInRegistries.f_256975_) {
            block.m_49965_().m_61056_().forEach(p_250633_ -> {
                ResourceLocation resourcelocation = p_250633_.m_60734_().m_204297_().m_205785_().m_135782_();
                BakedModel bakedmodel1 = map.getOrDefault(BlockModelShaper.m_110889_(resourcelocation, p_250633_), bakedmodel);
                map1.put((BlockState)p_250633_, bakedmodel1);
            });
        }
        CompletableFuture<Void> completablefuture = CompletableFuture.allOf((CompletableFuture[])p_250646_.values().stream().map(AtlasSet.StitchResult::m_246362_).toArray(CompletableFuture[]::new));
        p_252136_.m_7238_();
        p_252136_.m_7241_();
        return new ReloadState(p_248945_, bakedmodel, map1, p_250646_, completablefuture);
    }

    private void m_247616_(ReloadState p_248996_, ProfilerFiller p_251960_) {
        p_251960_.m_7242_();
        p_251960_.m_6180_("upload");
        p_248996_.f_244177_.values().forEach(AtlasSet.StitchResult::m_246239_);
        ModelBakery modelbakery = p_248996_.f_244394_;
        this.f_119397_ = modelbakery.m_119251_();
        this.f_119404_ = modelbakery.m_119355_();
        this.f_119403_ = p_248996_.f_244619_;
        this.modelBakery = modelbakery;
        ForgeHooksClient.onModelBake((ModelManager)this, this.f_119397_, (ModelBakery)modelbakery);
        p_251960_.m_6182_("cache");
        this.f_119399_.m_245515_(p_248996_.f_244561_);
        p_251960_.m_7238_();
        p_251960_.m_7241_();
    }

    public boolean m_119415_(BlockState p_119416_, BlockState p_119417_) {
        int j;
        if (p_119416_ == p_119417_) {
            return false;
        }
        int i = this.f_119404_.getInt((Object)p_119416_);
        if (i != -1 && i == (j = this.f_119404_.getInt((Object)p_119417_))) {
            FluidState fluidstate1;
            FluidState fluidstate = p_119416_.m_60819_();
            return fluidstate != (fluidstate1 = p_119417_.m_60819_());
        }
        return true;
    }

    public TextureAtlas m_119428_(ResourceLocation p_119429_) {
        if (this.f_119398_ == null) {
            throw new RuntimeException("getAtlasTexture called too early!");
        }
        return this.f_119398_.m_245433_(p_119429_);
    }

    @Override
    public void close() {
        this.f_119398_.close();
    }

    public void m_119410_(int p_119411_) {
        this.f_119402_ = p_119411_;
    }

    public ModelBakery getModelBakery() {
        return (ModelBakery)Preconditions.checkNotNull((Object)this.modelBakery, (Object)"Attempted to query model bakery before it has been initialized.");
    }

    private static /* synthetic */ TextureAtlasSprite m_246294_(Map p_249446_, Multimap p_249860_, ResourceLocation p_251469_, Material p_251262_) {
        AtlasSet.StitchResult atlasset$stitchresult = (AtlasSet.StitchResult)p_249446_.get(p_251262_.m_119193_());
        TextureAtlasSprite textureatlassprite = atlasset$stitchresult.m_245551_(p_251262_.m_119203_());
        if (textureatlassprite != null) {
            return textureatlassprite;
        }
        p_249860_.put((Object)p_251469_, (Object)p_251262_);
        return atlasset$stitchresult.m_247223_();
    }

    private /* synthetic */ ReloadState m_246937_(ProfilerFiller p_251601_, Map p_250226_, CompletableFuture p_251585_, Void p_248624_) {
        return this.m_245476_(p_251601_, p_250226_.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, p_248988_ -> (AtlasSet.StitchResult)((CompletableFuture)p_248988_.getValue()).join())), (ModelBakery)p_251585_.join());
    }

    @OnlyIn(value=Dist.CLIENT)
    record ReloadState(ModelBakery f_244394_, BakedModel f_244619_, Map<BlockState, BakedModel> f_244561_, Map<ResourceLocation, AtlasSet.StitchResult> f_244177_, CompletableFuture<Void> f_244037_) {
        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{ReloadState.class, "modelBakery;missingModel;modelCache;atlasPreparations;readyForUpload", "f_244394_", "f_244619_", "f_244561_", "f_244177_", "f_244037_"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{ReloadState.class, "modelBakery;missingModel;modelCache;atlasPreparations;readyForUpload", "f_244394_", "f_244619_", "f_244561_", "f_244177_", "f_244037_"}, this);
        }

        @Override
        public final boolean equals(Object p_251346_) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{ReloadState.class, "modelBakery;missingModel;modelCache;atlasPreparations;readyForUpload", "f_244394_", "f_244619_", "f_244561_", "f_244177_", "f_244037_"}, this, p_251346_);
        }
    }
}

