/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.entity;

import com.google.common.collect.ImmutableMap;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.datafixers.util.Pair;
import com.mojang.math.Axis;
import java.util.Map;
import java.util.stream.Stream;
import net.minecraft.client.model.BoatModel;
import net.minecraft.client.model.ChestBoatModel;
import net.minecraft.client.model.ChestRaftModel;
import net.minecraft.client.model.ListModel;
import net.minecraft.client.model.RaftModel;
import net.minecraft.client.model.WaterPatchModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Quaternionf;

@OnlyIn(value=Dist.CLIENT)
public class BoatRenderer
extends EntityRenderer<Boat> {
    private final Map<Boat.Type, Pair<ResourceLocation, ListModel<Boat>>> f_173934_;

    public BoatRenderer(EntityRendererProvider.Context p_234563_, boolean p_234564_) {
        super(p_234563_);
        this.f_114477_ = 0.8f;
        this.f_173934_ = (Map)Stream.of(Boat.Type.values()).collect(ImmutableMap.toImmutableMap(p_173938_ -> p_173938_, p_247941_ -> Pair.of((Object)new ResourceLocation(BoatRenderer.m_234565_(p_247941_, p_234564_)), this.m_245348_(p_234563_, (Boat.Type)p_247941_, p_234564_))));
    }

    private ListModel<Boat> m_245348_(EntityRendererProvider.Context p_248834_, Boat.Type p_249317_, boolean p_250093_) {
        ModelLayerLocation modellayerlocation = p_250093_ ? ModelLayers.m_233550_(p_249317_) : ModelLayers.m_171289_(p_249317_);
        ModelPart modelpart = p_248834_.m_174023_(modellayerlocation);
        if (p_249317_ == Boat.Type.BAMBOO) {
            return p_250093_ ? new ChestRaftModel(modelpart) : new RaftModel(modelpart);
        }
        return p_250093_ ? new ChestBoatModel(modelpart) : new BoatModel(modelpart);
    }

    private static String m_234565_(Boat.Type p_234566_, boolean p_234567_) {
        return p_234567_ ? "textures/entity/chest_boat/" + p_234566_.m_38429_() + ".png" : "textures/entity/boat/" + p_234566_.m_38429_() + ".png";
    }

    @Override
    public void m_7392_(Boat p_113929_, float p_113930_, float p_113931_, PoseStack p_113932_, MultiBufferSource p_113933_, int p_113934_) {
        float f2;
        p_113932_.m_85836_();
        p_113932_.m_252880_(0.0f, 0.375f, 0.0f);
        p_113932_.m_252781_(Axis.f_252436_.m_252977_(180.0f - p_113930_));
        float f = (float)p_113929_.m_38385_() - p_113931_;
        float f1 = p_113929_.m_38384_() - p_113931_;
        if (f1 < 0.0f) {
            f1 = 0.0f;
        }
        if (f > 0.0f) {
            p_113932_.m_252781_(Axis.f_252529_.m_252977_(Mth.m_14031_(f) * f * f1 / 10.0f * (float)p_113929_.m_38386_()));
        }
        if (!Mth.m_14033_(f2 = p_113929_.m_38352_(p_113931_), 0.0f)) {
            p_113932_.m_252781_(new Quaternionf().setAngleAxis(p_113929_.m_38352_(p_113931_) * ((float)Math.PI / 180), 1.0f, 0.0f, 1.0f));
        }
        Pair<ResourceLocation, ListModel<Boat>> pair = this.getModelWithLocation(p_113929_);
        ResourceLocation resourcelocation = (ResourceLocation)pair.getFirst();
        ListModel listmodel = (ListModel)pair.getSecond();
        p_113932_.m_85841_(-1.0f, -1.0f, 1.0f);
        p_113932_.m_252781_(Axis.f_252436_.m_252977_(90.0f));
        listmodel.m_6973_(p_113929_, p_113931_, 0.0f, -0.1f, 0.0f, 0.0f);
        VertexConsumer vertexconsumer = p_113933_.m_6299_(listmodel.m_103119_(resourcelocation));
        listmodel.m_7695_(p_113932_, vertexconsumer, p_113934_, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        if (!p_113929_.m_5842_()) {
            VertexConsumer vertexconsumer1 = p_113933_.m_6299_(RenderType.m_110478_());
            if (listmodel instanceof WaterPatchModel) {
                WaterPatchModel waterpatchmodel = (WaterPatchModel)((Object)listmodel);
                waterpatchmodel.m_102282_().m_104301_(p_113932_, vertexconsumer1, p_113934_, OverlayTexture.f_118083_);
            }
        }
        p_113932_.m_85849_();
        super.m_7392_(p_113929_, p_113930_, p_113931_, p_113932_, p_113933_, p_113934_);
    }

    @Override
    @Deprecated
    public ResourceLocation m_5478_(Boat p_113927_) {
        return (ResourceLocation)this.getModelWithLocation(p_113927_).getFirst();
    }

    public Pair<ResourceLocation, ListModel<Boat>> getModelWithLocation(Boat boat) {
        return this.f_173934_.get(boat.m_28554_());
    }
}

