/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Axis;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.event.RenderBlockScreenEffectEvent;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.fluids.FluidType;
import org.apache.commons.lang3.tuple.Pair;
import org.joml.Matrix4f;

@OnlyIn(value=Dist.CLIENT)
public class ScreenEffectRenderer {
    private static final ResourceLocation f_110714_ = new ResourceLocation("textures/misc/underwater.png");

    public static void m_110718_(Minecraft p_110719_, PoseStack p_110720_) {
        Pair<BlockState, BlockPos> overlay;
        LocalPlayer player = p_110719_.f_91074_;
        if (!player.f_19794_ && (overlay = ScreenEffectRenderer.getOverlayBlock(player)) != null && !ForgeHooksClient.renderBlockOverlay((Player)player, (PoseStack)p_110720_, (RenderBlockScreenEffectEvent.OverlayType)RenderBlockScreenEffectEvent.OverlayType.BLOCK, (BlockState)((BlockState)overlay.getLeft()), (BlockPos)((BlockPos)overlay.getRight()))) {
            ScreenEffectRenderer.m_173296_(p_110719_.m_91289_().m_110907_().getTexture((BlockState)overlay.getLeft(), p_110719_.f_91073_, (BlockPos)overlay.getRight()), p_110720_);
        }
        if (!p_110719_.f_91074_.m_5833_()) {
            if (p_110719_.f_91074_.m_204029_(FluidTags.f_13131_)) {
                if (!ForgeHooksClient.renderWaterOverlay((Player)player, (PoseStack)p_110720_)) {
                    ScreenEffectRenderer.m_110725_(p_110719_, p_110720_);
                }
            } else if (!player.getEyeInFluidType().isAir()) {
                IClientFluidTypeExtensions.of((FluidType)player.getEyeInFluidType()).renderOverlay(p_110719_, p_110720_);
            }
            if (p_110719_.f_91074_.m_6060_() && !ForgeHooksClient.renderFireOverlay((Player)player, (PoseStack)p_110720_)) {
                ScreenEffectRenderer.m_110728_(p_110719_, p_110720_);
            }
        }
    }

    @Nullable
    private static BlockState m_110716_(Player p_110717_) {
        return (BlockState)ScreenEffectRenderer.getOverlayBlock(p_110717_).getLeft();
    }

    @Nullable
    private static Pair<BlockState, BlockPos> getOverlayBlock(Player p_110717_) {
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
        for (int i = 0; i < 8; ++i) {
            double d0 = p_110717_.m_20185_() + (double)(((float)((i >> 0) % 2) - 0.5f) * p_110717_.m_20205_() * 0.8f);
            double d1 = p_110717_.m_20188_() + (double)(((float)((i >> 1) % 2) - 0.5f) * 0.1f);
            double d2 = p_110717_.m_20189_() + (double)(((float)((i >> 2) % 2) - 0.5f) * p_110717_.m_20205_() * 0.8f);
            blockpos$mutableblockpos.m_122169_(d0, d1, d2);
            BlockState blockstate = p_110717_.m_9236_().m_8055_(blockpos$mutableblockpos);
            if (blockstate.m_60799_() == RenderShape.INVISIBLE || !blockstate.m_60831_(p_110717_.m_9236_(), blockpos$mutableblockpos)) continue;
            return Pair.of((Object)blockstate, (Object)blockpos$mutableblockpos.m_7949_());
        }
        return null;
    }

    private static void m_173296_(TextureAtlasSprite p_173297_, PoseStack p_173298_) {
        RenderSystem.setShaderTexture(0, p_173297_.m_247685_());
        RenderSystem.setShader(GameRenderer::m_172814_);
        BufferBuilder bufferbuilder = Tesselator.m_85913_().m_85915_();
        float f = 0.1f;
        float f1 = -1.0f;
        float f2 = 1.0f;
        float f3 = -1.0f;
        float f4 = 1.0f;
        float f5 = -0.5f;
        float f6 = p_173297_.m_118409_();
        float f7 = p_173297_.m_118410_();
        float f8 = p_173297_.m_118411_();
        float f9 = p_173297_.m_118412_();
        Matrix4f matrix4f = p_173298_.m_85850_().m_252922_();
        bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85818_);
        bufferbuilder.m_252986_(matrix4f, -1.0f, -1.0f, -0.5f).m_85950_(0.1f, 0.1f, 0.1f, 1.0f).m_7421_(f7, f9).m_5752_();
        bufferbuilder.m_252986_(matrix4f, 1.0f, -1.0f, -0.5f).m_85950_(0.1f, 0.1f, 0.1f, 1.0f).m_7421_(f6, f9).m_5752_();
        bufferbuilder.m_252986_(matrix4f, 1.0f, 1.0f, -0.5f).m_85950_(0.1f, 0.1f, 0.1f, 1.0f).m_7421_(f6, f8).m_5752_();
        bufferbuilder.m_252986_(matrix4f, -1.0f, 1.0f, -0.5f).m_85950_(0.1f, 0.1f, 0.1f, 1.0f).m_7421_(f7, f8).m_5752_();
        BufferUploader.m_231202_(bufferbuilder.m_231175_());
    }

    private static void m_110725_(Minecraft p_110726_, PoseStack p_110727_) {
        ScreenEffectRenderer.renderFluid(p_110726_, p_110727_, f_110714_);
    }

    public static void renderFluid(Minecraft p_110726_, PoseStack p_110727_, ResourceLocation texture) {
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.setShaderTexture(0, texture);
        BufferBuilder bufferbuilder = Tesselator.m_85913_().m_85915_();
        BlockPos blockpos = BlockPos.m_274561_(p_110726_.f_91074_.m_20185_(), p_110726_.f_91074_.m_20188_(), p_110726_.f_91074_.m_20189_());
        float f = LightTexture.m_234316_(p_110726_.f_91074_.m_9236_().m_6042_(), p_110726_.f_91074_.m_9236_().m_46803_(blockpos));
        RenderSystem.enableBlend();
        RenderSystem.setShaderColor(f, f, f, 0.1f);
        float f1 = 4.0f;
        float f2 = -1.0f;
        float f3 = 1.0f;
        float f4 = -1.0f;
        float f5 = 1.0f;
        float f6 = -0.5f;
        float f7 = -p_110726_.f_91074_.m_146908_() / 64.0f;
        float f8 = p_110726_.f_91074_.m_146909_() / 64.0f;
        Matrix4f matrix4f = p_110727_.m_85850_().m_252922_();
        bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        bufferbuilder.m_252986_(matrix4f, -1.0f, -1.0f, -0.5f).m_7421_(4.0f + f7, 4.0f + f8).m_5752_();
        bufferbuilder.m_252986_(matrix4f, 1.0f, -1.0f, -0.5f).m_7421_(0.0f + f7, 4.0f + f8).m_5752_();
        bufferbuilder.m_252986_(matrix4f, 1.0f, 1.0f, -0.5f).m_7421_(0.0f + f7, 0.0f + f8).m_5752_();
        bufferbuilder.m_252986_(matrix4f, -1.0f, 1.0f, -0.5f).m_7421_(4.0f + f7, 0.0f + f8).m_5752_();
        BufferUploader.m_231202_(bufferbuilder.m_231175_());
        RenderSystem.setShaderColor(1.0f, 1.0f, 1.0f, 1.0f);
        RenderSystem.disableBlend();
    }

    private static void m_110728_(Minecraft p_110729_, PoseStack p_110730_) {
        BufferBuilder bufferbuilder = Tesselator.m_85913_().m_85915_();
        RenderSystem.setShader(GameRenderer::m_172814_);
        RenderSystem.depthFunc(519);
        RenderSystem.depthMask(false);
        RenderSystem.enableBlend();
        TextureAtlasSprite textureatlassprite = ModelBakery.f_119220_.m_119204_();
        RenderSystem.setShaderTexture(0, textureatlassprite.m_247685_());
        float f = textureatlassprite.m_118409_();
        float f1 = textureatlassprite.m_118410_();
        float f2 = (f + f1) / 2.0f;
        float f3 = textureatlassprite.m_118411_();
        float f4 = textureatlassprite.m_118412_();
        float f5 = (f3 + f4) / 2.0f;
        float f6 = textureatlassprite.m_118417_();
        float f7 = Mth.m_14179_(f6, f, f2);
        float f8 = Mth.m_14179_(f6, f1, f2);
        float f9 = Mth.m_14179_(f6, f3, f5);
        float f10 = Mth.m_14179_(f6, f4, f5);
        float f11 = 1.0f;
        for (int i = 0; i < 2; ++i) {
            p_110730_.m_85836_();
            float f12 = -0.5f;
            float f13 = 0.5f;
            float f14 = -0.5f;
            float f15 = 0.5f;
            float f16 = -0.5f;
            p_110730_.m_252880_((float)(-(i * 2 - 1)) * 0.24f, -0.3f, 0.0f);
            p_110730_.m_252781_(Axis.f_252436_.m_252977_((float)(i * 2 - 1) * 10.0f));
            Matrix4f matrix4f = p_110730_.m_85850_().m_252922_();
            bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85818_);
            bufferbuilder.m_252986_(matrix4f, -0.5f, -0.5f, -0.5f).m_85950_(1.0f, 1.0f, 1.0f, 0.9f).m_7421_(f8, f10).m_5752_();
            bufferbuilder.m_252986_(matrix4f, 0.5f, -0.5f, -0.5f).m_85950_(1.0f, 1.0f, 1.0f, 0.9f).m_7421_(f7, f10).m_5752_();
            bufferbuilder.m_252986_(matrix4f, 0.5f, 0.5f, -0.5f).m_85950_(1.0f, 1.0f, 1.0f, 0.9f).m_7421_(f7, f9).m_5752_();
            bufferbuilder.m_252986_(matrix4f, -0.5f, 0.5f, -0.5f).m_85950_(1.0f, 1.0f, 1.0f, 0.9f).m_7421_(f8, f9).m_5752_();
            BufferUploader.m_231202_(bufferbuilder.m_231175_());
            p_110730_.m_85849_();
        }
        RenderSystem.disableBlend();
        RenderSystem.depthMask(true);
        RenderSystem.depthFunc(515);
    }
}

