/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.multiplayer;

import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.mojang.authlib.GameProfile;
import com.mojang.logging.LogUtils;
import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelException;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.gui.screens.ConnectScreen;
import net.minecraft.client.multiplayer.ServerData;
import net.minecraft.client.multiplayer.resolver.ResolvedServerAddress;
import net.minecraft.client.multiplayer.resolver.ServerAddress;
import net.minecraft.client.multiplayer.resolver.ServerNameResolver;
import net.minecraft.network.Connection;
import net.minecraft.network.ConnectionProtocol;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.handshake.ClientIntentionPacket;
import net.minecraft.network.protocol.status.ClientStatusPacketListener;
import net.minecraft.network.protocol.status.ClientboundPongResponsePacket;
import net.minecraft.network.protocol.status.ClientboundStatusResponsePacket;
import net.minecraft.network.protocol.status.ServerStatus;
import net.minecraft.network.protocol.status.ServerboundPingRequestPacket;
import net.minecraft.network.protocol.status.ServerboundStatusRequestPacket;
import net.minecraft.util.Mth;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.ForgeHooksClient;
import org.slf4j.Logger;

@OnlyIn(value=Dist.CLIENT)
public class ServerStatusPinger {
    static final Splitter f_105448_ = Splitter.on((char)'\u0000').limit(6);
    private static final Logger f_105449_ = LogUtils.getLogger();
    private static final Component f_171810_ = Component.m_237115_("multiplayer.status.cannot_connect").m_130938_(p_265659_ -> p_265659_.m_178520_(-65536));
    private final List<Connection> f_105450_ = Collections.synchronizedList(Lists.newArrayList());

    public void m_105459_(final ServerData p_105460_, final Runnable p_105461_) throws UnknownHostException {
        ServerAddress serveraddress = ServerAddress.m_171864_(p_105460_.f_105363_);
        Optional<InetSocketAddress> optional = ServerNameResolver.f_171881_.m_171890_(serveraddress).map(ResolvedServerAddress::m_142641_);
        if (!optional.isPresent()) {
            this.m_171814_(ConnectScreen.f_169260_, p_105460_);
        } else {
            final InetSocketAddress inetsocketaddress = optional.get();
            final Connection connection = Connection.m_178300_(inetsocketaddress, false);
            this.f_105450_.add(connection);
            p_105460_.f_105365_ = Component.m_237115_("multiplayer.status.pinging");
            p_105460_.f_105366_ = -1L;
            p_105460_.f_105370_ = Collections.emptyList();
            connection.m_129505_(new ClientStatusPacketListener(){
                private boolean f_105475_;
                private boolean f_105476_;
                private long f_105477_;

                @Override
                public void m_6440_(ClientboundStatusResponsePacket p_105489_) {
                    if (this.f_105476_) {
                        connection.m_129507_(Component.m_237115_("multiplayer.status.unrequested"));
                    } else {
                        this.f_105476_ = true;
                        ServerStatus serverstatus = p_105489_.f_134886_();
                        p_105460_.f_105365_ = serverstatus.f_134900_();
                        serverstatus.f_134902_().ifPresentOrElse(p_273307_ -> {
                            p_272776_.f_105368_ = Component.m_237113_(p_273307_.f_134962_());
                            p_272776_.f_105367_ = p_273307_.f_134963_();
                        }, () -> {
                            p_273651_.f_105368_ = Component.m_237115_("multiplayer.status.old");
                            p_273651_.f_105367_ = 0;
                        });
                        serverstatus.f_134901_().ifPresentOrElse(p_273230_ -> {
                            p_272779_.f_105364_ = ServerStatusPinger.m_105466_(p_273230_.f_271178_(), p_273230_.f_271503_());
                            p_272779_.f_263840_ = p_273230_;
                            if (!p_273230_.f_134919_().isEmpty()) {
                                ArrayList<Component> list = new ArrayList<Component>(p_273230_.f_134919_().size());
                                for (GameProfile gameprofile : p_273230_.f_134919_()) {
                                    list.add(Component.m_237113_(gameprofile.getName()));
                                }
                                if (p_273230_.f_134919_().size() < p_273230_.f_271178_()) {
                                    list.add(Component.m_237110_("multiplayer.status.and_more", p_273230_.f_271178_() - p_273230_.f_134919_().size()));
                                }
                                p_272779_.f_105370_ = list;
                            } else {
                                p_272779_.f_105370_ = List.of();
                            }
                        }, () -> {
                            p_273287_.f_105364_ = Component.m_237115_("multiplayer.status.unknown").m_130940_(ChatFormatting.DARK_GRAY);
                        });
                        serverstatus.f_134903_().ifPresent(p_272704_ -> {
                            if (!Arrays.equals(p_272704_.f_271462_(), p_105460_.m_271916_())) {
                                p_105460_.m_271813_(p_272704_.f_271462_());
                                p_105461_.run();
                            }
                        });
                        ForgeHooksClient.processForgeListPingData((ServerStatus)serverstatus, (ServerData)p_105460_);
                        this.f_105477_ = Util.m_137550_();
                        connection.m_129512_(new ServerboundPingRequestPacket(this.f_105477_));
                        this.f_105475_ = true;
                    }
                }

                @Override
                public void m_7017_(ClientboundPongResponsePacket p_105487_) {
                    long i = this.f_105477_;
                    long j = Util.m_137550_();
                    p_105460_.f_105366_ = j - i;
                    connection.m_129507_(Component.m_237115_("multiplayer.status.finished"));
                }

                @Override
                public void m_7026_(Component p_105485_) {
                    if (!this.f_105475_) {
                        ServerStatusPinger.this.m_171814_(p_105485_, p_105460_);
                        ServerStatusPinger.this.m_171811_(inetsocketaddress, p_105460_);
                    }
                }

                @Override
                public boolean m_6198_() {
                    return connection.m_129536_();
                }
            });
            try {
                connection.m_129512_(new ClientIntentionPacket(serveraddress.m_171863_(), serveraddress.m_171866_(), ConnectionProtocol.STATUS));
                connection.m_129512_(new ServerboundStatusRequestPacket());
            }
            catch (Throwable throwable) {
                f_105449_.error("Failed to ping server {}", (Object)serveraddress, (Object)throwable);
            }
        }
    }

    void m_171814_(Component p_171815_, ServerData p_171816_) {
        f_105449_.error("Can't ping {}: {}", (Object)p_171816_.f_105363_, (Object)p_171815_.getString());
        p_171816_.f_105365_ = f_171810_;
        p_171816_.f_105364_ = CommonComponents.f_237098_;
    }

    void m_171811_(final InetSocketAddress p_171812_, final ServerData p_171813_) {
        ((Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().group((EventLoopGroup)Connection.f_129462_.m_13971_())).handler((ChannelHandler)new ChannelInitializer<Channel>(){

            protected void initChannel(Channel p_105498_) {
                try {
                    p_105498_.config().setOption(ChannelOption.TCP_NODELAY, (Object)true);
                }
                catch (ChannelException channelException) {
                    // empty catch block
                }
                p_105498_.pipeline().addLast(new ChannelHandler[]{new SimpleChannelInboundHandler<ByteBuf>(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void channelActive(ChannelHandlerContext p_105506_) throws Exception {
                        super.channelActive(p_105506_);
                        ByteBuf bytebuf = Unpooled.buffer();
                        try {
                            bytebuf.writeByte(254);
                            bytebuf.writeByte(1);
                            bytebuf.writeByte(250);
                            char[] achar = "MC|PingHost".toCharArray();
                            bytebuf.writeShort(achar.length);
                            for (char c0 : achar) {
                                bytebuf.writeChar((int)c0);
                            }
                            bytebuf.writeShort(7 + 2 * p_171812_.getHostName().length());
                            bytebuf.writeByte(127);
                            achar = p_171812_.getHostName().toCharArray();
                            bytebuf.writeShort(achar.length);
                            for (char c1 : achar) {
                                bytebuf.writeChar((int)c1);
                            }
                            bytebuf.writeInt(p_171812_.getPort());
                            p_105506_.channel().writeAndFlush((Object)bytebuf).addListener((GenericFutureListener)ChannelFutureListener.CLOSE_ON_FAILURE);
                        }
                        finally {
                            bytebuf.release();
                        }
                    }

                    protected void channelRead0(ChannelHandlerContext p_105503_, ByteBuf p_105504_) {
                        String s;
                        String[] astring;
                        short short1 = p_105504_.readUnsignedByte();
                        if (short1 == 255 && "\u00a71".equals((astring = (String[])Iterables.toArray((Iterable)f_105448_.split((CharSequence)(s = new String(p_105504_.readBytes(p_105504_.readShort() * 2).array(), StandardCharsets.UTF_16BE))), String.class))[0])) {
                            int i = Mth.m_14059_(astring[1], 0);
                            String s1 = astring[2];
                            String s2 = astring[3];
                            int j = Mth.m_14059_(astring[4], -1);
                            int k = Mth.m_14059_(astring[5], -1);
                            p_171813_.f_105367_ = -1;
                            p_171813_.f_105368_ = Component.m_237113_(s1);
                            p_171813_.f_105365_ = Component.m_237113_(s2);
                            p_171813_.f_105364_ = ServerStatusPinger.m_105466_(j, k);
                            p_171813_.f_263840_ = new ServerStatus.Players(k, j, List.of());
                        }
                        p_105503_.close();
                    }

                    public void exceptionCaught(ChannelHandlerContext p_105511_, Throwable p_105512_) {
                        p_105511_.close();
                    }
                }});
            }
        })).channel(NioSocketChannel.class)).connect(p_171812_.getAddress(), p_171812_.getPort());
    }

    static Component m_105466_(int p_105467_, int p_105468_) {
        return Component.m_237113_(Integer.toString(p_105467_)).m_7220_(Component.m_237113_("/").m_130940_(ChatFormatting.DARK_GRAY)).m_130946_(Integer.toString(p_105468_)).m_130940_(ChatFormatting.GRAY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void m_105453_() {
        List<Connection> list = this.f_105450_;
        synchronized (list) {
            Iterator<Connection> iterator = this.f_105450_.iterator();
            while (iterator.hasNext()) {
                Connection connection = iterator.next();
                if (connection.m_129536_()) {
                    connection.m_129483_();
                    continue;
                }
                iterator.remove();
                connection.m_129541_();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void m_105465_() {
        List<Connection> list = this.f_105450_;
        synchronized (list) {
            Iterator<Connection> iterator = this.f_105450_.iterator();
            while (iterator.hasNext()) {
                Connection connection = iterator.next();
                if (!connection.m_129536_()) continue;
                iterator.remove();
                connection.m_129507_(Component.m_237115_("multiplayer.status.cancelled"));
            }
        }
    }
}

