/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.font.providers;

import com.google.common.annotations.VisibleForTesting;
import com.mojang.blaze3d.font.GlyphInfo;
import com.mojang.blaze3d.font.GlyphProvider;
import com.mojang.blaze3d.font.SheetGlyphInfo;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.bytes.ByteArrayList;
import it.unimi.dsi.fastutil.bytes.ByteList;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.nio.IntBuffer;
import java.util.List;
import java.util.function.Function;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.annotation.Nullable;
import net.minecraft.client.gui.font.CodepointMap;
import net.minecraft.client.gui.font.glyphs.BakedGlyph;
import net.minecraft.client.gui.font.providers.GlyphProviderDefinition;
import net.minecraft.client.gui.font.providers.GlyphProviderType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.FastBufferedInputStream;
import org.lwjgl.system.MemoryUtil;
import org.slf4j.Logger;

public class UnihexProvider
implements GlyphProvider {
    static final Logger f_283764_ = LogUtils.getLogger();
    private static final int f_283936_ = 16;
    private static final int f_283802_ = 2;
    private static final int f_283803_ = 32;
    private static final int f_283929_ = 64;
    private static final int f_283800_ = 96;
    private static final int f_283867_ = 128;
    private final CodepointMap<Glyph> f_283901_;

    UnihexProvider(CodepointMap<Glyph> p_285457_) {
        this.f_283901_ = p_285457_;
    }

    @Override
    @Nullable
    public GlyphInfo m_214022_(int p_285239_) {
        return this.f_283901_.m_284412_(p_285239_);
    }

    @Override
    public IntSet m_6990_() {
        return this.f_283901_.m_284498_();
    }

    @VisibleForTesting
    static void m_284420_(IntBuffer p_285211_, int p_285508_, int p_285312_, int p_285412_) {
        int $$4 = 32 - p_285312_ - 1;
        int $$5 = 32 - p_285412_ - 1;
        for (int $$6 = $$4; $$6 >= $$5; --$$6) {
            if ($$6 >= 32 || $$6 < 0) {
                p_285211_.put(0);
                continue;
            }
            boolean $$7 = (p_285508_ >> $$6 & 1) != 0;
            p_285211_.put($$7 ? -1 : 0);
        }
    }

    static void m_284448_(IntBuffer p_285283_, LineData p_285485_, int p_284940_, int p_284950_) {
        for (int $$4 = 0; $$4 < 16; ++$$4) {
            int $$5 = p_285485_.m_284144_($$4);
            UnihexProvider.m_284420_(p_285283_, $$5, p_284940_, p_284950_);
        }
    }

    @VisibleForTesting
    static void m_284537_(InputStream p_285315_, ReaderOutput p_285353_) throws IOException {
        int $$2 = 0;
        ByteArrayList $$3 = new ByteArrayList(128);
        while (true) {
            boolean $$4 = UnihexProvider.m_284179_(p_285315_, (ByteList)$$3, 58);
            int $$5 = $$3.size();
            if ($$5 == 0 && !$$4) break;
            if (!$$4 || $$5 != 4 && $$5 != 5 && $$5 != 6) {
                throw new IllegalArgumentException("Invalid entry at line " + $$2 + ": expected 4, 5 or 6 hex digits followed by a colon");
            }
            int $$6 = 0;
            for (int $$7 = 0; $$7 < $$5; ++$$7) {
                $$6 = $$6 << 4 | UnihexProvider.m_284556_($$2, $$3.getByte($$7));
            }
            $$3.clear();
            UnihexProvider.m_284179_(p_285315_, (ByteList)$$3, 10);
            int $$8 = $$3.size();
            LineData $$9 = switch ($$8) {
                case 32 -> ByteContents.m_284446_($$2, (ByteList)$$3);
                case 64 -> ShortContents.m_284334_($$2, (ByteList)$$3);
                case 96 -> IntContents.m_284350_($$2, (ByteList)$$3);
                case 128 -> IntContents.m_284358_($$2, (ByteList)$$3);
                default -> throw new IllegalArgumentException("Invalid entry at line " + $$2 + ": expected hex number describing (8,16,24,32) x 16 bitmap, followed by a new line");
            };
            p_285353_.m_284281_($$6, $$9);
            ++$$2;
            $$3.clear();
        }
    }

    static int m_284323_(int p_285205_, ByteList p_285268_, int p_285345_) {
        return UnihexProvider.m_284556_(p_285205_, p_285268_.getByte(p_285345_));
    }

    private static int m_284556_(int p_284952_, byte p_285036_) {
        return switch (p_285036_) {
            case 48 -> 0;
            case 49 -> 1;
            case 50 -> 2;
            case 51 -> 3;
            case 52 -> 4;
            case 53 -> 5;
            case 54 -> 6;
            case 55 -> 7;
            case 56 -> 8;
            case 57 -> 9;
            case 65 -> 10;
            case 66 -> 11;
            case 67 -> 12;
            case 68 -> 13;
            case 69 -> 14;
            case 70 -> 15;
            default -> throw new IllegalArgumentException("Invalid entry at line " + p_284952_ + ": expected hex digit, got " + (char)p_285036_);
        };
    }

    private static boolean m_284179_(InputStream p_284994_, ByteList p_285351_, int p_285177_) throws IOException {
        int $$3;
        while (($$3 = p_284994_.read()) != -1) {
            if ($$3 == p_285177_) {
                return true;
            }
            p_285351_.add((byte)$$3);
        }
        return false;
    }

    public static interface LineData {
        public int m_284144_(int var1);

        public int m_284266_();

        default public int m_284440_() {
            int $$0 = 0;
            for (int $$1 = 0; $$1 < 16; ++$$1) {
                $$0 |= this.m_284144_($$1);
            }
            return $$0;
        }

        default public int m_284261_() {
            int $$5;
            int $$4;
            int $$0 = this.m_284440_();
            int $$1 = this.m_284266_();
            if ($$0 == 0) {
                boolean $$2 = false;
                int $$3 = $$1;
            } else {
                $$4 = Integer.numberOfLeadingZeros($$0);
                $$5 = 32 - Integer.numberOfTrailingZeros($$0) - 1;
            }
            return Dimensions.m_284209_($$4, $$5);
        }
    }

    record ByteContents(byte[] f_283836_) implements LineData
    {
        @Override
        public int m_284144_(int p_285203_) {
            return this.f_283836_[p_285203_] << 24;
        }

        static LineData m_284446_(int p_285080_, ByteList p_285481_) {
            byte[] $$2 = new byte[16];
            int $$3 = 0;
            for (int $$4 = 0; $$4 < 16; ++$$4) {
                byte $$7;
                int $$5 = UnihexProvider.m_284323_(p_285080_, p_285481_, $$3++);
                int $$6 = UnihexProvider.m_284323_(p_285080_, p_285481_, $$3++);
                $$2[$$4] = $$7 = (byte)($$5 << 4 | $$6);
            }
            return new ByteContents($$2);
        }

        @Override
        public int m_284266_() {
            return 8;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{ByteContents.class, "contents", "f_283836_"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{ByteContents.class, "contents", "f_283836_"}, this);
        }

        @Override
        public final boolean equals(Object p_284989_) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{ByteContents.class, "contents", "f_283836_"}, this, p_284989_);
        }
    }

    record ShortContents(short[] f_283874_) implements LineData
    {
        @Override
        public int m_284144_(int p_285158_) {
            return this.f_283874_[p_285158_] << 16;
        }

        static LineData m_284334_(int p_285528_, ByteList p_284958_) {
            short[] $$2 = new short[16];
            int $$3 = 0;
            for (int $$4 = 0; $$4 < 16; ++$$4) {
                short $$9;
                int $$5 = UnihexProvider.m_284323_(p_285528_, p_284958_, $$3++);
                int $$6 = UnihexProvider.m_284323_(p_285528_, p_284958_, $$3++);
                int $$7 = UnihexProvider.m_284323_(p_285528_, p_284958_, $$3++);
                int $$8 = UnihexProvider.m_284323_(p_285528_, p_284958_, $$3++);
                $$2[$$4] = $$9 = (short)($$5 << 12 | $$6 << 8 | $$7 << 4 | $$8);
            }
            return new ShortContents($$2);
        }

        @Override
        public int m_284266_() {
            return 16;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{ShortContents.class, "contents", "f_283874_"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{ShortContents.class, "contents", "f_283874_"}, this);
        }

        @Override
        public final boolean equals(Object p_284987_) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{ShortContents.class, "contents", "f_283874_"}, this, p_284987_);
        }
    }

    static final class IntContents
    extends Record
    implements LineData {
        private final int[] f_283738_;
        private final int f_283787_;
        private static final int f_283925_ = 24;

        private IntContents(int[] f_283738_, int f_283787_) {
            this.f_283738_ = f_283738_;
            this.f_283787_ = f_283787_;
        }

        @Override
        public int m_284144_(int p_285172_) {
            return this.f_283738_[p_285172_];
        }

        static LineData m_284350_(int p_285362_, ByteList p_285123_) {
            int[] $$2 = new int[16];
            int $$3 = 0;
            int $$4 = 0;
            for (int $$5 = 0; $$5 < 16; ++$$5) {
                int $$6 = UnihexProvider.m_284323_(p_285362_, p_285123_, $$4++);
                int $$7 = UnihexProvider.m_284323_(p_285362_, p_285123_, $$4++);
                int $$8 = UnihexProvider.m_284323_(p_285362_, p_285123_, $$4++);
                int $$9 = UnihexProvider.m_284323_(p_285362_, p_285123_, $$4++);
                int $$10 = UnihexProvider.m_284323_(p_285362_, p_285123_, $$4++);
                int $$11 = UnihexProvider.m_284323_(p_285362_, p_285123_, $$4++);
                int $$12 = $$6 << 20 | $$7 << 16 | $$8 << 12 | $$9 << 8 | $$10 << 4 | $$11;
                $$2[$$5] = $$12 << 8;
                $$3 |= $$12;
            }
            return new IntContents($$2, 24);
        }

        public static LineData m_284358_(int p_285222_, ByteList p_285346_) {
            int[] $$2 = new int[16];
            int $$3 = 0;
            int $$4 = 0;
            for (int $$5 = 0; $$5 < 16; ++$$5) {
                int $$14;
                int $$6 = UnihexProvider.m_284323_(p_285222_, p_285346_, $$4++);
                int $$7 = UnihexProvider.m_284323_(p_285222_, p_285346_, $$4++);
                int $$8 = UnihexProvider.m_284323_(p_285222_, p_285346_, $$4++);
                int $$9 = UnihexProvider.m_284323_(p_285222_, p_285346_, $$4++);
                int $$10 = UnihexProvider.m_284323_(p_285222_, p_285346_, $$4++);
                int $$11 = UnihexProvider.m_284323_(p_285222_, p_285346_, $$4++);
                int $$12 = UnihexProvider.m_284323_(p_285222_, p_285346_, $$4++);
                int $$13 = UnihexProvider.m_284323_(p_285222_, p_285346_, $$4++);
                $$2[$$5] = $$14 = $$6 << 28 | $$7 << 24 | $$8 << 20 | $$9 << 16 | $$10 << 12 | $$11 << 8 | $$12 << 4 | $$13;
                $$3 |= $$14;
            }
            return new IntContents($$2, 32);
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{IntContents.class, "contents;bitWidth", "f_283738_", "f_283787_"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{IntContents.class, "contents;bitWidth", "f_283738_", "f_283787_"}, this);
        }

        @Override
        public final boolean equals(Object p_285302_) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{IntContents.class, "contents;bitWidth", "f_283738_", "f_283787_"}, this, p_285302_);
        }

        public int[] f_283738_() {
            return this.f_283738_;
        }

        @Override
        public int m_284266_() {
            return this.f_283787_;
        }
    }

    @FunctionalInterface
    public static interface ReaderOutput {
        public void m_284281_(int var1, LineData var2);
    }

    record Glyph(LineData f_283857_, int f_283887_, int f_283848_) implements GlyphInfo
    {
        public int m_284480_() {
            return this.f_283848_ - this.f_283887_ + 1;
        }

        @Override
        public float m_7403_() {
            return this.m_284480_() / 2 + 1;
        }

        @Override
        public float m_5645_() {
            return 0.5f;
        }

        @Override
        public float m_5619_() {
            return 0.5f;
        }

        @Override
        public BakedGlyph m_213604_(Function<SheetGlyphInfo, BakedGlyph> p_285377_) {
            return p_285377_.apply(new SheetGlyphInfo(){

                @Override
                public float m_213963_() {
                    return 2.0f;
                }

                @Override
                public int m_213962_() {
                    return this.m_284480_();
                }

                @Override
                public int m_213961_() {
                    return 16;
                }

                @Override
                public void m_213958_(int p_285473_, int p_285510_) {
                    IntBuffer $$2 = MemoryUtil.memAllocInt((int)(this.m_284480_() * 16));
                    UnihexProvider.m_284448_($$2, f_283857_, f_283887_, f_283848_);
                    $$2.rewind();
                    GlStateManager.upload(0, p_285473_, p_285510_, this.m_284480_(), 16, NativeImage.Format.RGBA, $$2, MemoryUtil::memFree);
                }

                @Override
                public boolean m_213965_() {
                    return true;
                }
            });
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{Glyph.class, "contents;left;right", "f_283857_", "f_283887_", "f_283848_"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{Glyph.class, "contents;left;right", "f_283857_", "f_283887_", "f_283848_"}, this);
        }

        @Override
        public final boolean equals(Object p_285317_) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{Glyph.class, "contents;left;right", "f_283857_", "f_283887_", "f_283848_"}, this, p_285317_);
        }
    }

    public static class Definition
    implements GlyphProviderDefinition {
        public static final MapCodec<Definition> f_285591_ = RecordCodecBuilder.mapCodec(p_286579_ -> p_286579_.group((App)ResourceLocation.f_135803_.fieldOf("hex_file").forGetter(p_286591_ -> p_286591_.f_285560_), (App)OverrideRange.f_283923_.listOf().fieldOf("size_overrides").forGetter(p_286528_ -> p_286528_.f_285626_)).apply((Applicative)p_286579_, Definition::new));
        private final ResourceLocation f_285560_;
        private final List<OverrideRange> f_285626_;

        private Definition(ResourceLocation p_286378_, List<OverrideRange> p_286770_) {
            this.f_285560_ = p_286378_;
            this.f_285626_ = p_286770_;
        }

        @Override
        public GlyphProviderType m_285843_() {
            return GlyphProviderType.UNIHEX;
        }

        @Override
        public Either<GlyphProviderDefinition.Loader, GlyphProviderDefinition.Reference> m_285782_() {
            return Either.left(this::m_285976_);
        }

        private GlyphProvider m_285976_(ResourceManager p_286472_) throws IOException {
            try (InputStream $$1 = p_286472_.m_215595_(this.f_285560_);){
                UnihexProvider unihexProvider = this.m_285832_($$1);
                return unihexProvider;
            }
        }

        private UnihexProvider m_285832_(InputStream p_286795_) throws IOException {
            CodepointMap<LineData> $$1 = new CodepointMap<LineData>(LineData[]::new, p_286615_ -> new LineData[p_286615_][]);
            ReaderOutput $$2 = $$1::m_284506_;
            try (ZipInputStream $$3 = new ZipInputStream(p_286795_);){
                ZipEntry $$4;
                while (($$4 = $$3.getNextEntry()) != null) {
                    String $$5 = $$4.getName();
                    if (!$$5.endsWith(".hex")) continue;
                    f_283764_.info("Found {}, loading", (Object)$$5);
                    UnihexProvider.m_284537_(new FastBufferedInputStream($$3), $$2);
                }
                CodepointMap<Glyph> $$6 = new CodepointMap<Glyph>(Glyph[]::new, p_286340_ -> new Glyph[p_286340_][]);
                for (OverrideRange $$7 : this.f_285626_) {
                    int $$8 = $$7.f_283797_;
                    int $$9 = $$7.f_283851_;
                    Dimensions $$10 = $$7.f_283891_;
                    for (int $$11 = $$8; $$11 <= $$9; ++$$11) {
                        LineData $$12 = (LineData)$$1.m_284320_($$11);
                        if ($$12 == null) continue;
                        $$6.m_284506_($$11, new Glyph($$12, $$10.f_283768_, $$10.f_283776_));
                    }
                }
                $$1.m_284150_((p_286721_, p_286722_) -> {
                    int $$3 = p_286722_.m_284261_();
                    int $$4 = Dimensions.m_284152_($$3);
                    int $$5 = Dimensions.m_284305_($$3);
                    $$6.m_284506_(p_286721_, new Glyph((LineData)p_286722_, $$4, $$5));
                });
                UnihexProvider unihexProvider = new UnihexProvider($$6);
                return unihexProvider;
            }
        }
    }

    public record Dimensions(int f_283768_, int f_283776_) {
        public static final MapCodec<Dimensions> f_283777_ = RecordCodecBuilder.mapCodec(p_285497_ -> p_285497_.group((App)Codec.INT.fieldOf("left").forGetter(Dimensions::f_283768_), (App)Codec.INT.fieldOf("right").forGetter(Dimensions::f_283776_)).apply((Applicative)p_285497_, Dimensions::new));
        public static final Codec<Dimensions> f_283924_ = f_283777_.codec();

        public int m_284373_() {
            return Dimensions.m_284209_(this.f_283768_, this.f_283776_);
        }

        public static int m_284209_(int p_285339_, int p_285120_) {
            return (p_285339_ & 0xFF) << 8 | p_285120_ & 0xFF;
        }

        public static int m_284152_(int p_285195_) {
            return (byte)(p_285195_ >> 8);
        }

        public static int m_284305_(int p_285419_) {
            return (byte)p_285419_;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{Dimensions.class, "left;right", "f_283768_", "f_283776_"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{Dimensions.class, "left;right", "f_283768_", "f_283776_"}, this);
        }

        @Override
        public final boolean equals(Object p_285019_) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{Dimensions.class, "left;right", "f_283768_", "f_283776_"}, this, p_285019_);
        }
    }

    record OverrideRange(int f_283797_, int f_283851_, Dimensions f_283891_) {
        private static final Codec<OverrideRange> f_283834_ = RecordCodecBuilder.create(p_285088_ -> p_285088_.group((App)ExtraCodecs.f_283896_.fieldOf("from").forGetter(OverrideRange::f_283797_), (App)ExtraCodecs.f_283896_.fieldOf("to").forGetter(OverrideRange::f_283851_), (App)Dimensions.f_283777_.forGetter(OverrideRange::f_283891_)).apply((Applicative)p_285088_, OverrideRange::new));
        public static final Codec<OverrideRange> f_283923_ = ExtraCodecs.m_264370_(f_283834_, p_285215_ -> {
            if (p_285215_.f_283797_ >= p_285215_.f_283851_) {
                return DataResult.error(() -> "Invalid range: [" + p_285095_.f_283797_ + ";" + p_285095_.f_283851_ + "]");
            }
            return DataResult.success((Object)p_285215_);
        });

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{OverrideRange.class, "from;to;dimensions", "f_283797_", "f_283851_", "f_283891_"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{OverrideRange.class, "from;to;dimensions", "f_283797_", "f_283851_", "f_283891_"}, this);
        }

        @Override
        public final boolean equals(Object p_285264_) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{OverrideRange.class, "from;to;dimensions", "f_283797_", "f_283851_", "f_283891_"}, this, p_285264_);
        }
    }
}

