/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.blaze3d.platform;

import com.mojang.blaze3d.platform.DisplayData;
import com.mojang.blaze3d.platform.GLX;
import com.mojang.blaze3d.platform.IconSet;
import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.platform.MacosUtil;
import com.mojang.blaze3d.platform.Monitor;
import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.platform.ScreenManager;
import com.mojang.blaze3d.platform.VideoMode;
import com.mojang.blaze3d.platform.WindowEventHandler;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.logging.LogUtils;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.function.BiConsumer;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.main.SilentInitException;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.resources.IoSupplier;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.loading.ImmediateWindowHandler;
import org.lwjgl.PointerBuffer;
import org.lwjgl.glfw.Callbacks;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.glfw.GLFWErrorCallback;
import org.lwjgl.glfw.GLFWErrorCallbackI;
import org.lwjgl.glfw.GLFWImage;
import org.lwjgl.opengl.GL;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.util.tinyfd.TinyFileDialogs;
import org.slf4j.Logger;

@OnlyIn(value=Dist.CLIENT)
public final class Window
implements AutoCloseable {
    private static final Logger f_85345_ = LogUtils.getLogger();
    private final GLFWErrorCallback f_85346_ = GLFWErrorCallback.create(this::m_85382_);
    private final WindowEventHandler f_85347_;
    private final ScreenManager f_85348_;
    private final long f_85349_;
    private int f_85350_;
    private int f_85351_;
    private int f_85352_;
    private int f_85353_;
    private Optional<VideoMode> f_85354_;
    private boolean f_85355_;
    private boolean f_85356_;
    private int f_85357_;
    private int f_85358_;
    private int f_85359_;
    private int f_85360_;
    private int f_85361_;
    private int f_85362_;
    private int f_85363_;
    private int f_85364_;
    private double f_85365_;
    private String f_85366_ = "";
    private boolean f_85367_;
    private int f_85368_;
    private boolean f_85369_;

    public Window(WindowEventHandler p_85372_, ScreenManager p_85373_, DisplayData p_85374_, @Nullable String p_85375_, String p_85376_) {
        RenderSystem.assertInInitPhase();
        this.f_85348_ = p_85373_;
        this.m_85451_();
        this.m_85403_("Pre startup");
        this.f_85347_ = p_85372_;
        Optional<VideoMode> optional = VideoMode.m_85333_(p_85375_);
        this.f_85354_ = optional.isPresent() ? optional : (p_85374_.f_84007_.isPresent() && p_85374_.f_84008_.isPresent() ? Optional.of(new VideoMode(p_85374_.f_84007_.getAsInt(), p_85374_.f_84008_.getAsInt(), 8, 8, 8, 60)) : Optional.empty());
        this.f_85356_ = this.f_85355_ = p_85374_.f_84009_;
        Monitor monitor = p_85373_.m_85271_(GLFW.glfwGetPrimaryMonitor());
        this.f_85359_ = p_85374_.f_84005_ > 0 ? p_85374_.f_84005_ : 1;
        this.f_85352_ = this.f_85359_;
        this.f_85360_ = p_85374_.f_84006_ > 0 ? p_85374_.f_84006_ : 1;
        this.f_85353_ = this.f_85360_;
        GLFW.glfwDefaultWindowHints();
        GLFW.glfwWindowHint((int)139265, (int)196609);
        GLFW.glfwWindowHint((int)139275, (int)221185);
        GLFW.glfwWindowHint((int)139266, (int)3);
        GLFW.glfwWindowHint((int)139267, (int)2);
        GLFW.glfwWindowHint((int)139272, (int)204801);
        GLFW.glfwWindowHint((int)139270, (int)1);
        this.f_85349_ = ImmediateWindowHandler.setupMinecraftWindow(() -> this.f_85359_, () -> this.f_85360_, () -> p_85376_, () -> this.f_85355_ && monitor != null ? monitor.m_84954_() : 0L);
        if (!ImmediateWindowHandler.positionWindow(Optional.ofNullable(monitor), w -> {
            this.f_85359_ = this.f_85352_ = w;
        }, h -> {
            this.f_85360_ = this.f_85353_ = h;
        }, x -> {
            this.f_85357_ = this.f_85350_ = x;
        }, y -> {
            this.f_85358_ = this.f_85351_ = y;
        })) {
            if (monitor != null) {
                VideoMode videomode = monitor.m_84948_(this.f_85355_ ? this.f_85354_ : Optional.empty());
                this.f_85350_ = this.f_85357_ = monitor.m_84951_() + videomode.m_85332_() / 2 - this.f_85359_ / 2;
                this.f_85351_ = this.f_85358_ = monitor.m_84952_() + videomode.m_85335_() / 2 - this.f_85360_ / 2;
            } else {
                int[] aint1 = new int[1];
                int[] aint = new int[1];
                GLFW.glfwGetWindowPos((long)this.f_85349_, (int[])aint1, (int[])aint);
                this.f_85350_ = this.f_85357_ = aint1[0];
                this.f_85351_ = this.f_85358_ = aint[0];
            }
        }
        GLFW.glfwMakeContextCurrent((long)this.f_85349_);
        Locale locale = Locale.getDefault(Locale.Category.FORMAT);
        Locale.setDefault(Locale.Category.FORMAT, Locale.ROOT);
        GL.createCapabilities();
        Locale.setDefault(Locale.Category.FORMAT, locale);
        this.m_85453_();
        this.m_85452_();
        GLFW.glfwSetFramebufferSizeCallback((long)this.f_85349_, this::m_85415_);
        GLFW.glfwSetWindowPosCallback((long)this.f_85349_, this::m_85388_);
        GLFW.glfwSetWindowSizeCallback((long)this.f_85349_, this::m_85427_);
        GLFW.glfwSetWindowFocusCallback((long)this.f_85349_, this::m_85392_);
        GLFW.glfwSetCursorEnterCallback((long)this.f_85349_, this::m_85419_);
    }

    public int m_85377_() {
        RenderSystem.assertOnRenderThread();
        return GLX._getRefreshRate(this);
    }

    public boolean m_85411_() {
        return GLX._shouldClose(this);
    }

    public static void m_85407_(BiConsumer<Integer, String> p_85408_) {
        RenderSystem.assertInInitPhase();
        try (MemoryStack memorystack = MemoryStack.stackPush();){
            PointerBuffer pointerbuffer = memorystack.mallocPointer(1);
            int i = GLFW.glfwGetError((PointerBuffer)pointerbuffer);
            if (i != 0) {
                long j = pointerbuffer.get();
                String s = j == 0L ? "" : MemoryUtil.memUTF8((long)j);
                p_85408_.accept(i, s);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void m_280655_(PackResources p_281860_, IconSet p_282155_) throws IOException {
        RenderSystem.assertInInitPhase();
        if (Minecraft.f_91002_) {
            MacosUtil.m_247671_(p_282155_.m_280095_(p_281860_));
        } else {
            List<IoSupplier<InputStream>> list = p_282155_.m_280284_(p_281860_);
            ArrayList<ByteBuffer> list1 = new ArrayList<ByteBuffer>(list.size());
            try (MemoryStack memorystack = MemoryStack.stackPush();){
                GLFWImage.Buffer buffer = GLFWImage.malloc((int)list.size(), (MemoryStack)memorystack);
                for (int i = 0; i < list.size(); ++i) {
                    try (NativeImage nativeimage = NativeImage.m_85058_(list.get(i).m_247737_());){
                        ByteBuffer bytebuffer = MemoryUtil.memAlloc((int)(nativeimage.m_84982_() * nativeimage.m_85084_() * 4));
                        list1.add(bytebuffer);
                        bytebuffer.asIntBuffer().put(nativeimage.m_266370_());
                        buffer.position(i);
                        buffer.width(nativeimage.m_84982_());
                        buffer.height(nativeimage.m_85084_());
                        buffer.pixels(bytebuffer);
                        continue;
                    }
                }
                GLFW.glfwSetWindowIcon((long)this.f_85349_, (GLFWImage.Buffer)((GLFWImage.Buffer)buffer.position(0)));
            }
            finally {
                list1.forEach(MemoryUtil::memFree);
            }
        }
    }

    public void m_85403_(String p_85404_) {
        this.f_85366_ = p_85404_;
    }

    private void m_85451_() {
        RenderSystem.assertInInitPhase();
        GLFW.glfwSetErrorCallback(Window::m_85412_);
    }

    private static void m_85412_(int p_85413_, long p_85414_) {
        RenderSystem.assertInInitPhase();
        String s = "GLFW error " + p_85413_ + ": " + MemoryUtil.memUTF8((long)p_85414_);
        TinyFileDialogs.tinyfd_messageBox((CharSequence)"Minecraft", (CharSequence)(s + ".\n\nPlease make sure you have up-to-date drivers (see aka.ms/mcdriver for instructions)."), (CharSequence)"ok", (CharSequence)"error", (boolean)false);
        throw new WindowInitFailed(s);
    }

    public void m_85382_(int p_85383_, long p_85384_) {
        RenderSystem.assertOnRenderThread();
        String s = MemoryUtil.memUTF8((long)p_85384_);
        f_85345_.error("########## GL ERROR ##########");
        f_85345_.error("@ {}", (Object)this.f_85366_);
        f_85345_.error("{}: {}", (Object)p_85383_, (Object)s);
    }

    public void m_85426_() {
        GLFWErrorCallback glfwerrorcallback = GLFW.glfwSetErrorCallback((GLFWErrorCallbackI)this.f_85346_);
        if (glfwerrorcallback != null) {
            glfwerrorcallback.free();
        }
    }

    public void m_85409_(boolean p_85410_) {
        RenderSystem.assertOnRenderThreadOrInit();
        this.f_85369_ = p_85410_;
        GLFW.glfwSwapInterval((int)(p_85410_ ? 1 : 0));
    }

    @Override
    public void close() {
        RenderSystem.assertOnRenderThread();
        Callbacks.glfwFreeCallbacks((long)this.f_85349_);
        this.f_85346_.close();
        GLFW.glfwDestroyWindow((long)this.f_85349_);
        GLFW.glfwTerminate();
    }

    private void m_85388_(long p_85389_, int p_85390_, int p_85391_) {
        this.f_85357_ = p_85390_;
        this.f_85358_ = p_85391_;
    }

    private void m_85415_(long p_85416_, int p_85417_, int p_85418_) {
        if (p_85416_ == this.f_85349_) {
            int i = this.m_85441_();
            int j = this.m_85442_();
            if (p_85417_ != 0 && p_85418_ != 0) {
                this.f_85361_ = p_85417_;
                this.f_85362_ = p_85418_;
                if (this.m_85441_() != i || this.m_85442_() != j) {
                    this.f_85347_.m_5741_();
                }
            }
        }
    }

    private void m_85452_() {
        RenderSystem.assertInInitPhase();
        int[] aint = new int[1];
        int[] aint1 = new int[1];
        GLFW.glfwGetFramebufferSize((long)this.f_85349_, (int[])aint, (int[])aint1);
        this.f_85361_ = aint[0] > 0 ? aint[0] : 1;
        int n = this.f_85362_ = aint1[0] > 0 ? aint1[0] : 1;
        if (this.f_85362_ == 0 || this.f_85361_ == 0) {
            ImmediateWindowHandler.updateFBSize(w -> {
                this.f_85361_ = w;
            }, h -> {
                this.f_85362_ = h;
            });
        }
    }

    private void m_85427_(long p_85428_, int p_85429_, int p_85430_) {
        this.f_85359_ = p_85429_;
        this.f_85360_ = p_85430_;
    }

    private void m_85392_(long p_85393_, boolean p_85394_) {
        if (p_85393_ == this.f_85349_) {
            this.f_85347_.m_7440_(p_85394_);
        }
    }

    private void m_85419_(long p_85420_, boolean p_85421_) {
        if (p_85421_) {
            this.f_85347_.m_5740_();
        }
    }

    public void m_85380_(int p_85381_) {
        this.f_85368_ = p_85381_;
    }

    public int m_85434_() {
        return this.f_85368_;
    }

    public void m_85435_() {
        RenderSystem.flipFrame(this.f_85349_);
        if (this.f_85355_ != this.f_85356_) {
            this.f_85356_ = this.f_85355_;
            this.m_85431_(this.f_85369_);
        }
    }

    public Optional<VideoMode> m_85436_() {
        return this.f_85354_;
    }

    public void m_85405_(Optional<VideoMode> p_85406_) {
        boolean flag = !p_85406_.equals(this.f_85354_);
        this.f_85354_ = p_85406_;
        if (flag) {
            this.f_85367_ = true;
        }
    }

    public void m_85437_() {
        if (this.f_85355_ && this.f_85367_) {
            this.f_85367_ = false;
            this.m_85453_();
            this.f_85347_.m_5741_();
        }
    }

    private void m_85453_() {
        boolean flag;
        RenderSystem.assertInInitPhase();
        boolean bl = flag = GLFW.glfwGetWindowMonitor((long)this.f_85349_) != 0L;
        if (this.f_85355_) {
            Monitor monitor = this.f_85348_.m_85276_(this);
            if (monitor == null) {
                f_85345_.warn("Failed to find suitable monitor for fullscreen mode");
                this.f_85355_ = false;
            } else {
                if (Minecraft.f_91002_) {
                    MacosUtil.m_182517_(this.f_85349_);
                }
                VideoMode videomode = monitor.m_84948_(this.f_85354_);
                if (!flag) {
                    this.f_85350_ = this.f_85357_;
                    this.f_85351_ = this.f_85358_;
                    this.f_85352_ = this.f_85359_;
                    this.f_85353_ = this.f_85360_;
                }
                this.f_85357_ = 0;
                this.f_85358_ = 0;
                this.f_85359_ = videomode.m_85332_();
                this.f_85360_ = videomode.m_85335_();
                GLFW.glfwSetWindowMonitor((long)this.f_85349_, (long)monitor.m_84954_(), (int)this.f_85357_, (int)this.f_85358_, (int)this.f_85359_, (int)this.f_85360_, (int)videomode.m_85341_());
            }
        } else {
            this.f_85357_ = this.f_85350_;
            this.f_85358_ = this.f_85351_;
            this.f_85359_ = this.f_85352_;
            this.f_85360_ = this.f_85353_;
            GLFW.glfwSetWindowMonitor((long)this.f_85349_, (long)0L, (int)this.f_85357_, (int)this.f_85358_, (int)this.f_85359_, (int)this.f_85360_, (int)-1);
        }
    }

    public void m_85438_() {
        this.f_85355_ = !this.f_85355_;
    }

    public void m_166447_(int p_166448_, int p_166449_) {
        this.f_85352_ = p_166448_;
        this.f_85353_ = p_166449_;
        this.f_85355_ = false;
        this.m_85453_();
    }

    private void m_85431_(boolean p_85432_) {
        RenderSystem.assertOnRenderThread();
        try {
            this.m_85453_();
            this.f_85347_.m_5741_();
            this.m_85409_(p_85432_);
            this.m_85435_();
        }
        catch (Exception exception) {
            f_85345_.error("Couldn't toggle fullscreen", (Throwable)exception);
        }
    }

    public int m_85385_(int p_85386_, boolean p_85387_) {
        int i;
        for (i = 1; i != p_85386_ && i < this.f_85361_ && i < this.f_85362_ && this.f_85361_ / (i + 1) >= 320 && this.f_85362_ / (i + 1) >= 240; ++i) {
        }
        if (p_85387_ && i % 2 != 0) {
            ++i;
        }
        return i;
    }

    public void m_85378_(double p_85379_) {
        this.f_85365_ = p_85379_;
        int i = (int)((double)this.f_85361_ / p_85379_);
        this.f_85363_ = (double)this.f_85361_ / p_85379_ > (double)i ? i + 1 : i;
        int j = (int)((double)this.f_85362_ / p_85379_);
        this.f_85364_ = (double)this.f_85362_ / p_85379_ > (double)j ? j + 1 : j;
    }

    public void m_85422_(String p_85423_) {
        GLFW.glfwSetWindowTitle((long)this.f_85349_, (CharSequence)p_85423_);
    }

    public long m_85439_() {
        return this.f_85349_;
    }

    public boolean m_85440_() {
        return this.f_85355_;
    }

    public int m_85441_() {
        return this.f_85361_;
    }

    public int m_85442_() {
        return this.f_85362_;
    }

    public void m_166450_(int p_166451_) {
        this.f_85361_ = p_166451_;
    }

    public void m_166452_(int p_166453_) {
        this.f_85362_ = p_166453_;
    }

    public int m_85443_() {
        return this.f_85359_;
    }

    public int m_85444_() {
        return this.f_85360_;
    }

    public int m_85445_() {
        return this.f_85363_;
    }

    public int m_85446_() {
        return this.f_85364_;
    }

    public int m_85447_() {
        return this.f_85357_;
    }

    public int m_85448_() {
        return this.f_85358_;
    }

    public double m_85449_() {
        return this.f_85365_;
    }

    @Nullable
    public Monitor m_85450_() {
        return this.f_85348_.m_85276_(this);
    }

    public void m_85424_(boolean p_85425_) {
        InputConstants.m_84848_(this.f_85349_, p_85425_);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class WindowInitFailed
    extends SilentInitException {
        WindowInitFailed(String p_85455_) {
            super(p_85455_);
        }
    }
}

