/*
 * Decompiled with CFR 0.152.
 */
package com.machinezoo.noexception;

import java.util.Objects;

public interface CloseableScope
extends AutoCloseable {
    @Override
    public void close();

    default public CloseableScope andThen(Runnable action) {
        Objects.requireNonNull(action);
        return () -> {
            this.close();
            action.run();
        };
    }

    default public CloseableScope andFinally(Runnable action) {
        Objects.requireNonNull(action);
        return () -> {
            Throwable exception = null;
            try {
                this.close();
            }
            catch (Throwable ex) {
                exception = ex;
                throw ex;
            }
            finally {
                if (exception != null) {
                    try {
                        action.run();
                    }
                    catch (Throwable suppressed) {
                        exception.addSuppressed(suppressed);
                    }
                } else {
                    action.run();
                }
            }
        };
    }
}

