/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.server.command;

import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import net.minecraft.commands.CommandRuntimeException;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.DimensionArgument;
import net.minecraft.commands.arguments.coordinates.BlockPosArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraftforge.common.WorldWorkerManager;
import net.minecraftforge.server.command.ChunkGenWorker;

class GenerateCommand {
    GenerateCommand() {
    }

    static ArgumentBuilder<CommandSourceStack, ?> register() {
        return ((LiteralArgumentBuilder)Commands.literal("generate").requires(cs -> cs.hasPermission(4))).then(Commands.argument("pos", BlockPosArgument.blockPos()).then(((RequiredArgumentBuilder)Commands.argument("count", IntegerArgumentType.integer((int)1)).then(((RequiredArgumentBuilder)Commands.argument("dim", DimensionArgument.dimension()).then(Commands.argument("interval", IntegerArgumentType.integer()).executes(ctx -> GenerateCommand.execute((CommandSourceStack)ctx.getSource(), BlockPosArgument.getSpawnablePos((CommandContext<CommandSourceStack>)ctx, "pos"), GenerateCommand.getInt((CommandContext<CommandSourceStack>)ctx, "count"), DimensionArgument.getDimension((CommandContext<CommandSourceStack>)ctx, "dim"), GenerateCommand.getInt((CommandContext<CommandSourceStack>)ctx, "interval"))))).executes(ctx -> GenerateCommand.execute((CommandSourceStack)ctx.getSource(), BlockPosArgument.getSpawnablePos((CommandContext<CommandSourceStack>)ctx, "pos"), GenerateCommand.getInt((CommandContext<CommandSourceStack>)ctx, "count"), DimensionArgument.getDimension((CommandContext<CommandSourceStack>)ctx, "dim"), -1)))).executes(ctx -> GenerateCommand.execute((CommandSourceStack)ctx.getSource(), BlockPosArgument.getSpawnablePos((CommandContext<CommandSourceStack>)ctx, "pos"), GenerateCommand.getInt((CommandContext<CommandSourceStack>)ctx, "count"), ((CommandSourceStack)ctx.getSource()).getLevel(), -1))));
    }

    private static int getInt(CommandContext<CommandSourceStack> ctx, String name) {
        return IntegerArgumentType.getInteger(ctx, (String)name);
    }

    private static int execute(CommandSourceStack source, BlockPos pos, int count, ServerLevel dim, int interval) throws CommandRuntimeException {
        BlockPos chunkpos = new BlockPos(pos.getX() >> 4, 0, pos.getZ() >> 4);
        ChunkGenWorker worker = new ChunkGenWorker(source, chunkpos, count, dim, interval);
        source.sendSuccess(() -> worker.getStartMessage(source), true);
        WorldWorkerManager.addWorker(worker);
        return 0;
    }
}

