/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common.data;

import java.util.Locale;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.PackOutput;
import net.minecraft.data.tags.IntrinsicHolderTagsProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.data.BlockTagsProvider;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;

public final class ForgeBlockTagsProvider
extends BlockTagsProvider {
    public ForgeBlockTagsProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> lookupProvider, @Nullable ExistingFileHelper existingFileHelper) {
        super(output, lookupProvider, "forge", existingFileHelper);
    }

    @Override
    public void addTags(HolderLookup.Provider p_256380_) {
        ((IntrinsicHolderTagsProvider.IntrinsicTagAppender)this.tag((TagKey)Tags.Blocks.BARRELS)).addTag((TagKey)Tags.Blocks.BARRELS_WOODEN);
        ((IntrinsicHolderTagsProvider.IntrinsicTagAppender)this.tag((TagKey)Tags.Blocks.BARRELS_WOODEN)).add(Blocks.BARREL);
        ((IntrinsicHolderTagsProvider.IntrinsicTagAppender)this.tag((TagKey)Tags.Blocks.BOOKSHELVES)).add(Blocks.BOOKSHELF);
        this.tag((TagKey)Tags.Blocks.CHESTS).addTags(new TagKey[]{Tags.Blocks.CHESTS_ENDER, Tags.Blocks.CHESTS_TRAPPED, Tags.Blocks.CHESTS_WOODEN});
        ((IntrinsicHolderTagsProvider.IntrinsicTagAppender)this.tag((TagKey)Tags.Blocks.CHESTS_ENDER)).add(Blocks.ENDER_CHEST);
        ((IntrinsicHolderTagsProvider.IntrinsicTagAppender)this.tag((TagKey)Tags.Blocks.CHESTS_TRAPPED)).add(Blocks.TRAPPED_CHEST);
        ((IntrinsicHolderTagsProvider.IntrinsicTagAppender)this.tag((TagKey)Tags.Blocks.CHESTS_WOODEN)).add(Blocks.CHEST, Blocks.TRAPPED_CHEST);
        this.tag((TagKey)Tags.Blocks.CHORUS_ADDITIONALLY_GROWS_ON).addTags(new TagKey[]{Tags.Blocks.END_STONES});
        this.tag((TagKey)Tags.Blocks.COBBLESTONE).addTags(new TagKey[]{Tags.Blocks.COBBLESTONE_NORMAL, Tags.Blocks.COBBLESTONE_INFESTED, Tags.Blocks.COBBLESTONE_MOSSY, Tags.Blocks.COBBLESTONE_DEEPSLATE});
        ((IntrinsicHolderTagsProvider.IntrinsicTagAppender)this.tag((TagKey)Tags.Blocks.COBBLESTONE_NORMAL)).add(Blocks.COBBLESTONE);
        ((IntrinsicHolderTagsProvider.IntrinsicTagAppender)this.tag((TagKey)Tags.Blocks.COBBLESTONE_INFESTED)).add(Blocks.INFESTED_COBBLESTONE);
        ((IntrinsicHolderTagsProvider.IntrinsicTagAppender)this.tag((TagKey)Tags.Blocks.COBBLESTONE_MOSSY)).add(Blocks.MOSSY_COBBLESTONE);
        ((IntrinsicHolderTagsProvider.IntrinsicTagAppender)this.tag((TagKey)Tags.Blocks.COBBLESTONE_DEEPSLATE)).add(Blocks.COBBLED_DEEPSLATE);
        ((IntrinsicHolderTagsProvider.IntrinsicTagAppender)this.tag((TagKey)Tags.Blocks.END_STONES)).add(Blocks.END_STONE);
        this.tag((TagKey)Tags.Blocks.ENDERMAN_PLACE_ON_BLACKLIST);
        this.tag((TagKey)Tags.Blocks.FENCE_GATES).addTags(new TagKey[]{Tags.Blocks.FENCE_GATES_WOODEN});
        ((IntrinsicHolderTagsProvider.IntrinsicTagAppender)this.tag((TagKey)Tags.Blocks.FENCE_GATES_WOODEN)).add(Blocks.OAK_FENCE_GATE, Blocks.SPRUCE_FENCE_GATE, Blocks.BIRCH_FENCE_GATE, Blocks.JUNGLE_FENCE_GATE, Blocks.ACACIA_FENCE_GATE, Blocks.DARK_OAK_FENCE_GATE, Blocks.CRIMSON_FENCE_GATE, Blocks.WARPED_FENCE_GATE, Blocks.MANGROVE_FENCE_GATE, Blocks.BAMBOO_FENCE_GATE, Blocks.CHERRY_FENCE_GATE);
        this.tag((TagKey)Tags.Blocks.FENCES).addTags(new TagKey[]{Tags.Blocks.FENCES_NETHER_BRICK, Tags.Blocks.FENCES_WOODEN});
        ((IntrinsicHolderTagsProvider.IntrinsicTagAppender)this.tag((TagKey)Tags.Blocks.FENCES_NETHER_BRICK)).add(Blocks.NETHER_BRICK_FENCE);
        ((IntrinsicHolderTagsProvider.IntrinsicTagAppender)this.tag((TagKey)Tags.Blocks.FENCES_WOODEN)).addTag((TagKey)BlockTags.WOODEN_FENCES);
        this.tag((TagKey)Tags.Blocks.GLASS).addTags(new TagKey[]{Tags.Blocks.GLASS_COLORLESS, Tags.Blocks.STAINED_GLASS, Tags.Blocks.GLASS_TINTED});
        ((IntrinsicHolderTagsProvider.IntrinsicTagAppender)this.tag((TagKey)Tags.Blocks.GLASS_COLORLESS)).add(Blocks.GLASS);
        ((IntrinsicHolderTagsProvider.IntrinsicTagAppender)this.tag((TagKey)Tags.Blocks.GLASS_SILICA)).add(Blocks.GLASS, Blocks.BLACK_STAINED_GLASS, Blocks.BLUE_STAINED_GLASS, Blocks.BROWN_STAINED_GLASS, Blocks.CYAN_STAINED_GLASS, Blocks.GRAY_STAINED_GLASS, Blocks.GREEN_STAINED_GLASS, Blocks.LIGHT_BLUE_STAINED_GLASS, Blocks.LIGHT_GRAY_STAINED_GLASS, Blocks.LIME_STAINED_GLASS, Blocks.MAGENTA_STAINED_GLASS, Blocks.ORANGE_STAINED_GLASS, Blocks.PINK_STAINED_GLASS, Blocks.PURPLE_STAINED_GLASS, Blocks.RED_STAINED_GLASS, Blocks.WHITE_STAINED_GLASS, Blocks.YELLOW_STAINED_GLASS);
        ((IntrinsicHolderTagsProvider.IntrinsicTagAppender)this.tag((TagKey)Tags.Blocks.GLASS_TINTED)).add(Blocks.TINTED_GLASS);
        this.addColored(((IntrinsicHolderTagsProvider.IntrinsicTagAppender)this.tag((TagKey)Tags.Blocks.STAINED_GLASS))::add, Tags.Blocks.GLASS, "{color}_stained_glass");
        this.tag((TagKey)Tags.Blocks.GLASS_PANES).addTags(new TagKey[]{Tags.Blocks.GLASS_PANES_COLORLESS, Tags.Blocks.STAINED_GLASS_PANES});
        ((IntrinsicHolderTagsProvider.IntrinsicTagAppender)this.tag((TagKey)Tags.Blocks.GLASS_PANES_COLORLESS)).add(Blocks.GLASS_PANE);
        this.addColored(((IntrinsicHolderTagsProvider.IntrinsicTagAppender)this.tag((TagKey)Tags.Blocks.STAINED_GLASS_PANES))::add, Tags.Blocks.GLASS_PANES, "{color}_stained_glass_pane");
        ((IntrinsicHolderTagsProvider.IntrinsicTagAppender)this.tag((TagKey)Tags.Blocks.GRAVEL)).add(Blocks.GRAVEL);
        ((IntrinsicHolderTagsProvider.IntrinsicTagAppender)this.tag((TagKey)Tags.Blocks.NETHERRACK)).add(Blocks.NETHERRACK);
        ((IntrinsicHolderTagsProvider.IntrinsicTagAppender)this.tag((TagKey)Tags.Blocks.OBSIDIAN)).add(Blocks.OBSIDIAN);
        ((IntrinsicHolderTagsProvider.IntrinsicTagAppender)this.tag((TagKey)Tags.Blocks.ORE_BEARING_GROUND_DEEPSLATE)).add(Blocks.DEEPSLATE);
        ((IntrinsicHolderTagsProvider.IntrinsicTagAppender)this.tag((TagKey)Tags.Blocks.ORE_BEARING_GROUND_NETHERRACK)).add(Blocks.NETHERRACK);
        ((IntrinsicHolderTagsProvider.IntrinsicTagAppender)this.tag((TagKey)Tags.Blocks.ORE_BEARING_GROUND_STONE)).add(Blocks.STONE);
        ((IntrinsicHolderTagsProvider.IntrinsicTagAppender)this.tag((TagKey)Tags.Blocks.ORE_RATES_DENSE)).add(Blocks.COPPER_ORE, Blocks.DEEPSLATE_COPPER_ORE, Blocks.DEEPSLATE_LAPIS_ORE, Blocks.DEEPSLATE_REDSTONE_ORE, Blocks.LAPIS_ORE, Blocks.REDSTONE_ORE);
        ((IntrinsicHolderTagsProvider.IntrinsicTagAppender)this.tag((TagKey)Tags.Blocks.ORE_RATES_SINGULAR)).add(Blocks.ANCIENT_DEBRIS, Blocks.COAL_ORE, Blocks.DEEPSLATE_COAL_ORE, Blocks.DEEPSLATE_DIAMOND_ORE, Blocks.DEEPSLATE_EMERALD_ORE, Blocks.DEEPSLATE_GOLD_ORE, Blocks.DEEPSLATE_IRON_ORE, Blocks.DIAMOND_ORE, Blocks.EMERALD_ORE, Blocks.GOLD_ORE, Blocks.IRON_ORE, Blocks.NETHER_QUARTZ_ORE);
        ((IntrinsicHolderTagsProvider.IntrinsicTagAppender)this.tag((TagKey)Tags.Blocks.ORE_RATES_SPARSE)).add(Blocks.NETHER_GOLD_ORE);
        this.tag((TagKey)Tags.Blocks.ORES).addTags(new TagKey[]{Tags.Blocks.ORES_COAL, Tags.Blocks.ORES_COPPER, Tags.Blocks.ORES_DIAMOND, Tags.Blocks.ORES_EMERALD, Tags.Blocks.ORES_GOLD, Tags.Blocks.ORES_IRON, Tags.Blocks.ORES_LAPIS, Tags.Blocks.ORES_REDSTONE, Tags.Blocks.ORES_QUARTZ, Tags.Blocks.ORES_NETHERITE_SCRAP});
        ((IntrinsicHolderTagsProvider.IntrinsicTagAppender)this.tag((TagKey)Tags.Blocks.ORES_COAL)).addTag((TagKey)BlockTags.COAL_ORES);
        ((IntrinsicHolderTagsProvider.IntrinsicTagAppender)this.tag((TagKey)Tags.Blocks.ORES_COPPER)).addTag((TagKey)BlockTags.COPPER_ORES);
        ((IntrinsicHolderTagsProvider.IntrinsicTagAppender)this.tag((TagKey)Tags.Blocks.ORES_DIAMOND)).addTag((TagKey)BlockTags.DIAMOND_ORES);
        ((IntrinsicHolderTagsProvider.IntrinsicTagAppender)this.tag((TagKey)Tags.Blocks.ORES_EMERALD)).addTag((TagKey)BlockTags.EMERALD_ORES);
        ((IntrinsicHolderTagsProvider.IntrinsicTagAppender)this.tag((TagKey)Tags.Blocks.ORES_GOLD)).addTag((TagKey)BlockTags.GOLD_ORES);
        ((IntrinsicHolderTagsProvider.IntrinsicTagAppender)this.tag((TagKey)Tags.Blocks.ORES_IRON)).addTag((TagKey)BlockTags.IRON_ORES);
        ((IntrinsicHolderTagsProvider.IntrinsicTagAppender)this.tag((TagKey)Tags.Blocks.ORES_LAPIS)).addTag((TagKey)BlockTags.LAPIS_ORES);
        ((IntrinsicHolderTagsProvider.IntrinsicTagAppender)this.tag((TagKey)Tags.Blocks.ORES_QUARTZ)).add(Blocks.NETHER_QUARTZ_ORE);
        ((IntrinsicHolderTagsProvider.IntrinsicTagAppender)this.tag((TagKey)Tags.Blocks.ORES_REDSTONE)).addTag((TagKey)BlockTags.REDSTONE_ORES);
        ((IntrinsicHolderTagsProvider.IntrinsicTagAppender)this.tag((TagKey)Tags.Blocks.ORES_NETHERITE_SCRAP)).add(Blocks.ANCIENT_DEBRIS);
        ((IntrinsicHolderTagsProvider.IntrinsicTagAppender)this.tag((TagKey)Tags.Blocks.ORES_IN_GROUND_DEEPSLATE)).add(Blocks.DEEPSLATE_COAL_ORE, Blocks.DEEPSLATE_COPPER_ORE, Blocks.DEEPSLATE_DIAMOND_ORE, Blocks.DEEPSLATE_EMERALD_ORE, Blocks.DEEPSLATE_GOLD_ORE, Blocks.DEEPSLATE_IRON_ORE, Blocks.DEEPSLATE_LAPIS_ORE, Blocks.DEEPSLATE_REDSTONE_ORE);
        ((IntrinsicHolderTagsProvider.IntrinsicTagAppender)this.tag((TagKey)Tags.Blocks.ORES_IN_GROUND_NETHERRACK)).add(Blocks.NETHER_GOLD_ORE, Blocks.NETHER_QUARTZ_ORE);
        ((IntrinsicHolderTagsProvider.IntrinsicTagAppender)this.tag((TagKey)Tags.Blocks.ORES_IN_GROUND_STONE)).add(Blocks.COAL_ORE, Blocks.COPPER_ORE, Blocks.DIAMOND_ORE, Blocks.EMERALD_ORE, Blocks.GOLD_ORE, Blocks.IRON_ORE, Blocks.LAPIS_ORE, Blocks.REDSTONE_ORE);
        this.tag((TagKey)Tags.Blocks.SAND).addTags(new TagKey[]{Tags.Blocks.SAND_COLORLESS, Tags.Blocks.SAND_RED});
        ((IntrinsicHolderTagsProvider.IntrinsicTagAppender)this.tag((TagKey)Tags.Blocks.SAND_COLORLESS)).add(Blocks.SAND);
        ((IntrinsicHolderTagsProvider.IntrinsicTagAppender)this.tag((TagKey)Tags.Blocks.SAND_RED)).add(Blocks.RED_SAND);
        ((IntrinsicHolderTagsProvider.IntrinsicTagAppender)this.tag((TagKey)Tags.Blocks.SANDSTONE)).add(Blocks.SANDSTONE, Blocks.CUT_SANDSTONE, Blocks.CHISELED_SANDSTONE, Blocks.SMOOTH_SANDSTONE, Blocks.RED_SANDSTONE, Blocks.CUT_RED_SANDSTONE, Blocks.CHISELED_RED_SANDSTONE, Blocks.SMOOTH_RED_SANDSTONE);
        ((IntrinsicHolderTagsProvider.IntrinsicTagAppender)this.tag((TagKey)Tags.Blocks.STONE)).add(Blocks.ANDESITE, Blocks.DIORITE, Blocks.GRANITE, Blocks.INFESTED_STONE, Blocks.STONE, Blocks.POLISHED_ANDESITE, Blocks.POLISHED_DIORITE, Blocks.POLISHED_GRANITE, Blocks.DEEPSLATE, Blocks.POLISHED_DEEPSLATE, Blocks.INFESTED_DEEPSLATE, Blocks.TUFF);
        this.tag((TagKey)Tags.Blocks.STORAGE_BLOCKS).addTags(new TagKey[]{Tags.Blocks.STORAGE_BLOCKS_AMETHYST, Tags.Blocks.STORAGE_BLOCKS_COAL, Tags.Blocks.STORAGE_BLOCKS_COPPER, Tags.Blocks.STORAGE_BLOCKS_DIAMOND, Tags.Blocks.STORAGE_BLOCKS_EMERALD, Tags.Blocks.STORAGE_BLOCKS_GOLD, Tags.Blocks.STORAGE_BLOCKS_IRON, Tags.Blocks.STORAGE_BLOCKS_LAPIS, Tags.Blocks.STORAGE_BLOCKS_QUARTZ, Tags.Blocks.STORAGE_BLOCKS_RAW_COPPER, Tags.Blocks.STORAGE_BLOCKS_RAW_GOLD, Tags.Blocks.STORAGE_BLOCKS_RAW_IRON, Tags.Blocks.STORAGE_BLOCKS_REDSTONE, Tags.Blocks.STORAGE_BLOCKS_NETHERITE});
        ((IntrinsicHolderTagsProvider.IntrinsicTagAppender)this.tag((TagKey)Tags.Blocks.STORAGE_BLOCKS_AMETHYST)).add(Blocks.AMETHYST_BLOCK);
        ((IntrinsicHolderTagsProvider.IntrinsicTagAppender)this.tag((TagKey)Tags.Blocks.STORAGE_BLOCKS_COAL)).add(Blocks.COAL_BLOCK);
        ((IntrinsicHolderTagsProvider.IntrinsicTagAppender)this.tag((TagKey)Tags.Blocks.STORAGE_BLOCKS_COPPER)).add(Blocks.COPPER_BLOCK);
        ((IntrinsicHolderTagsProvider.IntrinsicTagAppender)this.tag((TagKey)Tags.Blocks.STORAGE_BLOCKS_DIAMOND)).add(Blocks.DIAMOND_BLOCK);
        ((IntrinsicHolderTagsProvider.IntrinsicTagAppender)this.tag((TagKey)Tags.Blocks.STORAGE_BLOCKS_EMERALD)).add(Blocks.EMERALD_BLOCK);
        ((IntrinsicHolderTagsProvider.IntrinsicTagAppender)this.tag((TagKey)Tags.Blocks.STORAGE_BLOCKS_GOLD)).add(Blocks.GOLD_BLOCK);
        ((IntrinsicHolderTagsProvider.IntrinsicTagAppender)this.tag((TagKey)Tags.Blocks.STORAGE_BLOCKS_IRON)).add(Blocks.IRON_BLOCK);
        ((IntrinsicHolderTagsProvider.IntrinsicTagAppender)this.tag((TagKey)Tags.Blocks.STORAGE_BLOCKS_LAPIS)).add(Blocks.LAPIS_BLOCK);
        ((IntrinsicHolderTagsProvider.IntrinsicTagAppender)this.tag((TagKey)Tags.Blocks.STORAGE_BLOCKS_QUARTZ)).add(Blocks.QUARTZ_BLOCK);
        ((IntrinsicHolderTagsProvider.IntrinsicTagAppender)this.tag((TagKey)Tags.Blocks.STORAGE_BLOCKS_RAW_COPPER)).add(Blocks.RAW_COPPER_BLOCK);
        ((IntrinsicHolderTagsProvider.IntrinsicTagAppender)this.tag((TagKey)Tags.Blocks.STORAGE_BLOCKS_RAW_GOLD)).add(Blocks.RAW_GOLD_BLOCK);
        ((IntrinsicHolderTagsProvider.IntrinsicTagAppender)this.tag((TagKey)Tags.Blocks.STORAGE_BLOCKS_RAW_IRON)).add(Blocks.RAW_IRON_BLOCK);
        ((IntrinsicHolderTagsProvider.IntrinsicTagAppender)this.tag((TagKey)Tags.Blocks.STORAGE_BLOCKS_REDSTONE)).add(Blocks.REDSTONE_BLOCK);
        ((IntrinsicHolderTagsProvider.IntrinsicTagAppender)this.tag((TagKey)Tags.Blocks.STORAGE_BLOCKS_NETHERITE)).add(Blocks.NETHERITE_BLOCK);
    }

    private void addColored(Consumer<Block> consumer, TagKey<Block> group, String pattern) {
        String prefix = group.location().getPath().toUpperCase(Locale.ENGLISH) + "_";
        for (DyeColor color : DyeColor.values()) {
            ResourceLocation key = new ResourceLocation("minecraft", pattern.replace("{color}", color.getName()));
            TagKey<Block> tag = this.getForgeTag(prefix + color.getName());
            Block block = ForgeRegistries.BLOCKS.getValue(key);
            if (block == null || block == Blocks.AIR) {
                throw new IllegalStateException("Unknown vanilla block: " + key.toString());
            }
            ((IntrinsicHolderTagsProvider.IntrinsicTagAppender)this.tag((TagKey)tag)).add(block);
            consumer.accept(block);
        }
    }

    private TagKey<Block> getForgeTag(String name) {
        try {
            name = name.toUpperCase(Locale.ENGLISH);
            return (TagKey)Tags.Blocks.class.getDeclaredField(name).get(null);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
            throw new IllegalStateException(Tags.Blocks.class.getName() + " is missing tag name: " + name);
        }
    }

    @Override
    public String getName() {
        return "Forge Block Tags";
    }
}

