/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client.loading;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.BufferVertexConsumer;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.blaze3d.vertex.VertexSorting;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.LoadingOverlay;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ReloadInstance;
import net.minecraft.util.Mth;
import net.minecraftforge.fml.StartupMessageManager;
import net.minecraftforge.fml.earlydisplay.ColourScheme;
import net.minecraftforge.fml.earlydisplay.DisplayWindow;
import net.minecraftforge.fml.loading.progress.ProgressMeter;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;
import org.lwjgl.opengl.GL30C;

public class ForgeLoadingOverlay
extends LoadingOverlay {
    private final Minecraft minecraft;
    private final ReloadInstance reload;
    private final Consumer<Optional<Throwable>> onFinish;
    private final DisplayWindow displayWindow;
    private final ProgressMeter progress;
    private long fadeOutStart = -1L;

    public ForgeLoadingOverlay(Minecraft mc, ReloadInstance reloader, Consumer<Optional<Throwable>> errorConsumer, DisplayWindow displayWindow) {
        super(mc, reloader, errorConsumer, false);
        this.minecraft = mc;
        this.reload = reloader;
        this.onFinish = errorConsumer;
        this.displayWindow = displayWindow;
        displayWindow.addMojangTexture(mc.getTextureManager().getTexture(new ResourceLocation("textures/gui/title/mojangstudios.png")).getId());
        this.progress = StartupMessageManager.prependProgressBar((String)"Minecraft Progress", (int)100);
    }

    public static Supplier<LoadingOverlay> newInstance(Supplier<Minecraft> mc, Supplier<ReloadInstance> ri, Consumer<Optional<Throwable>> handler, DisplayWindow window) {
        return () -> new ForgeLoadingOverlay((Minecraft)mc.get(), (ReloadInstance)ri.get(), handler, window);
    }

    @Override
    public void render(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        long millis = Util.getMillis();
        float fadeouttimer = this.fadeOutStart > -1L ? (float)(millis - this.fadeOutStart) / 1000.0f : -1.0f;
        this.progress.setAbsolute(Mth.clamp((int)(this.reload.getActualProgress() * 100.0f), 0, 100));
        float fade = 1.0f - Mth.clamp(fadeouttimer - 1.0f, 0.0f, 1.0f);
        ColourScheme.Colour colour = this.displayWindow.context().colourScheme().background();
        RenderSystem.setShaderColor(1.0f, 1.0f, 1.0f, fade);
        if (fadeouttimer >= 1.0f) {
            if (this.minecraft.screen != null) {
                this.minecraft.screen.render(graphics, 0, 0, partialTick);
            }
            this.displayWindow.render(255);
        } else {
            GlStateManager._clearColor(colour.redf(), colour.greenf(), colour.bluef(), 1.0f);
            GlStateManager._clear(16384, Minecraft.ON_OSX);
            this.displayWindow.render(255);
        }
        RenderSystem.enableBlend();
        RenderSystem.blendFunc(770, 771);
        int fbWidth = this.minecraft.getWindow().getWidth();
        int fbHeight = this.minecraft.getWindow().getHeight();
        GL30C.glViewport((int)0, (int)0, (int)fbWidth, (int)fbHeight);
        int twidth = this.displayWindow.context().width();
        int theight = this.displayWindow.context().height();
        float wscale = (float)fbWidth / (float)twidth;
        float hscale = (float)fbHeight / (float)theight;
        float scale = (float)this.displayWindow.context().scale() * Math.min(wscale, hscale) / 2.0f;
        float wleft = Mth.clamp((float)fbWidth * 0.5f - scale * (float)twidth, 0.0f, (float)fbWidth);
        float wtop = Mth.clamp((float)fbHeight * 0.5f - scale * (float)theight, 0.0f, (float)fbHeight);
        float wright = Mth.clamp((float)fbWidth * 0.5f + scale * (float)twidth, 0.0f, (float)fbWidth);
        float wbottom = Mth.clamp((float)fbHeight * 0.5f + scale * (float)theight, 0.0f, (float)fbHeight);
        GlStateManager.glActiveTexture(33984);
        RenderSystem.disableCull();
        BufferBuilder bufferbuilder = Tesselator.getInstance().getBuilder();
        RenderSystem.setShaderColor(1.0f, 1.0f, 1.0f, fade);
        RenderSystem.getModelViewMatrix().identity();
        RenderSystem.setProjectionMatrix(new Matrix4f().setOrtho(0.0f, (float)fbWidth, 0.0f, (float)fbHeight, 0.1f, -0.1f), VertexSorting.ORTHOGRAPHIC_Z);
        RenderSystem.setShader(GameRenderer::getPositionColorShader);
        bufferbuilder.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_COLOR);
        ForgeLoadingOverlay.addQuad(bufferbuilder, 0.0f, fbWidth, wtop, fbHeight, colour, fade);
        ForgeLoadingOverlay.addQuad(bufferbuilder, 0.0f, fbWidth, 0.0f, wtop, colour, fade);
        ForgeLoadingOverlay.addQuad(bufferbuilder, 0.0f, wleft, wtop, wbottom, colour, fade);
        ForgeLoadingOverlay.addQuad(bufferbuilder, wright, fbWidth, wtop, wbottom, colour, fade);
        BufferUploader.drawWithShader(bufferbuilder.end());
        RenderSystem.enableBlend();
        RenderSystem.blendFunc(770, 771);
        RenderSystem.setShader(GameRenderer::getPositionTexColorShader);
        RenderSystem.setShaderTexture(0, this.displayWindow.getFramebufferTextureId());
        bufferbuilder.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX_COLOR);
        bufferbuilder.vertex(wleft, wbottom, 0.0).uv(0.0f, 0.0f).color(1.0f, 1.0f, 1.0f, fade).endVertex();
        bufferbuilder.vertex(wright, wbottom, 0.0).uv(1.0f, 0.0f).color(1.0f, 1.0f, 1.0f, fade).endVertex();
        bufferbuilder.vertex(wright, wtop, 0.0).uv(1.0f, 1.0f).color(1.0f, 1.0f, 1.0f, fade).endVertex();
        bufferbuilder.vertex(wleft, wtop, 0.0).uv(0.0f, 1.0f).color(1.0f, 1.0f, 1.0f, fade).endVertex();
        GL30C.glTexParameterIi((int)3553, (int)10241, (int)9728);
        GL30C.glTexParameterIi((int)3553, (int)10240, (int)9728);
        BufferUploader.drawWithShader(bufferbuilder.end());
        RenderSystem.defaultBlendFunc();
        RenderSystem.disableBlend();
        RenderSystem.setShaderColor(1.0f, 1.0f, 1.0f, 1.0f);
        if (fadeouttimer >= 2.0f) {
            this.minecraft.setOverlay(null);
            this.displayWindow.close();
        }
        if (this.fadeOutStart == -1L && this.reload.isDone()) {
            this.progress.complete();
            this.fadeOutStart = Util.getMillis();
            try {
                this.reload.checkExceptions();
                this.onFinish.accept(Optional.empty());
            }
            catch (Throwable throwable) {
                this.onFinish.accept(Optional.of(throwable));
            }
            if (this.minecraft.screen != null) {
                this.minecraft.screen.init(this.minecraft, this.minecraft.getWindow().getGuiScaledWidth(), this.minecraft.getWindow().getGuiScaledHeight());
            }
        }
    }

    private static void addQuad(BufferVertexConsumer bufferbuilder, float x0, float x1, float y0, float y1, ColourScheme.Colour colour, float fade) {
        bufferbuilder.vertex(x0, y0, 0.0).color(colour.redf(), colour.greenf(), colour.bluef(), fade).endVertex();
        bufferbuilder.vertex(x0, y1, 0.0).color(colour.redf(), colour.greenf(), colour.bluef(), fade).endVertex();
        bufferbuilder.vertex(x1, y1, 0.0).color(colour.redf(), colour.greenf(), colour.bluef(), fade).endVertex();
        bufferbuilder.vertex(x1, y0, 0.0).color(colour.redf(), colour.greenf(), colour.bluef(), fade).endVertex();
    }
}

