/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.ParseResults;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.RootCommandNode;
import java.util.IdentityHashMap;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandRuntimeException;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.synchronization.SuggestionProviders;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentUtils;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraftforge.client.ClientCommandSourceStack;
import net.minecraftforge.client.event.ClientPlayerNetworkEvent;
import net.minecraftforge.client.event.RegisterClientCommandsEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.server.command.CommandHelper;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.ApiStatus;

public class ClientCommandHandler {
    private static final Logger LOGGER = LogManager.getLogger();
    private static CommandDispatcher<CommandSourceStack> commands = null;

    public static void init() {
        MinecraftForge.EVENT_BUS.addListener(ClientCommandHandler::handleClientPlayerLogin);
    }

    private static void handleClientPlayerLogin(ClientPlayerNetworkEvent.LoggingIn event) {
        ClientPacketListener connection = event.getPlayer().connection;
        connection.commands = ClientCommandHandler.mergeServerCommands((CommandDispatcher<SharedSuggestionProvider>)new CommandDispatcher(), CommandBuildContext.simple(connection.registryAccess(), connection.enabledFeatures()));
    }

    @ApiStatus.Internal
    public static CommandDispatcher<SharedSuggestionProvider> mergeServerCommands(CommandDispatcher<SharedSuggestionProvider> serverCommands, CommandBuildContext buildContext) {
        CommandDispatcher commandsTemp = new CommandDispatcher();
        MinecraftForge.EVENT_BUS.post((Event)new RegisterClientCommandsEvent((CommandDispatcher<CommandSourceStack>)commandsTemp, buildContext));
        commands = new CommandDispatcher();
        ClientCommandHandler.copy(commandsTemp.getRoot(), commands.getRoot());
        RootCommandNode serverCommandsRoot = serverCommands.getRoot();
        CommandDispatcher newServerCommands = new CommandDispatcher();
        ClientCommandHandler.copy(serverCommandsRoot, newServerCommands.getRoot());
        CommandHelper.mergeCommandNode(commands.getRoot(), newServerCommands.getRoot(), new IdentityHashMap(), ClientCommandHandler.getSource(), context -> 0, suggestions -> {
            SuggestionProvider suggestionProvider = SuggestionProviders.safelySwap((SuggestionProvider<SharedSuggestionProvider>)suggestions);
            if (suggestionProvider == SuggestionProviders.ASK_SERVER) {
                suggestionProvider = (context, builder) -> {
                    ClientCommandSourceStack source = ClientCommandHandler.getSource();
                    StringReader reader = new StringReader(context.getInput());
                    if (reader.canRead() && reader.peek() == '/') {
                        reader.skip();
                    }
                    ParseResults parse = commands.parse(reader, (Object)source);
                    return commands.getCompletionSuggestions(parse);
                };
            }
            return suggestionProvider;
        });
        return newServerCommands;
    }

    public static CommandDispatcher<CommandSourceStack> getDispatcher() {
        return commands;
    }

    public static ClientCommandSourceStack getSource() {
        LocalPlayer player = Minecraft.getInstance().player;
        return new ClientCommandSourceStack(player, player.position(), player.getRotationVector(), player.getPermissionLevel(), player.getName().getString(), player.getDisplayName(), player);
    }

    private static <S> void copy(CommandNode<S> sourceNode, CommandNode<S> resultNode) {
        IdentityHashMap<Object, Object> newNodes = new IdentityHashMap<Object, Object>();
        newNodes.put(sourceNode, resultNode);
        for (CommandNode child : sourceNode.getChildren()) {
            CommandNode copy = newNodes.computeIfAbsent(child, innerChild -> {
                ArgumentBuilder builder = innerChild.createBuilder();
                CommandNode innerCopy = builder.build();
                ClientCommandHandler.copy(innerChild, innerCopy);
                return innerCopy;
            });
            resultNode.addChild(copy);
        }
    }

    public static boolean runCommand(String command) {
        StringReader reader = new StringReader(command);
        ClientCommandSourceStack source = ClientCommandHandler.getSource();
        try {
            commands.execute(reader, (Object)source);
        }
        catch (CommandRuntimeException execution) {
            Minecraft.getInstance().player.sendSystemMessage(Component.literal("").append(execution.getComponent()).withStyle(ChatFormatting.RED));
        }
        catch (CommandSyntaxException syntax) {
            if (syntax.getType() == CommandSyntaxException.BUILT_IN_EXCEPTIONS.dispatcherUnknownCommand() || syntax.getType() == CommandSyntaxException.BUILT_IN_EXCEPTIONS.dispatcherUnknownArgument()) {
                return false;
            }
            Minecraft.getInstance().player.sendSystemMessage(Component.literal("").append(ComponentUtils.fromMessage(syntax.getRawMessage())).withStyle(ChatFormatting.RED));
            if (syntax.getInput() != null && syntax.getCursor() >= 0) {
                int position = Math.min(syntax.getInput().length(), syntax.getCursor());
                MutableComponent details = Component.literal("").withStyle(ChatFormatting.GRAY).withStyle(style -> style.withClickEvent(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, reader.getString())));
                if (position > 10) {
                    details.append("...");
                }
                details.append(syntax.getInput().substring(Math.max(0, position - 10), position));
                if (position < syntax.getInput().length()) {
                    details.append(Component.literal(syntax.getInput().substring(position)).withStyle(ChatFormatting.RED, ChatFormatting.UNDERLINE));
                }
                details.append(Component.translatable("command.context.here").withStyle(ChatFormatting.RED, ChatFormatting.ITALIC));
                Minecraft.getInstance().player.sendSystemMessage(Component.literal("").append(details).withStyle(ChatFormatting.RED));
            }
        }
        catch (Exception generic) {
            MutableComponent message = Component.literal(generic.getMessage() == null ? generic.getClass().getName() : generic.getMessage());
            Minecraft.getInstance().player.sendSystemMessage(Component.translatable("command.failed").withStyle(ChatFormatting.RED).withStyle(style -> style.withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, message))));
            LOGGER.error("Error executing client command \"{}\"", (Object)command, (Object)generic);
        }
        return true;
    }
}

