/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot;

import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.storage.loot.LootDataId;
import net.minecraft.world.level.storage.loot.LootDataType;
import net.minecraft.world.level.storage.loot.LootTable;

@FunctionalInterface
public interface LootDataResolver {
    @Nullable
    public <T> T getElement(LootDataId<T> var1);

    @Nullable
    default public <T> T getElement(LootDataType<T> p_279423_, ResourceLocation p_279277_) {
        return this.getElement(new LootDataId<T>(p_279423_, p_279277_));
    }

    default public <T> Optional<T> getElementOptional(LootDataId<T> p_279486_) {
        return Optional.ofNullable(this.getElement(p_279486_));
    }

    default public <T> Optional<T> getElementOptional(LootDataType<T> p_279350_, ResourceLocation p_279323_) {
        return this.getElementOptional(new LootDataId<T>(p_279350_, p_279323_));
    }

    default public LootTable getLootTable(ResourceLocation p_279456_) {
        return this.getElementOptional(LootDataType.TABLE, p_279456_).orElse(LootTable.EMPTY);
    }
}

