/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.feature.configurations;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import net.minecraft.Util;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderSet;
import net.minecraft.core.RegistryCodecs;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.MultifaceBlock;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;

public class MultifaceGrowthConfiguration
implements FeatureConfiguration {
    public static final Codec<MultifaceGrowthConfiguration> CODEC = RecordCodecBuilder.create(p_225407_ -> p_225407_.group((App)BuiltInRegistries.BLOCK.byNameCodec().fieldOf("block").flatXmap(MultifaceGrowthConfiguration::apply, DataResult::success).orElse((Object)((MultifaceBlock)Blocks.GLOW_LICHEN)).forGetter(p_225424_ -> p_225424_.placeBlock), (App)Codec.intRange((int)1, (int)64).fieldOf("search_range").orElse((Object)10).forGetter(p_225422_ -> p_225422_.searchRange), (App)Codec.BOOL.fieldOf("can_place_on_floor").orElse((Object)false).forGetter(p_225420_ -> p_225420_.canPlaceOnFloor), (App)Codec.BOOL.fieldOf("can_place_on_ceiling").orElse((Object)false).forGetter(p_225418_ -> p_225418_.canPlaceOnCeiling), (App)Codec.BOOL.fieldOf("can_place_on_wall").orElse((Object)false).forGetter(p_225416_ -> p_225416_.canPlaceOnWall), (App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("chance_of_spreading").orElse((Object)Float.valueOf(0.5f)).forGetter(p_225414_ -> Float.valueOf(p_225414_.chanceOfSpreading)), (App)RegistryCodecs.homogeneousList(Registries.BLOCK).fieldOf("can_be_placed_on").forGetter(p_225409_ -> p_225409_.canBePlacedOn)).apply((Applicative)p_225407_, MultifaceGrowthConfiguration::new));
    public final MultifaceBlock placeBlock;
    public final int searchRange;
    public final boolean canPlaceOnFloor;
    public final boolean canPlaceOnCeiling;
    public final boolean canPlaceOnWall;
    public final float chanceOfSpreading;
    public final HolderSet<Block> canBePlacedOn;
    private final ObjectArrayList<Direction> validDirections;

    private static DataResult<MultifaceBlock> apply(Block p_225405_) {
        DataResult dataresult;
        if (p_225405_ instanceof MultifaceBlock) {
            MultifaceBlock multifaceblock = (MultifaceBlock)p_225405_;
            dataresult = DataResult.success((Object)multifaceblock);
        } else {
            dataresult = DataResult.error(() -> "Growth block should be a multiface block");
        }
        return dataresult;
    }

    public MultifaceGrowthConfiguration(MultifaceBlock p_225392_, int p_225393_, boolean p_225394_, boolean p_225395_, boolean p_225396_, float p_225397_, HolderSet<Block> p_225398_) {
        this.placeBlock = p_225392_;
        this.searchRange = p_225393_;
        this.canPlaceOnFloor = p_225394_;
        this.canPlaceOnCeiling = p_225395_;
        this.canPlaceOnWall = p_225396_;
        this.chanceOfSpreading = p_225397_;
        this.canBePlacedOn = p_225398_;
        this.validDirections = new ObjectArrayList(6);
        if (p_225395_) {
            this.validDirections.add((Object)Direction.UP);
        }
        if (p_225394_) {
            this.validDirections.add((Object)Direction.DOWN);
        }
        if (p_225396_) {
            Direction.Plane.HORIZONTAL.forEach(arg_0 -> this.validDirections.add(arg_0));
        }
    }

    public List<Direction> getShuffledDirectionsExcept(RandomSource p_225402_, Direction p_225403_) {
        return Util.toShuffledList(this.validDirections.stream().filter(p_225412_ -> p_225412_ != p_225403_), p_225402_);
    }

    public List<Direction> getShuffledDirections(RandomSource p_225400_) {
        return Util.shuffledCopy(this.validDirections, p_225400_);
    }
}

