/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.gameevent.vibrations;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.UUIDUtil;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;

public record VibrationInfo(GameEvent gameEvent, float distance, Vec3 pos, @Nullable UUID uuid, @Nullable UUID projectileOwnerUuid, @Nullable Entity entity) {
    public static final Codec<VibrationInfo> CODEC = RecordCodecBuilder.create(p_258994_ -> p_258994_.group((App)BuiltInRegistries.GAME_EVENT.byNameCodec().fieldOf("game_event").forGetter(VibrationInfo::gameEvent), (App)Codec.floatRange((float)0.0f, (float)Float.MAX_VALUE).fieldOf("distance").forGetter(VibrationInfo::distance), (App)Vec3.CODEC.fieldOf("pos").forGetter(VibrationInfo::pos), (App)UUIDUtil.CODEC.optionalFieldOf("source").forGetter(p_250608_ -> Optional.ofNullable(p_250608_.uuid())), (App)UUIDUtil.CODEC.optionalFieldOf("projectile_owner").forGetter(p_250607_ -> Optional.ofNullable(p_250607_.projectileOwnerUuid()))).apply((Applicative)p_258994_, (p_249268_, p_252231_, p_250951_, p_250574_, p_249661_) -> new VibrationInfo((GameEvent)p_249268_, p_252231_.floatValue(), (Vec3)p_250951_, p_250574_.orElse(null), p_249661_.orElse(null))));

    public VibrationInfo(GameEvent p_249055_, float p_250190_, Vec3 p_251692_, @Nullable UUID p_249849_, @Nullable UUID p_249731_) {
        this(p_249055_, p_250190_, p_251692_, p_249849_, p_249731_, null);
    }

    public VibrationInfo(GameEvent p_252023_, float p_251086_, Vec3 p_250935_, @Nullable Entity p_249432_) {
        this(p_252023_, p_251086_, p_250935_, p_249432_ == null ? null : p_249432_.getUUID(), VibrationInfo.getProjectileOwner(p_249432_), p_249432_);
    }

    @Nullable
    private static UUID getProjectileOwner(@Nullable Entity p_251531_) {
        Projectile projectile;
        if (p_251531_ instanceof Projectile && (projectile = (Projectile)p_251531_).getOwner() != null) {
            return projectile.getOwner().getUUID();
        }
        return null;
    }

    public Optional<Entity> getEntity(ServerLevel p_249184_) {
        return Optional.ofNullable(this.entity).or(() -> Optional.ofNullable(this.uuid).map(p_249184_::getEntity));
    }

    public Optional<Entity> getProjectileOwner(ServerLevel p_249217_) {
        return this.getEntity(p_249217_).filter(p_249829_ -> p_249829_ instanceof Projectile).map(p_249388_ -> (Projectile)p_249388_).map(Projectile::getOwner).or(() -> Optional.ofNullable(this.projectileOwnerUuid).map(p_249217_::getEntity));
    }
}

