/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.gameevent;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.PositionSource;
import net.minecraft.world.level.gameevent.PositionSourceType;
import net.minecraft.world.phys.Vec3;

public class BlockPositionSource
implements PositionSource {
    public static final Codec<BlockPositionSource> CODEC = RecordCodecBuilder.create(p_157710_ -> p_157710_.group((App)BlockPos.CODEC.fieldOf("pos").forGetter(p_223611_ -> p_223611_.pos)).apply((Applicative)p_157710_, BlockPositionSource::new));
    final BlockPos pos;

    public BlockPositionSource(BlockPos p_157703_) {
        this.pos = p_157703_;
    }

    @Override
    public Optional<Vec3> getPosition(Level p_157708_) {
        return Optional.of(Vec3.atCenterOf(this.pos));
    }

    @Override
    public PositionSourceType<?> getType() {
        return PositionSourceType.BLOCK;
    }

    public static class Type
    implements PositionSourceType<BlockPositionSource> {
        @Override
        public BlockPositionSource read(FriendlyByteBuf p_157716_) {
            return new BlockPositionSource(p_157716_.readBlockPos());
        }

        @Override
        public void write(FriendlyByteBuf p_157718_, BlockPositionSource p_157719_) {
            p_157718_.writeBlockPos(p_157719_.pos);
        }

        @Override
        public Codec<BlockPositionSource> codec() {
            return CODEC;
        }
    }
}

