/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BasePressurePlateBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;

public class PressurePlateBlock
extends BasePressurePlateBlock {
    public static final BooleanProperty POWERED = BlockStateProperties.POWERED;
    private final Sensitivity sensitivity;

    public PressurePlateBlock(Sensitivity p_273523_, BlockBehaviour.Properties p_273571_, BlockSetType p_273284_) {
        super(p_273571_, p_273284_);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue(POWERED, false));
        this.sensitivity = p_273523_;
    }

    @Override
    protected int getSignalForState(BlockState p_55270_) {
        return p_55270_.getValue(POWERED) != false ? 15 : 0;
    }

    @Override
    protected BlockState setSignalForState(BlockState p_55259_, int p_55260_) {
        return (BlockState)p_55259_.setValue(POWERED, p_55260_ > 0);
    }

    @Override
    protected int getSignalStrength(Level p_55264_, BlockPos p_55265_) {
        Class<Entity> oclass = switch (this.sensitivity) {
            case Sensitivity.EVERYTHING -> Entity.class;
            case Sensitivity.MOBS -> LivingEntity.class;
            default -> throw new IncompatibleClassChangeError();
        };
        return PressurePlateBlock.getEntityCount(p_55264_, TOUCH_AABB.move(p_55265_), oclass) > 0 ? 15 : 0;
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> p_55262_) {
        p_55262_.add(POWERED);
    }

    public static enum Sensitivity {
        EVERYTHING,
        MOBS;

    }
}

