/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.SuspiciousEffectHolder;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.registries.ForgeRegistries;

public class FlowerBlock
extends BushBlock
implements SuspiciousEffectHolder {
    protected static final float AABB_OFFSET = 3.0f;
    protected static final VoxelShape SHAPE = Block.box(5.0, 0.0, 5.0, 11.0, 10.0, 11.0);
    private final MobEffect suspiciousStewEffect;
    private final int effectDuration;
    private final Supplier<MobEffect> suspiciousStewEffectSupplier;

    public FlowerBlock(Supplier<MobEffect> effectSupplier, int p_53513_, BlockBehaviour.Properties p_53514_) {
        super(p_53514_);
        this.suspiciousStewEffect = null;
        this.suspiciousStewEffectSupplier = effectSupplier;
        this.effectDuration = p_53513_;
    }

    @Deprecated
    public FlowerBlock(MobEffect p_53512_, int p_53513_, BlockBehaviour.Properties p_53514_) {
        super(p_53514_);
        this.suspiciousStewEffect = p_53512_;
        this.effectDuration = p_53512_.isInstantenous() ? p_53513_ : p_53513_ * 20;
        this.suspiciousStewEffectSupplier = ForgeRegistries.MOB_EFFECTS.getDelegateOrThrow(p_53512_);
    }

    @Override
    public VoxelShape getShape(BlockState p_53517_, BlockGetter p_53518_, BlockPos p_53519_, CollisionContext p_53520_) {
        Vec3 vec3 = p_53517_.getOffset(p_53518_, p_53519_);
        return SHAPE.move(vec3.x, vec3.y, vec3.z);
    }

    @Override
    public MobEffect getSuspiciousEffect() {
        return this.suspiciousStewEffectSupplier.get();
    }

    @Override
    public int getEffectDuration() {
        if (this.suspiciousStewEffect == null && !this.suspiciousStewEffectSupplier.get().isInstantenous()) {
            return this.effectDuration * 20;
        }
        return this.effectDuration;
    }
}

