/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import java.util.function.BiPredicate;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DirectionProperty;

public class DoubleBlockCombiner {
    public static <S extends BlockEntity> NeighborCombineResult<S> combineWithNeigbour(BlockEntityType<S> p_52823_, Function<BlockState, BlockType> p_52824_, Function<BlockState, Direction> p_52825_, DirectionProperty p_52826_, BlockState p_52827_, LevelAccessor p_52828_, BlockPos p_52829_, BiPredicate<LevelAccessor, BlockPos> p_52830_) {
        BlockType doubleblockcombiner$blocktype1;
        boolean flag1;
        S s = p_52823_.getBlockEntity(p_52828_, p_52829_);
        if (s == null) {
            return Combiner::acceptNone;
        }
        if (p_52830_.test(p_52828_, p_52829_)) {
            return Combiner::acceptNone;
        }
        BlockType doubleblockcombiner$blocktype = p_52824_.apply(p_52827_);
        boolean flag = doubleblockcombiner$blocktype == BlockType.SINGLE;
        boolean bl = flag1 = doubleblockcombiner$blocktype == BlockType.FIRST;
        if (flag) {
            return new NeighborCombineResult.Single<S>(s);
        }
        BlockPos blockpos = p_52829_.relative(p_52825_.apply(p_52827_));
        BlockState blockstate = p_52828_.getBlockState(blockpos);
        if (blockstate.is(p_52827_.getBlock()) && (doubleblockcombiner$blocktype1 = p_52824_.apply(blockstate)) != BlockType.SINGLE && doubleblockcombiner$blocktype != doubleblockcombiner$blocktype1 && blockstate.getValue(p_52826_) == p_52827_.getValue(p_52826_)) {
            if (p_52830_.test(p_52828_, blockpos)) {
                return Combiner::acceptNone;
            }
            S s1 = p_52823_.getBlockEntity(p_52828_, blockpos);
            if (s1 != null) {
                S s2 = flag1 ? s : s1;
                S s3 = flag1 ? s1 : s;
                return new NeighborCombineResult.Double<S>(s2, s3);
            }
        }
        return new NeighborCombineResult.Single<S>(s);
    }

    public static interface NeighborCombineResult<S> {
        public <T> T apply(Combiner<? super S, T> var1);

        public static final class Single<S>
        implements NeighborCombineResult<S> {
            private final S single;

            public Single(S p_52855_) {
                this.single = p_52855_;
            }

            @Override
            public <T> T apply(Combiner<? super S, T> p_52857_) {
                return p_52857_.acceptSingle(this.single);
            }
        }

        public static final class Double<S>
        implements NeighborCombineResult<S> {
            private final S first;
            private final S second;

            public Double(S p_52849_, S p_52850_) {
                this.first = p_52849_;
                this.second = p_52850_;
            }

            @Override
            public <T> T apply(Combiner<? super S, T> p_52852_) {
                return p_52852_.acceptDouble(this.first, this.second);
            }
        }
    }

    public static enum BlockType {
        SINGLE,
        FIRST,
        SECOND;

    }

    public static interface Combiner<S, T> {
        public T acceptDouble(S var1, S var2);

        public T acceptSingle(S var1);

        public T acceptNone();
    }
}

