/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.DynamicLike;
import java.util.Comparator;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.game.ClientboundEntityEventPacket;
import net.minecraft.network.protocol.game.ClientboundGameEventPacket;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import org.slf4j.Logger;

public class GameRules {
    public static final int DEFAULT_RANDOM_TICK_SPEED = 3;
    static final Logger LOGGER = LogUtils.getLogger();
    private static final Map<Key<?>, Type<?>> GAME_RULE_TYPES = Maps.newTreeMap(Comparator.comparing(p_46218_ -> p_46218_.id));
    public static final Key<BooleanValue> RULE_DOFIRETICK = GameRules.register("doFireTick", Category.UPDATES, BooleanValue.create(true));
    public static final Key<BooleanValue> RULE_MOBGRIEFING = GameRules.register("mobGriefing", Category.MOBS, BooleanValue.create(true));
    public static final Key<BooleanValue> RULE_KEEPINVENTORY = GameRules.register("keepInventory", Category.PLAYER, BooleanValue.create(false));
    public static final Key<BooleanValue> RULE_DOMOBSPAWNING = GameRules.register("doMobSpawning", Category.SPAWNING, BooleanValue.create(true));
    public static final Key<BooleanValue> RULE_DOMOBLOOT = GameRules.register("doMobLoot", Category.DROPS, BooleanValue.create(true));
    public static final Key<BooleanValue> RULE_DOBLOCKDROPS = GameRules.register("doTileDrops", Category.DROPS, BooleanValue.create(true));
    public static final Key<BooleanValue> RULE_DOENTITYDROPS = GameRules.register("doEntityDrops", Category.DROPS, BooleanValue.create(true));
    public static final Key<BooleanValue> RULE_COMMANDBLOCKOUTPUT = GameRules.register("commandBlockOutput", Category.CHAT, BooleanValue.create(true));
    public static final Key<BooleanValue> RULE_NATURAL_REGENERATION = GameRules.register("naturalRegeneration", Category.PLAYER, BooleanValue.create(true));
    public static final Key<BooleanValue> RULE_DAYLIGHT = GameRules.register("doDaylightCycle", Category.UPDATES, BooleanValue.create(true));
    public static final Key<BooleanValue> RULE_LOGADMINCOMMANDS = GameRules.register("logAdminCommands", Category.CHAT, BooleanValue.create(true));
    public static final Key<BooleanValue> RULE_SHOWDEATHMESSAGES = GameRules.register("showDeathMessages", Category.CHAT, BooleanValue.create(true));
    public static final Key<IntegerValue> RULE_RANDOMTICKING = GameRules.register("randomTickSpeed", Category.UPDATES, IntegerValue.create(3));
    public static final Key<BooleanValue> RULE_SENDCOMMANDFEEDBACK = GameRules.register("sendCommandFeedback", Category.CHAT, BooleanValue.create(true));
    public static final Key<BooleanValue> RULE_REDUCEDDEBUGINFO = GameRules.register("reducedDebugInfo", Category.MISC, BooleanValue.create(false, (p_46212_, p_46213_) -> {
        byte b0 = (byte)(p_46213_.get() ? 22 : 23);
        for (ServerPlayer serverplayer : p_46212_.getPlayerList().getPlayers()) {
            serverplayer.connection.send(new ClientboundEntityEventPacket(serverplayer, b0));
        }
    }));
    public static final Key<BooleanValue> RULE_SPECTATORSGENERATECHUNKS = GameRules.register("spectatorsGenerateChunks", Category.PLAYER, BooleanValue.create(true));
    public static final Key<IntegerValue> RULE_SPAWN_RADIUS = GameRules.register("spawnRadius", Category.PLAYER, IntegerValue.create(10));
    public static final Key<BooleanValue> RULE_DISABLE_ELYTRA_MOVEMENT_CHECK = GameRules.register("disableElytraMovementCheck", Category.PLAYER, BooleanValue.create(false));
    public static final Key<IntegerValue> RULE_MAX_ENTITY_CRAMMING = GameRules.register("maxEntityCramming", Category.MOBS, IntegerValue.create(24));
    public static final Key<BooleanValue> RULE_WEATHER_CYCLE = GameRules.register("doWeatherCycle", Category.UPDATES, BooleanValue.create(true));
    public static final Key<BooleanValue> RULE_LIMITED_CRAFTING = GameRules.register("doLimitedCrafting", Category.PLAYER, BooleanValue.create(false));
    public static final Key<IntegerValue> RULE_MAX_COMMAND_CHAIN_LENGTH = GameRules.register("maxCommandChainLength", Category.MISC, IntegerValue.create(65536));
    public static final Key<IntegerValue> RULE_COMMAND_MODIFICATION_BLOCK_LIMIT = GameRules.register("commandModificationBlockLimit", Category.MISC, IntegerValue.create(32768));
    public static final Key<BooleanValue> RULE_ANNOUNCE_ADVANCEMENTS = GameRules.register("announceAdvancements", Category.CHAT, BooleanValue.create(true));
    public static final Key<BooleanValue> RULE_DISABLE_RAIDS = GameRules.register("disableRaids", Category.MOBS, BooleanValue.create(false));
    public static final Key<BooleanValue> RULE_DOINSOMNIA = GameRules.register("doInsomnia", Category.SPAWNING, BooleanValue.create(true));
    public static final Key<BooleanValue> RULE_DO_IMMEDIATE_RESPAWN = GameRules.register("doImmediateRespawn", Category.PLAYER, BooleanValue.create(false, (p_46200_, p_46201_) -> {
        for (ServerPlayer serverplayer : p_46200_.getPlayerList().getPlayers()) {
            serverplayer.connection.send(new ClientboundGameEventPacket(ClientboundGameEventPacket.IMMEDIATE_RESPAWN, p_46201_.get() ? 1.0f : 0.0f));
        }
    }));
    public static final Key<BooleanValue> RULE_DROWNING_DAMAGE = GameRules.register("drowningDamage", Category.PLAYER, BooleanValue.create(true));
    public static final Key<BooleanValue> RULE_FALL_DAMAGE = GameRules.register("fallDamage", Category.PLAYER, BooleanValue.create(true));
    public static final Key<BooleanValue> RULE_FIRE_DAMAGE = GameRules.register("fireDamage", Category.PLAYER, BooleanValue.create(true));
    public static final Key<BooleanValue> RULE_FREEZE_DAMAGE = GameRules.register("freezeDamage", Category.PLAYER, BooleanValue.create(true));
    public static final Key<BooleanValue> RULE_DO_PATROL_SPAWNING = GameRules.register("doPatrolSpawning", Category.SPAWNING, BooleanValue.create(true));
    public static final Key<BooleanValue> RULE_DO_TRADER_SPAWNING = GameRules.register("doTraderSpawning", Category.SPAWNING, BooleanValue.create(true));
    public static final Key<BooleanValue> RULE_DO_WARDEN_SPAWNING = GameRules.register("doWardenSpawning", Category.SPAWNING, BooleanValue.create(true));
    public static final Key<BooleanValue> RULE_FORGIVE_DEAD_PLAYERS = GameRules.register("forgiveDeadPlayers", Category.MOBS, BooleanValue.create(true));
    public static final Key<BooleanValue> RULE_UNIVERSAL_ANGER = GameRules.register("universalAnger", Category.MOBS, BooleanValue.create(false));
    public static final Key<IntegerValue> RULE_PLAYERS_SLEEPING_PERCENTAGE = GameRules.register("playersSleepingPercentage", Category.PLAYER, IntegerValue.create(100));
    public static final Key<BooleanValue> RULE_BLOCK_EXPLOSION_DROP_DECAY = GameRules.register("blockExplosionDropDecay", Category.DROPS, BooleanValue.create(true));
    public static final Key<BooleanValue> RULE_MOB_EXPLOSION_DROP_DECAY = GameRules.register("mobExplosionDropDecay", Category.DROPS, BooleanValue.create(true));
    public static final Key<BooleanValue> RULE_TNT_EXPLOSION_DROP_DECAY = GameRules.register("tntExplosionDropDecay", Category.DROPS, BooleanValue.create(false));
    public static final Key<IntegerValue> RULE_SNOW_ACCUMULATION_HEIGHT = GameRules.register("snowAccumulationHeight", Category.UPDATES, IntegerValue.create(1));
    public static final Key<BooleanValue> RULE_WATER_SOURCE_CONVERSION = GameRules.register("waterSourceConversion", Category.UPDATES, BooleanValue.create(true));
    public static final Key<BooleanValue> RULE_LAVA_SOURCE_CONVERSION = GameRules.register("lavaSourceConversion", Category.UPDATES, BooleanValue.create(false));
    public static final Key<BooleanValue> RULE_GLOBAL_SOUND_EVENTS = GameRules.register("globalSoundEvents", Category.MISC, BooleanValue.create(true));
    public static final Key<BooleanValue> RULE_DO_VINES_SPREAD = GameRules.register("doVinesSpread", Category.UPDATES, BooleanValue.create(true));
    private final Map<Key<?>, Value<?>> rules;

    public static <T extends Value<T>> Key<T> register(String p_46190_, Category p_46191_, Type<T> p_46192_) {
        Key key = new Key(p_46190_, p_46191_);
        Type<T> type = GAME_RULE_TYPES.put(key, p_46192_);
        if (type != null) {
            throw new IllegalStateException("Duplicate game rule registration for " + p_46190_);
        }
        return key;
    }

    public GameRules(DynamicLike<?> p_46160_) {
        this();
        this.loadFromTag(p_46160_);
    }

    public GameRules() {
        this.rules = (Map)GAME_RULE_TYPES.entrySet().stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, p_46210_ -> ((Type)p_46210_.getValue()).createRule()));
    }

    private GameRules(Map<Key<?>, Value<?>> p_46162_) {
        this.rules = p_46162_;
    }

    public <T extends Value<T>> T getRule(Key<T> p_46171_) {
        return (T)this.rules.get(p_46171_);
    }

    public CompoundTag createTag() {
        CompoundTag compoundtag = new CompoundTag();
        this.rules.forEach((p_46197_, p_46198_) -> compoundtag.putString(p_46197_.id, p_46198_.serialize()));
        return compoundtag;
    }

    private void loadFromTag(DynamicLike<?> p_46184_) {
        this.rules.forEach((p_46187_, p_46188_) -> p_46184_.get(p_46187_.id).asString().result().ifPresent(p_46188_::deserialize));
    }

    public GameRules copy() {
        return new GameRules((Map)this.rules.entrySet().stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, p_46194_ -> ((Value)p_46194_.getValue()).copy())));
    }

    public static void visitGameRuleTypes(GameRuleTypeVisitor p_46165_) {
        GAME_RULE_TYPES.forEach((p_46205_, p_46206_) -> GameRules.callVisitorCap(p_46165_, p_46205_, p_46206_));
    }

    private static <T extends Value<T>> void callVisitorCap(GameRuleTypeVisitor p_46167_, Key<?> p_46168_, Type<?> p_46169_) {
        p_46167_.visit(p_46168_, p_46169_);
        p_46169_.callVisitor(p_46167_, p_46168_);
    }

    public void assignFrom(GameRules p_46177_, @Nullable MinecraftServer p_46178_) {
        p_46177_.rules.keySet().forEach(p_46182_ -> this.assignCap((Key)p_46182_, p_46177_, p_46178_));
    }

    private <T extends Value<T>> void assignCap(Key<T> p_46173_, GameRules p_46174_, @Nullable MinecraftServer p_46175_) {
        T t = p_46174_.getRule(p_46173_);
        ((Value)this.getRule(p_46173_)).setFrom(t, p_46175_);
    }

    public boolean getBoolean(Key<BooleanValue> p_46208_) {
        return this.getRule(p_46208_).get();
    }

    public int getInt(Key<IntegerValue> p_46216_) {
        return this.getRule(p_46216_).get();
    }

    public static final class Key<T extends Value<T>> {
        final String id;
        private final Category category;

        public Key(String p_46326_, Category p_46327_) {
            this.id = p_46326_;
            this.category = p_46327_;
        }

        public String toString() {
            return this.id;
        }

        public boolean equals(Object p_46334_) {
            if (this == p_46334_) {
                return true;
            }
            return p_46334_ instanceof Key && ((Key)p_46334_).id.equals(this.id);
        }

        public int hashCode() {
            return this.id.hashCode();
        }

        public String getId() {
            return this.id;
        }

        public String getDescriptionId() {
            return "gamerule." + this.id;
        }

        public Category getCategory() {
            return this.category;
        }
    }

    public static enum Category {
        PLAYER("gamerule.category.player"),
        MOBS("gamerule.category.mobs"),
        SPAWNING("gamerule.category.spawning"),
        DROPS("gamerule.category.drops"),
        UPDATES("gamerule.category.updates"),
        CHAT("gamerule.category.chat"),
        MISC("gamerule.category.misc");

        private final String descriptionId;

        private Category(String p_46273_) {
            this.descriptionId = p_46273_;
        }

        public String getDescriptionId() {
            return this.descriptionId;
        }
    }

    public static class Type<T extends Value<T>> {
        private final Supplier<ArgumentType<?>> argument;
        private final Function<Type<T>, T> constructor;
        final BiConsumer<MinecraftServer, T> callback;
        private final VisitorCaller<T> visitorCaller;

        Type(Supplier<ArgumentType<?>> p_46342_, Function<Type<T>, T> p_46343_, BiConsumer<MinecraftServer, T> p_46344_, VisitorCaller<T> p_46345_) {
            this.argument = p_46342_;
            this.constructor = p_46343_;
            this.callback = p_46344_;
            this.visitorCaller = p_46345_;
        }

        public RequiredArgumentBuilder<CommandSourceStack, ?> createArgument(String p_46359_) {
            return Commands.argument(p_46359_, this.argument.get());
        }

        public T createRule() {
            return (T)((Value)this.constructor.apply(this));
        }

        public void callVisitor(GameRuleTypeVisitor p_46354_, Key<T> p_46355_) {
            this.visitorCaller.call(p_46354_, p_46355_, this);
        }
    }

    public static abstract class Value<T extends Value<T>> {
        protected final Type<T> type;

        public Value(Type<T> p_46362_) {
            this.type = p_46362_;
        }

        protected abstract void updateFromArgument(CommandContext<CommandSourceStack> var1, String var2);

        public void setFromArgument(CommandContext<CommandSourceStack> p_46371_, String p_46372_) {
            this.updateFromArgument(p_46371_, p_46372_);
            this.onChanged(((CommandSourceStack)p_46371_.getSource()).getServer());
        }

        protected void onChanged(@Nullable MinecraftServer p_46369_) {
            if (p_46369_ != null) {
                this.type.callback.accept(p_46369_, (MinecraftServer)this.getSelf());
            }
        }

        protected abstract void deserialize(String var1);

        public abstract String serialize();

        public String toString() {
            return this.serialize();
        }

        public abstract int getCommandResult();

        protected abstract T getSelf();

        protected abstract T copy();

        public abstract void setFrom(T var1, @Nullable MinecraftServer var2);
    }

    public static interface GameRuleTypeVisitor {
        default public <T extends Value<T>> void visit(Key<T> p_46278_, Type<T> p_46279_) {
        }

        default public void visitBoolean(Key<BooleanValue> p_46280_, Type<BooleanValue> p_46281_) {
        }

        default public void visitInteger(Key<IntegerValue> p_46282_, Type<IntegerValue> p_46283_) {
        }
    }

    public static class BooleanValue
    extends Value<BooleanValue> {
        private boolean value;

        public static Type<BooleanValue> create(boolean p_46253_, BiConsumer<MinecraftServer, BooleanValue> p_46254_) {
            return new Type<BooleanValue>(BoolArgumentType::bool, p_46242_ -> new BooleanValue((Type<BooleanValue>)p_46242_, p_46253_), p_46254_, GameRuleTypeVisitor::visitBoolean);
        }

        public static Type<BooleanValue> create(boolean p_46251_) {
            return BooleanValue.create(p_46251_, (p_46236_, p_46237_) -> {});
        }

        public BooleanValue(Type<BooleanValue> p_46221_, boolean p_46222_) {
            super(p_46221_);
            this.value = p_46222_;
        }

        @Override
        protected void updateFromArgument(CommandContext<CommandSourceStack> p_46231_, String p_46232_) {
            this.value = BoolArgumentType.getBool(p_46231_, (String)p_46232_);
        }

        public boolean get() {
            return this.value;
        }

        public void set(boolean p_46247_, @Nullable MinecraftServer p_46248_) {
            this.value = p_46247_;
            this.onChanged(p_46248_);
        }

        @Override
        public String serialize() {
            return Boolean.toString(this.value);
        }

        @Override
        protected void deserialize(String p_46234_) {
            this.value = Boolean.parseBoolean(p_46234_);
        }

        @Override
        public int getCommandResult() {
            return this.value ? 1 : 0;
        }

        @Override
        protected BooleanValue getSelf() {
            return this;
        }

        @Override
        protected BooleanValue copy() {
            return new BooleanValue(this.type, this.value);
        }

        @Override
        public void setFrom(BooleanValue p_46225_, @Nullable MinecraftServer p_46226_) {
            this.value = p_46225_.value;
            this.onChanged(p_46226_);
        }
    }

    public static class IntegerValue
    extends Value<IntegerValue> {
        private int value;

        public static Type<IntegerValue> create(int p_46295_, BiConsumer<MinecraftServer, IntegerValue> p_46296_) {
            return new Type<IntegerValue>(IntegerArgumentType::integer, p_46293_ -> new IntegerValue((Type<IntegerValue>)p_46293_, p_46295_), p_46296_, GameRuleTypeVisitor::visitInteger);
        }

        public static Type<IntegerValue> create(int p_46313_) {
            return IntegerValue.create(p_46313_, (p_46309_, p_46310_) -> {});
        }

        public IntegerValue(Type<IntegerValue> p_46286_, int p_46287_) {
            super(p_46286_);
            this.value = p_46287_;
        }

        @Override
        protected void updateFromArgument(CommandContext<CommandSourceStack> p_46304_, String p_46305_) {
            this.value = IntegerArgumentType.getInteger(p_46304_, (String)p_46305_);
        }

        public int get() {
            return this.value;
        }

        public void set(int p_151490_, @Nullable MinecraftServer p_151491_) {
            this.value = p_151490_;
            this.onChanged(p_151491_);
        }

        @Override
        public String serialize() {
            return Integer.toString(this.value);
        }

        @Override
        protected void deserialize(String p_46307_) {
            this.value = IntegerValue.safeParse(p_46307_);
        }

        public boolean tryDeserialize(String p_46315_) {
            try {
                this.value = Integer.parseInt(p_46315_);
                return true;
            }
            catch (NumberFormatException numberformatexception) {
                return false;
            }
        }

        private static int safeParse(String p_46318_) {
            if (!p_46318_.isEmpty()) {
                try {
                    return Integer.parseInt(p_46318_);
                }
                catch (NumberFormatException numberformatexception) {
                    LOGGER.warn("Failed to parse integer {}", (Object)p_46318_);
                }
            }
            return 0;
        }

        @Override
        public int getCommandResult() {
            return this.value;
        }

        @Override
        protected IntegerValue getSelf() {
            return this;
        }

        @Override
        protected IntegerValue copy() {
            return new IntegerValue(this.type, this.value);
        }

        @Override
        public void setFrom(IntegerValue p_46298_, @Nullable MinecraftServer p_46299_) {
            this.value = p_46298_.value;
            this.onChanged(p_46299_);
        }
    }

    static interface VisitorCaller<T extends Value<T>> {
        public void call(GameRuleTypeVisitor var1, Key<T> var2, Type<T> var3);
    }
}

