/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.enchantment;

import java.util.Map;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentCategory;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;

public class ThornsEnchantment
extends Enchantment {
    private static final float CHANCE_PER_LEVEL = 0.15f;

    public ThornsEnchantment(Enchantment.Rarity p_45196_, EquipmentSlot ... p_45197_) {
        super(p_45196_, EnchantmentCategory.ARMOR_CHEST, p_45197_);
    }

    @Override
    public int getMinCost(int p_45200_) {
        return 10 + 20 * (p_45200_ - 1);
    }

    @Override
    public int getMaxCost(int p_45210_) {
        return super.getMinCost(p_45210_) + 50;
    }

    @Override
    public int getMaxLevel() {
        return 3;
    }

    @Override
    public boolean canEnchant(ItemStack p_45205_) {
        return p_45205_.getItem() instanceof ArmorItem ? true : super.canEnchant(p_45205_);
    }

    @Override
    public void doPostHurt(LivingEntity p_45215_, Entity p_45216_, int p_45217_) {
        RandomSource randomsource = p_45215_.getRandom();
        Map.Entry<EquipmentSlot, ItemStack> entry = EnchantmentHelper.getRandomItemWith(Enchantments.THORNS, p_45215_);
        if (ThornsEnchantment.shouldHit(p_45217_, randomsource)) {
            if (p_45216_ != null) {
                p_45216_.hurt(p_45215_.damageSources().thorns(p_45215_), ThornsEnchantment.getDamage(p_45217_, randomsource));
            }
            if (entry != null) {
                entry.getValue().hurtAndBreak(2, p_45215_, p_45208_ -> p_45208_.broadcastBreakEvent((EquipmentSlot)((Object)((Object)entry.getKey()))));
            }
        }
    }

    public static boolean shouldHit(int p_220317_, RandomSource p_220318_) {
        if (p_220317_ <= 0) {
            return false;
        }
        return p_220318_.nextFloat() < 0.15f * (float)p_220317_;
    }

    public static int getDamage(int p_220320_, RandomSource p_220321_) {
        return p_220320_ > 10 ? p_220320_ - 10 : 1 + p_220321_.nextInt(4);
    }
}

