/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.enchantment;

import java.util.function.Predicate;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.DiggerItem;
import net.minecraft.world.item.Equipable;
import net.minecraft.world.item.FishingRodItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.TridentItem;
import net.minecraft.world.item.Vanishable;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.IExtensibleEnum;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum EnchantmentCategory implements IExtensibleEnum
{
    ARMOR{

        @Override
        public boolean canEnchant(Item p_44751_) {
            return p_44751_ instanceof ArmorItem;
        }
    }
    ,
    ARMOR_FEET{

        @Override
        public boolean canEnchant(Item p_44806_) {
            ArmorItem armoritem;
            return p_44806_ instanceof ArmorItem && (armoritem = (ArmorItem)p_44806_).getEquipmentSlot() == EquipmentSlot.FEET;
        }
    }
    ,
    ARMOR_LEGS{

        @Override
        public boolean canEnchant(Item p_44811_) {
            ArmorItem armoritem;
            return p_44811_ instanceof ArmorItem && (armoritem = (ArmorItem)p_44811_).getEquipmentSlot() == EquipmentSlot.LEGS;
        }
    }
    ,
    ARMOR_CHEST{

        @Override
        public boolean canEnchant(Item p_44816_) {
            ArmorItem armoritem;
            return p_44816_ instanceof ArmorItem && (armoritem = (ArmorItem)p_44816_).getEquipmentSlot() == EquipmentSlot.CHEST;
        }
    }
    ,
    ARMOR_HEAD{

        @Override
        public boolean canEnchant(Item p_44756_) {
            ArmorItem armoritem;
            return p_44756_ instanceof ArmorItem && (armoritem = (ArmorItem)p_44756_).getEquipmentSlot() == EquipmentSlot.HEAD;
        }
    }
    ,
    WEAPON{

        @Override
        public boolean canEnchant(Item p_44761_) {
            return p_44761_ instanceof SwordItem;
        }
    }
    ,
    DIGGER{

        @Override
        public boolean canEnchant(Item p_44766_) {
            return p_44766_ instanceof DiggerItem;
        }
    }
    ,
    FISHING_ROD{

        @Override
        public boolean canEnchant(Item p_44771_) {
            return p_44771_ instanceof FishingRodItem;
        }
    }
    ,
    TRIDENT{

        @Override
        public boolean canEnchant(Item p_44776_) {
            return p_44776_ instanceof TridentItem;
        }
    }
    ,
    BREAKABLE{

        @Override
        public boolean canEnchant(Item p_44781_) {
            return p_44781_.canBeDepleted();
        }
    }
    ,
    BOW{

        @Override
        public boolean canEnchant(Item p_44786_) {
            return p_44786_ instanceof BowItem;
        }
    }
    ,
    WEARABLE{

        @Override
        public boolean canEnchant(Item p_44791_) {
            return p_44791_ instanceof Equipable || Block.byItem(p_44791_) instanceof Equipable;
        }
    }
    ,
    CROSSBOW{

        @Override
        public boolean canEnchant(Item p_44796_) {
            return p_44796_ instanceof CrossbowItem;
        }
    }
    ,
    VANISHABLE{

        @Override
        public boolean canEnchant(Item p_44801_) {
            return p_44801_ instanceof Vanishable || Block.byItem(p_44801_) instanceof Vanishable || BREAKABLE.canEnchant(p_44801_);
        }
    };

    private Predicate<Item> delegate;

    private EnchantmentCategory() {
    }

    private EnchantmentCategory(Predicate<Item> delegate) {
        this.delegate = delegate;
    }

    public static EnchantmentCategory create(String name, Predicate<Item> delegate) {
        throw new IllegalStateException("Enum not extended");
    }

    public boolean canEnchant(Item p_44743_) {
        return this.delegate == null ? false : this.delegate.test(p_44743_);
    }
}

