/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentUtils;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.stats.Stats;
import net.minecraft.util.StringUtil;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.WritableBookItem;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LecternBlock;
import net.minecraft.world.level.block.state.BlockState;

public class WrittenBookItem
extends Item {
    public static final int TITLE_LENGTH = 16;
    public static final int TITLE_MAX_LENGTH = 32;
    public static final int PAGE_EDIT_LENGTH = 1024;
    public static final int PAGE_LENGTH = Short.MAX_VALUE;
    public static final int MAX_PAGES = 100;
    public static final int MAX_GENERATION = 2;
    public static final String TAG_TITLE = "title";
    public static final String TAG_FILTERED_TITLE = "filtered_title";
    public static final String TAG_AUTHOR = "author";
    public static final String TAG_PAGES = "pages";
    public static final String TAG_FILTERED_PAGES = "filtered_pages";
    public static final String TAG_GENERATION = "generation";
    public static final String TAG_RESOLVED = "resolved";

    public WrittenBookItem(Item.Properties p_43455_) {
        super(p_43455_);
    }

    public static boolean makeSureTagIsValid(@Nullable CompoundTag p_43472_) {
        if (!WritableBookItem.makeSureTagIsValid(p_43472_)) {
            return false;
        }
        if (!p_43472_.contains(TAG_TITLE, 8)) {
            return false;
        }
        String s = p_43472_.getString(TAG_TITLE);
        return s.length() > 32 ? false : p_43472_.contains(TAG_AUTHOR, 8);
    }

    public static int getGeneration(ItemStack p_43474_) {
        return p_43474_.getTag().getInt(TAG_GENERATION);
    }

    public static int getPageCount(ItemStack p_43478_) {
        CompoundTag compoundtag = p_43478_.getTag();
        return compoundtag != null ? compoundtag.getList(TAG_PAGES, 8).size() : 0;
    }

    @Override
    public Component getName(ItemStack p_43480_) {
        String s;
        CompoundTag compoundtag = p_43480_.getTag();
        if (compoundtag != null && !StringUtil.isNullOrEmpty(s = compoundtag.getString(TAG_TITLE))) {
            return Component.literal(s);
        }
        return super.getName(p_43480_);
    }

    @Override
    public void appendHoverText(ItemStack p_43457_, @Nullable Level p_43458_, List<Component> p_43459_, TooltipFlag p_43460_) {
        if (p_43457_.hasTag()) {
            CompoundTag compoundtag = p_43457_.getTag();
            String s = compoundtag.getString(TAG_AUTHOR);
            if (!StringUtil.isNullOrEmpty(s)) {
                p_43459_.add(Component.translatable("book.byAuthor", s).withStyle(ChatFormatting.GRAY));
            }
            p_43459_.add(Component.translatable("book.generation." + compoundtag.getInt(TAG_GENERATION)).withStyle(ChatFormatting.GRAY));
        }
    }

    @Override
    public InteractionResult useOn(UseOnContext p_43466_) {
        BlockPos blockpos;
        Level level = p_43466_.getLevel();
        BlockState blockstate = level.getBlockState(blockpos = p_43466_.getClickedPos());
        if (blockstate.is(Blocks.LECTERN)) {
            return LecternBlock.tryPlaceBook(p_43466_.getPlayer(), level, blockpos, blockstate, p_43466_.getItemInHand()) ? InteractionResult.sidedSuccess(level.isClientSide) : InteractionResult.PASS;
        }
        return InteractionResult.PASS;
    }

    @Override
    public InteractionResultHolder<ItemStack> use(Level p_43468_, Player p_43469_, InteractionHand p_43470_) {
        ItemStack itemstack = p_43469_.getItemInHand(p_43470_);
        p_43469_.openItemGui(itemstack, p_43470_);
        p_43469_.awardStat(Stats.ITEM_USED.get(this));
        return InteractionResultHolder.sidedSuccess(itemstack, p_43468_.isClientSide());
    }

    public static boolean resolveBookComponents(ItemStack p_43462_, @Nullable CommandSourceStack p_43463_, @Nullable Player p_43464_) {
        CompoundTag compoundtag = p_43462_.getTag();
        if (compoundtag != null && !compoundtag.getBoolean(TAG_RESOLVED)) {
            compoundtag.putBoolean(TAG_RESOLVED, true);
            if (!WrittenBookItem.makeSureTagIsValid(compoundtag)) {
                return false;
            }
            ListTag listtag = compoundtag.getList(TAG_PAGES, 8);
            ListTag listtag1 = new ListTag();
            for (int i = 0; i < listtag.size(); ++i) {
                String s = WrittenBookItem.resolvePage(p_43463_, p_43464_, listtag.getString(i));
                if (s.length() > Short.MAX_VALUE) {
                    return false;
                }
                listtag1.add(i, StringTag.valueOf(s));
            }
            if (compoundtag.contains(TAG_FILTERED_PAGES, 10)) {
                CompoundTag compoundtag1 = compoundtag.getCompound(TAG_FILTERED_PAGES);
                CompoundTag compoundtag2 = new CompoundTag();
                for (String s1 : compoundtag1.getAllKeys()) {
                    String s2 = WrittenBookItem.resolvePage(p_43463_, p_43464_, compoundtag1.getString(s1));
                    if (s2.length() > Short.MAX_VALUE) {
                        return false;
                    }
                    compoundtag2.putString(s1, s2);
                }
                compoundtag.put(TAG_FILTERED_PAGES, compoundtag2);
            }
            compoundtag.put(TAG_PAGES, listtag1);
            return true;
        }
        return false;
    }

    private static String resolvePage(@Nullable CommandSourceStack p_151249_, @Nullable Player p_151250_, String p_151251_) {
        MutableComponent component;
        try {
            component = Component.Serializer.fromJsonLenient(p_151251_);
            component = ComponentUtils.updateForEntity(p_151249_, component, (Entity)p_151250_, 0);
        }
        catch (Exception exception) {
            component = Component.literal(p_151251_);
        }
        return Component.Serializer.toJson(component);
    }

    @Override
    public boolean isFoil(ItemStack p_43476_) {
        return true;
    }
}

