/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import com.mojang.logging.LogUtils;
import com.mojang.serialization.DynamicOps;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.village.poi.PoiTypes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Vanishable;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import org.slf4j.Logger;

public class CompassItem
extends Item
implements Vanishable {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final String TAG_LODESTONE_POS = "LodestonePos";
    public static final String TAG_LODESTONE_DIMENSION = "LodestoneDimension";
    public static final String TAG_LODESTONE_TRACKED = "LodestoneTracked";

    public CompassItem(Item.Properties p_40718_) {
        super(p_40718_);
    }

    public static boolean isLodestoneCompass(ItemStack p_40737_) {
        CompoundTag compoundtag = p_40737_.getTag();
        return compoundtag != null && (compoundtag.contains(TAG_LODESTONE_DIMENSION) || compoundtag.contains(TAG_LODESTONE_POS));
    }

    private static Optional<ResourceKey<Level>> getLodestoneDimension(CompoundTag p_40728_) {
        return Level.RESOURCE_KEY_CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)p_40728_.get(TAG_LODESTONE_DIMENSION)).result();
    }

    @Nullable
    public static GlobalPos getLodestonePosition(CompoundTag p_220022_) {
        Optional<ResourceKey<Level>> optional;
        boolean flag = p_220022_.contains(TAG_LODESTONE_POS);
        boolean flag1 = p_220022_.contains(TAG_LODESTONE_DIMENSION);
        if (flag && flag1 && (optional = CompassItem.getLodestoneDimension(p_220022_)).isPresent()) {
            BlockPos blockpos = NbtUtils.readBlockPos(p_220022_.getCompound(TAG_LODESTONE_POS));
            return GlobalPos.of(optional.get(), blockpos);
        }
        return null;
    }

    @Nullable
    public static GlobalPos getSpawnPosition(Level p_220020_) {
        return p_220020_.dimensionType().natural() ? GlobalPos.of(p_220020_.dimension(), p_220020_.getSharedSpawnPos()) : null;
    }

    @Override
    public boolean isFoil(ItemStack p_40739_) {
        return CompassItem.isLodestoneCompass(p_40739_) || super.isFoil(p_40739_);
    }

    @Override
    public void inventoryTick(ItemStack p_40720_, Level p_40721_, Entity p_40722_, int p_40723_, boolean p_40724_) {
        if (!p_40721_.isClientSide && CompassItem.isLodestoneCompass(p_40720_)) {
            BlockPos blockpos;
            CompoundTag compoundtag = p_40720_.getOrCreateTag();
            if (compoundtag.contains(TAG_LODESTONE_TRACKED) && !compoundtag.getBoolean(TAG_LODESTONE_TRACKED)) {
                return;
            }
            Optional<ResourceKey<Level>> optional = CompassItem.getLodestoneDimension(compoundtag);
            if (optional.isPresent() && optional.get() == p_40721_.dimension() && compoundtag.contains(TAG_LODESTONE_POS) && (!p_40721_.isInWorldBounds(blockpos = NbtUtils.readBlockPos(compoundtag.getCompound(TAG_LODESTONE_POS))) || !((ServerLevel)p_40721_).getPoiManager().existsAtPosition(PoiTypes.LODESTONE, blockpos))) {
                compoundtag.remove(TAG_LODESTONE_POS);
            }
        }
    }

    @Override
    public InteractionResult useOn(UseOnContext p_40726_) {
        boolean flag;
        BlockPos blockpos = p_40726_.getClickedPos();
        Level level = p_40726_.getLevel();
        if (!level.getBlockState(blockpos).is(Blocks.LODESTONE)) {
            return super.useOn(p_40726_);
        }
        level.playSound((Player)null, blockpos, SoundEvents.LODESTONE_COMPASS_LOCK, SoundSource.PLAYERS, 1.0f, 1.0f);
        Player player = p_40726_.getPlayer();
        ItemStack itemstack = p_40726_.getItemInHand();
        boolean bl = flag = !player.getAbilities().instabuild && itemstack.getCount() == 1;
        if (flag) {
            this.addLodestoneTags(level.dimension(), blockpos, itemstack.getOrCreateTag());
        } else {
            ItemStack itemstack1 = new ItemStack(Items.COMPASS, 1);
            CompoundTag compoundtag = itemstack.hasTag() ? itemstack.getTag().copy() : new CompoundTag();
            itemstack1.setTag(compoundtag);
            if (!player.getAbilities().instabuild) {
                itemstack.shrink(1);
            }
            this.addLodestoneTags(level.dimension(), blockpos, compoundtag);
            if (!player.getInventory().add(itemstack1)) {
                player.drop(itemstack1, false);
            }
        }
        return InteractionResult.sidedSuccess(level.isClientSide);
    }

    private void addLodestoneTags(ResourceKey<Level> p_40733_, BlockPos p_40734_, CompoundTag p_40735_) {
        p_40735_.put(TAG_LODESTONE_POS, NbtUtils.writeBlockPos(p_40734_));
        Level.RESOURCE_KEY_CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, p_40733_).resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0)).ifPresent(p_40731_ -> p_40735_.put(TAG_LODESTONE_DIMENSION, (Tag)p_40731_));
        p_40735_.putBoolean(TAG_LODESTONE_TRACKED, true);
    }

    @Override
    public String getDescriptionId(ItemStack p_40741_) {
        return CompassItem.isLodestoneCompass(p_40741_) ? "item.minecraft.lodestone_compass" : super.getDescriptionId(p_40741_);
    }
}

