/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import java.util.List;
import java.util.function.Predicate;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.entity.vehicle.ChestBoat;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class BoatItem
extends Item {
    private static final Predicate<Entity> ENTITY_PREDICATE = EntitySelector.NO_SPECTATORS.and(Entity::isPickable);
    private final Boat.Type type;
    private final boolean hasChest;

    public BoatItem(boolean p_220013_, Boat.Type p_220014_, Item.Properties p_220015_) {
        super(p_220015_);
        this.hasChest = p_220013_;
        this.type = p_220014_;
    }

    @Override
    public InteractionResultHolder<ItemStack> use(Level p_40622_, Player p_40623_, InteractionHand p_40624_) {
        ItemStack itemstack = p_40623_.getItemInHand(p_40624_);
        BlockHitResult hitresult = BoatItem.getPlayerPOVHitResult(p_40622_, p_40623_, ClipContext.Fluid.ANY);
        if (((HitResult)hitresult).getType() == HitResult.Type.MISS) {
            return InteractionResultHolder.pass(itemstack);
        }
        Vec3 vec3 = p_40623_.getViewVector(1.0f);
        double d0 = 5.0;
        List<Entity> list = p_40622_.getEntities(p_40623_, p_40623_.getBoundingBox().expandTowards(vec3.scale(5.0)).inflate(1.0), ENTITY_PREDICATE);
        if (!list.isEmpty()) {
            Vec3 vec31 = p_40623_.getEyePosition();
            for (Entity entity : list) {
                AABB aabb = entity.getBoundingBox().inflate(entity.getPickRadius());
                if (!aabb.contains(vec31)) continue;
                return InteractionResultHolder.pass(itemstack);
            }
        }
        if (((HitResult)hitresult).getType() == HitResult.Type.BLOCK) {
            Boat boat = this.getBoat(p_40622_, hitresult);
            boat.setVariant(this.type);
            boat.setYRot(p_40623_.getYRot());
            if (!p_40622_.noCollision(boat, boat.getBoundingBox())) {
                return InteractionResultHolder.fail(itemstack);
            }
            if (!p_40622_.isClientSide) {
                p_40622_.addFreshEntity(boat);
                p_40622_.gameEvent((Entity)p_40623_, GameEvent.ENTITY_PLACE, hitresult.getLocation());
                if (!p_40623_.getAbilities().instabuild) {
                    itemstack.shrink(1);
                }
            }
            p_40623_.awardStat(Stats.ITEM_USED.get(this));
            return InteractionResultHolder.sidedSuccess(itemstack, p_40622_.isClientSide());
        }
        return InteractionResultHolder.pass(itemstack);
    }

    private Boat getBoat(Level p_220017_, HitResult p_220018_) {
        return this.hasChest ? new ChestBoat(p_220017_, p_220018_.getLocation().x, p_220018_.getLocation().y, p_220018_.getLocation().z) : new Boat(p_220017_, p_220018_.getLocation().x, p_220018_.getLocation().y, p_220018_.getLocation().z);
    }
}

