/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.goal;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Sets;
import com.mojang.logging.LogUtils;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.WrappedGoal;
import org.slf4j.Logger;

public class GoalSelector {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final WrappedGoal NO_GOAL = new WrappedGoal(Integer.MAX_VALUE, new Goal(){

        @Override
        public boolean canUse() {
            return false;
        }
    }){

        @Override
        public boolean isRunning() {
            return false;
        }
    };
    private final Map<Goal.Flag, WrappedGoal> lockedFlags = new EnumMap<Goal.Flag, WrappedGoal>(Goal.Flag.class);
    private final Set<WrappedGoal> availableGoals = Sets.newLinkedHashSet();
    private final Supplier<ProfilerFiller> profiler;
    private final EnumSet<Goal.Flag> disabledFlags = EnumSet.noneOf(Goal.Flag.class);
    private int tickCount;
    private int newGoalRate = 3;

    public GoalSelector(Supplier<ProfilerFiller> p_25351_) {
        this.profiler = p_25351_;
    }

    public void addGoal(int p_25353_, Goal p_25354_) {
        this.availableGoals.add(new WrappedGoal(p_25353_, p_25354_));
    }

    @VisibleForTesting
    public void removeAllGoals(Predicate<Goal> p_262575_) {
        this.availableGoals.removeIf(p_262564_ -> p_262575_.test(p_262564_.getGoal()));
    }

    public void removeGoal(Goal p_25364_) {
        this.availableGoals.stream().filter(p_25378_ -> p_25378_.getGoal() == p_25364_).filter(WrappedGoal::isRunning).forEach(WrappedGoal::stop);
        this.availableGoals.removeIf(p_25367_ -> p_25367_.getGoal() == p_25364_);
    }

    private static boolean goalContainsAnyFlags(WrappedGoal p_186076_, EnumSet<Goal.Flag> p_186077_) {
        for (Goal.Flag goal$flag : p_186076_.getFlags()) {
            if (!p_186077_.contains((Object)goal$flag)) continue;
            return true;
        }
        return false;
    }

    private static boolean goalCanBeReplacedForAllFlags(WrappedGoal p_186079_, Map<Goal.Flag, WrappedGoal> p_186080_) {
        for (Goal.Flag goal$flag : p_186079_.getFlags()) {
            if (p_186080_.getOrDefault((Object)goal$flag, NO_GOAL).canBeReplacedBy(p_186079_)) continue;
            return false;
        }
        return true;
    }

    public void tick() {
        ProfilerFiller profilerfiller = this.profiler.get();
        profilerfiller.push("goalCleanup");
        for (WrappedGoal wrappedgoal : this.availableGoals) {
            if (!wrappedgoal.isRunning() || !GoalSelector.goalContainsAnyFlags(wrappedgoal, this.disabledFlags) && wrappedgoal.canContinueToUse()) continue;
            wrappedgoal.stop();
        }
        Iterator<Map.Entry<Goal.Flag, WrappedGoal>> iterator = this.lockedFlags.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Goal.Flag, WrappedGoal> entry = iterator.next();
            if (entry.getValue().isRunning()) continue;
            iterator.remove();
        }
        profilerfiller.pop();
        profilerfiller.push("goalUpdate");
        for (WrappedGoal wrappedgoal2 : this.availableGoals) {
            if (wrappedgoal2.isRunning() || GoalSelector.goalContainsAnyFlags(wrappedgoal2, this.disabledFlags) || !GoalSelector.goalCanBeReplacedForAllFlags(wrappedgoal2, this.lockedFlags) || !wrappedgoal2.canUse()) continue;
            for (Goal.Flag goal$flag : wrappedgoal2.getFlags()) {
                WrappedGoal wrappedgoal1 = this.lockedFlags.getOrDefault((Object)goal$flag, NO_GOAL);
                wrappedgoal1.stop();
                this.lockedFlags.put(goal$flag, wrappedgoal2);
            }
            wrappedgoal2.start();
        }
        profilerfiller.pop();
        this.tickRunningGoals(true);
    }

    public void tickRunningGoals(boolean p_186082_) {
        ProfilerFiller profilerfiller = this.profiler.get();
        profilerfiller.push("goalTick");
        for (WrappedGoal wrappedgoal : this.availableGoals) {
            if (!wrappedgoal.isRunning() || !p_186082_ && !wrappedgoal.requiresUpdateEveryTick()) continue;
            wrappedgoal.tick();
        }
        profilerfiller.pop();
    }

    public Set<WrappedGoal> getAvailableGoals() {
        return this.availableGoals;
    }

    public Stream<WrappedGoal> getRunningGoals() {
        return this.availableGoals.stream().filter(WrappedGoal::isRunning);
    }

    public void setNewGoalRate(int p_148098_) {
        this.newGoalRate = p_148098_;
    }

    public void disableControlFlag(Goal.Flag p_25356_) {
        this.disabledFlags.add(p_25356_);
    }

    public void enableControlFlag(Goal.Flag p_25375_) {
        this.disabledFlags.remove((Object)p_25375_);
    }

    public void setControlFlag(Goal.Flag p_25361_, boolean p_25362_) {
        if (p_25362_) {
            this.enableControlFlag(p_25361_);
        } else {
            this.disableControlFlag(p_25361_);
        }
    }
}

