/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity;

import java.util.function.Predicate;
import net.minecraft.world.Container;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;

public interface SlotAccess {
    public static final SlotAccess NULL = new SlotAccess(){

        @Override
        public ItemStack get() {
            return ItemStack.EMPTY;
        }

        @Override
        public boolean set(ItemStack p_147314_) {
            return false;
        }
    };

    public static SlotAccess forContainer(final Container p_147296_, final int p_147297_, final Predicate<ItemStack> p_147298_) {
        return new SlotAccess(){

            @Override
            public ItemStack get() {
                return p_147296_.getItem(p_147297_);
            }

            @Override
            public boolean set(ItemStack p_147324_) {
                if (!p_147298_.test(p_147324_)) {
                    return false;
                }
                p_147296_.setItem(p_147297_, p_147324_);
                return true;
            }
        };
    }

    public static SlotAccess forContainer(Container p_147293_, int p_147294_) {
        return SlotAccess.forContainer(p_147293_, p_147294_, p_147310_ -> true);
    }

    public static SlotAccess forEquipmentSlot(final LivingEntity p_147303_, final EquipmentSlot p_147304_, final Predicate<ItemStack> p_147305_) {
        return new SlotAccess(){

            @Override
            public ItemStack get() {
                return p_147303_.getItemBySlot(p_147304_);
            }

            @Override
            public boolean set(ItemStack p_147334_) {
                if (!p_147305_.test(p_147334_)) {
                    return false;
                }
                p_147303_.setItemSlot(p_147304_, p_147334_);
                return true;
            }
        };
    }

    public static SlotAccess forEquipmentSlot(LivingEntity p_147300_, EquipmentSlot p_147301_) {
        return SlotAccess.forEquipmentSlot(p_147300_, p_147301_, p_147308_ -> true);
    }

    public ItemStack get();

    public boolean set(ItemStack var1);
}

