/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity;

import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;

public interface NeutralMob {
    public static final String TAG_ANGER_TIME = "AngerTime";
    public static final String TAG_ANGRY_AT = "AngryAt";

    public int getRemainingPersistentAngerTime();

    public void setRemainingPersistentAngerTime(int var1);

    @Nullable
    public UUID getPersistentAngerTarget();

    public void setPersistentAngerTarget(@Nullable UUID var1);

    public void startPersistentAngerTimer();

    default public void addPersistentAngerSaveData(CompoundTag p_21679_) {
        p_21679_.putInt(TAG_ANGER_TIME, this.getRemainingPersistentAngerTime());
        if (this.getPersistentAngerTarget() != null) {
            p_21679_.putUUID(TAG_ANGRY_AT, this.getPersistentAngerTarget());
        }
    }

    default public void readPersistentAngerSaveData(Level p_147286_, CompoundTag p_147287_) {
        this.setRemainingPersistentAngerTime(p_147287_.getInt(TAG_ANGER_TIME));
        if (p_147286_ instanceof ServerLevel) {
            if (!p_147287_.hasUUID(TAG_ANGRY_AT)) {
                this.setPersistentAngerTarget(null);
            } else {
                UUID uuid = p_147287_.getUUID(TAG_ANGRY_AT);
                this.setPersistentAngerTarget(uuid);
                Entity entity = ((ServerLevel)p_147286_).getEntity(uuid);
                if (entity != null) {
                    if (entity instanceof Mob) {
                        this.setLastHurtByMob((Mob)entity);
                    }
                    if (entity.getType() == EntityType.PLAYER) {
                        this.setLastHurtByPlayer((Player)entity);
                    }
                }
            }
        }
    }

    default public void updatePersistentAnger(ServerLevel p_21667_, boolean p_21668_) {
        LivingEntity livingentity = this.getTarget();
        UUID uuid = this.getPersistentAngerTarget();
        if ((livingentity == null || livingentity.isDeadOrDying()) && uuid != null && p_21667_.getEntity(uuid) instanceof Mob) {
            this.stopBeingAngry();
        } else {
            if (livingentity != null && !Objects.equals(uuid, livingentity.getUUID())) {
                this.setPersistentAngerTarget(livingentity.getUUID());
                this.startPersistentAngerTimer();
            }
            if (!(this.getRemainingPersistentAngerTime() <= 0 || livingentity != null && livingentity.getType() == EntityType.PLAYER && p_21668_)) {
                this.setRemainingPersistentAngerTime(this.getRemainingPersistentAngerTime() - 1);
                if (this.getRemainingPersistentAngerTime() == 0) {
                    this.stopBeingAngry();
                }
            }
        }
    }

    default public boolean isAngryAt(LivingEntity p_21675_) {
        if (!this.canAttack(p_21675_)) {
            return false;
        }
        return p_21675_.getType() == EntityType.PLAYER && this.isAngryAtAllPlayers(p_21675_.level()) ? true : p_21675_.getUUID().equals(this.getPersistentAngerTarget());
    }

    default public boolean isAngryAtAllPlayers(Level p_21671_) {
        return p_21671_.getGameRules().getBoolean(GameRules.RULE_UNIVERSAL_ANGER) && this.isAngry() && this.getPersistentAngerTarget() == null;
    }

    default public boolean isAngry() {
        return this.getRemainingPersistentAngerTime() > 0;
    }

    default public void playerDied(Player p_21677_) {
        if (p_21677_.level().getGameRules().getBoolean(GameRules.RULE_FORGIVE_DEAD_PLAYERS) && p_21677_.getUUID().equals(this.getPersistentAngerTarget())) {
            this.stopBeingAngry();
        }
    }

    default public void forgetCurrentTargetAndRefreshUniversalAnger() {
        this.stopBeingAngry();
        this.startPersistentAngerTimer();
    }

    default public void stopBeingAngry() {
        this.setLastHurtByMob(null);
        this.setPersistentAngerTarget(null);
        this.setTarget(null);
        this.setRemainingPersistentAngerTime(0);
    }

    @Nullable
    public LivingEntity getLastHurtByMob();

    public void setLastHurtByMob(@Nullable LivingEntity var1);

    public void setLastHurtByPlayer(@Nullable Player var1);

    public void setTarget(@Nullable LivingEntity var1);

    public boolean canAttack(LivingEntity var1);

    @Nullable
    public LivingEntity getTarget();
}

