/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity;

import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import com.mojang.math.Transformation;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.List;
import java.util.Optional;
import java.util.function.IntFunction;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentUtils;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.util.Brightness;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.FastColor;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.AABB;
import org.joml.Quaternionf;
import org.joml.Vector3f;
import org.slf4j.Logger;

public abstract class Display
extends Entity {
    static final Logger LOGGER = LogUtils.getLogger();
    public static final int NO_BRIGHTNESS_OVERRIDE = -1;
    private static final EntityDataAccessor<Integer> DATA_INTERPOLATION_START_DELTA_TICKS_ID = SynchedEntityData.defineId(Display.class, EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> DATA_INTERPOLATION_DURATION_ID = SynchedEntityData.defineId(Display.class, EntityDataSerializers.INT);
    private static final EntityDataAccessor<Vector3f> DATA_TRANSLATION_ID = SynchedEntityData.defineId(Display.class, EntityDataSerializers.VECTOR3);
    private static final EntityDataAccessor<Vector3f> DATA_SCALE_ID = SynchedEntityData.defineId(Display.class, EntityDataSerializers.VECTOR3);
    private static final EntityDataAccessor<Quaternionf> DATA_LEFT_ROTATION_ID = SynchedEntityData.defineId(Display.class, EntityDataSerializers.QUATERNION);
    private static final EntityDataAccessor<Quaternionf> DATA_RIGHT_ROTATION_ID = SynchedEntityData.defineId(Display.class, EntityDataSerializers.QUATERNION);
    private static final EntityDataAccessor<Byte> DATA_BILLBOARD_RENDER_CONSTRAINTS_ID = SynchedEntityData.defineId(Display.class, EntityDataSerializers.BYTE);
    private static final EntityDataAccessor<Integer> DATA_BRIGHTNESS_OVERRIDE_ID = SynchedEntityData.defineId(Display.class, EntityDataSerializers.INT);
    private static final EntityDataAccessor<Float> DATA_VIEW_RANGE_ID = SynchedEntityData.defineId(Display.class, EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Float> DATA_SHADOW_RADIUS_ID = SynchedEntityData.defineId(Display.class, EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Float> DATA_SHADOW_STRENGTH_ID = SynchedEntityData.defineId(Display.class, EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Float> DATA_WIDTH_ID = SynchedEntityData.defineId(Display.class, EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Float> DATA_HEIGHT_ID = SynchedEntityData.defineId(Display.class, EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Integer> DATA_GLOW_COLOR_OVERRIDE_ID = SynchedEntityData.defineId(Display.class, EntityDataSerializers.INT);
    private static final IntSet RENDER_STATE_IDS = IntSet.of((int[])new int[]{DATA_TRANSLATION_ID.getId(), DATA_SCALE_ID.getId(), DATA_LEFT_ROTATION_ID.getId(), DATA_RIGHT_ROTATION_ID.getId(), DATA_BILLBOARD_RENDER_CONSTRAINTS_ID.getId(), DATA_BRIGHTNESS_OVERRIDE_ID.getId(), DATA_SHADOW_RADIUS_ID.getId(), DATA_SHADOW_STRENGTH_ID.getId()});
    private static final float INITIAL_SHADOW_RADIUS = 0.0f;
    private static final float INITIAL_SHADOW_STRENGTH = 1.0f;
    private static final int NO_GLOW_COLOR_OVERRIDE = -1;
    public static final String TAG_INTERPOLATION_DURATION = "interpolation_duration";
    public static final String TAG_START_INTERPOLATION = "start_interpolation";
    public static final String TAG_TRANSFORMATION = "transformation";
    public static final String TAG_BILLBOARD = "billboard";
    public static final String TAG_BRIGHTNESS = "brightness";
    public static final String TAG_VIEW_RANGE = "view_range";
    public static final String TAG_SHADOW_RADIUS = "shadow_radius";
    public static final String TAG_SHADOW_STRENGTH = "shadow_strength";
    public static final String TAG_WIDTH = "width";
    public static final String TAG_HEIGHT = "height";
    public static final String TAG_GLOW_COLOR_OVERRIDE = "glow_color_override";
    private final Quaternionf orientation = new Quaternionf();
    private long interpolationStartClientTick = Integer.MIN_VALUE;
    private int interpolationDuration;
    private float lastProgress;
    private AABB cullingBoundingBox;
    protected boolean updateRenderState;
    private boolean updateStartTick;
    private boolean updateInterpolationDuration;
    @Nullable
    private RenderState renderState;

    public Display(EntityType<?> p_270360_, Level p_270280_) {
        super(p_270360_, p_270280_);
        this.noPhysics = true;
        this.noCulling = true;
        this.cullingBoundingBox = this.getBoundingBox();
    }

    @Override
    public void onSyncedDataUpdated(EntityDataAccessor<?> p_270275_) {
        super.onSyncedDataUpdated(p_270275_);
        if (DATA_HEIGHT_ID.equals(p_270275_) || DATA_WIDTH_ID.equals(p_270275_)) {
            this.updateCulling();
        }
        if (DATA_INTERPOLATION_START_DELTA_TICKS_ID.equals(p_270275_)) {
            this.updateStartTick = true;
        }
        if (DATA_INTERPOLATION_DURATION_ID.equals(p_270275_)) {
            this.updateInterpolationDuration = true;
        }
        if (RENDER_STATE_IDS.contains(p_270275_.getId())) {
            this.updateRenderState = true;
        }
    }

    private static Transformation createTransformation(SynchedEntityData p_270278_) {
        Vector3f vector3f = p_270278_.get(DATA_TRANSLATION_ID);
        Quaternionf quaternionf = p_270278_.get(DATA_LEFT_ROTATION_ID);
        Vector3f vector3f1 = p_270278_.get(DATA_SCALE_ID);
        Quaternionf quaternionf1 = p_270278_.get(DATA_RIGHT_ROTATION_ID);
        return new Transformation(vector3f, quaternionf, vector3f1, quaternionf1);
    }

    @Override
    public void tick() {
        Entity entity = this.getVehicle();
        if (entity != null && entity.isRemoved()) {
            this.stopRiding();
        }
        if (this.level().isClientSide) {
            if (this.updateStartTick) {
                this.updateStartTick = false;
                int i = this.getInterpolationDelay();
                this.interpolationStartClientTick = this.tickCount + i;
            }
            if (this.updateInterpolationDuration) {
                this.updateInterpolationDuration = false;
                this.interpolationDuration = this.getInterpolationDuration();
            }
            if (this.updateRenderState) {
                this.updateRenderState = false;
                boolean flag = this.interpolationDuration != 0;
                this.renderState = flag && this.renderState != null ? this.createInterpolatedRenderState(this.renderState, this.lastProgress) : this.createFreshRenderState();
                this.updateRenderSubState(flag, this.lastProgress);
            }
        }
    }

    protected abstract void updateRenderSubState(boolean var1, float var2);

    @Override
    protected void defineSynchedData() {
        this.entityData.define(DATA_INTERPOLATION_START_DELTA_TICKS_ID, 0);
        this.entityData.define(DATA_INTERPOLATION_DURATION_ID, 0);
        this.entityData.define(DATA_TRANSLATION_ID, new Vector3f());
        this.entityData.define(DATA_SCALE_ID, new Vector3f(1.0f, 1.0f, 1.0f));
        this.entityData.define(DATA_RIGHT_ROTATION_ID, new Quaternionf());
        this.entityData.define(DATA_LEFT_ROTATION_ID, new Quaternionf());
        this.entityData.define(DATA_BILLBOARD_RENDER_CONSTRAINTS_ID, BillboardConstraints.FIXED.getId());
        this.entityData.define(DATA_BRIGHTNESS_OVERRIDE_ID, -1);
        this.entityData.define(DATA_VIEW_RANGE_ID, Float.valueOf(1.0f));
        this.entityData.define(DATA_SHADOW_RADIUS_ID, Float.valueOf(0.0f));
        this.entityData.define(DATA_SHADOW_STRENGTH_ID, Float.valueOf(1.0f));
        this.entityData.define(DATA_WIDTH_ID, Float.valueOf(0.0f));
        this.entityData.define(DATA_HEIGHT_ID, Float.valueOf(0.0f));
        this.entityData.define(DATA_GLOW_COLOR_OVERRIDE_ID, -1);
    }

    @Override
    protected void readAdditionalSaveData(CompoundTag p_270854_) {
        if (p_270854_.contains(TAG_TRANSFORMATION)) {
            Transformation.EXTENDED_CODEC.decode((DynamicOps)NbtOps.INSTANCE, (Object)p_270854_.get(TAG_TRANSFORMATION)).resultOrPartial(Util.prefix("Display entity", arg_0 -> ((Logger)LOGGER).error(arg_0))).ifPresent(p_270952_ -> this.setTransformation((Transformation)p_270952_.getFirst()));
        }
        if (p_270854_.contains(TAG_INTERPOLATION_DURATION, 99)) {
            int i = p_270854_.getInt(TAG_INTERPOLATION_DURATION);
            this.setInterpolationDuration(i);
        }
        if (p_270854_.contains(TAG_START_INTERPOLATION, 99)) {
            int j = p_270854_.getInt(TAG_START_INTERPOLATION);
            this.setInterpolationDelay(j);
        }
        if (p_270854_.contains(TAG_BILLBOARD, 8)) {
            BillboardConstraints.CODEC.decode((DynamicOps)NbtOps.INSTANCE, (Object)p_270854_.get(TAG_BILLBOARD)).resultOrPartial(Util.prefix("Display entity", arg_0 -> ((Logger)LOGGER).error(arg_0))).ifPresent(p_270691_ -> this.setBillboardConstraints((BillboardConstraints)p_270691_.getFirst()));
        }
        if (p_270854_.contains(TAG_VIEW_RANGE, 99)) {
            this.setViewRange(p_270854_.getFloat(TAG_VIEW_RANGE));
        }
        if (p_270854_.contains(TAG_SHADOW_RADIUS, 99)) {
            this.setShadowRadius(p_270854_.getFloat(TAG_SHADOW_RADIUS));
        }
        if (p_270854_.contains(TAG_SHADOW_STRENGTH, 99)) {
            this.setShadowStrength(p_270854_.getFloat(TAG_SHADOW_STRENGTH));
        }
        if (p_270854_.contains(TAG_WIDTH, 99)) {
            this.setWidth(p_270854_.getFloat(TAG_WIDTH));
        }
        if (p_270854_.contains(TAG_HEIGHT, 99)) {
            this.setHeight(p_270854_.getFloat(TAG_HEIGHT));
        }
        if (p_270854_.contains(TAG_GLOW_COLOR_OVERRIDE, 99)) {
            this.setGlowColorOverride(p_270854_.getInt(TAG_GLOW_COLOR_OVERRIDE));
        }
        if (p_270854_.contains(TAG_BRIGHTNESS, 10)) {
            Brightness.CODEC.decode((DynamicOps)NbtOps.INSTANCE, (Object)p_270854_.get(TAG_BRIGHTNESS)).resultOrPartial(Util.prefix("Display entity", arg_0 -> ((Logger)LOGGER).error(arg_0))).ifPresent(p_270247_ -> this.setBrightnessOverride((Brightness)p_270247_.getFirst()));
        } else {
            this.setBrightnessOverride(null);
        }
    }

    private void setTransformation(Transformation p_270186_) {
        this.entityData.set(DATA_TRANSLATION_ID, p_270186_.getTranslation());
        this.entityData.set(DATA_LEFT_ROTATION_ID, p_270186_.getLeftRotation());
        this.entityData.set(DATA_SCALE_ID, p_270186_.getScale());
        this.entityData.set(DATA_RIGHT_ROTATION_ID, p_270186_.getRightRotation());
    }

    @Override
    protected void addAdditionalSaveData(CompoundTag p_270779_) {
        Transformation.EXTENDED_CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)Display.createTransformation(this.entityData)).result().ifPresent(p_270528_ -> p_270779_.put(TAG_TRANSFORMATION, (Tag)p_270528_));
        BillboardConstraints.CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)this.getBillboardConstraints()).result().ifPresent(p_270227_ -> p_270779_.put(TAG_BILLBOARD, (Tag)p_270227_));
        p_270779_.putInt(TAG_INTERPOLATION_DURATION, this.getInterpolationDuration());
        p_270779_.putFloat(TAG_VIEW_RANGE, this.getViewRange());
        p_270779_.putFloat(TAG_SHADOW_RADIUS, this.getShadowRadius());
        p_270779_.putFloat(TAG_SHADOW_STRENGTH, this.getShadowStrength());
        p_270779_.putFloat(TAG_WIDTH, this.getWidth());
        p_270779_.putFloat(TAG_HEIGHT, this.getHeight());
        p_270779_.putInt(TAG_GLOW_COLOR_OVERRIDE, this.getGlowColorOverride());
        Brightness brightness = this.getBrightnessOverride();
        if (brightness != null) {
            Brightness.CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)brightness).result().ifPresent(p_270121_ -> p_270779_.put(TAG_BRIGHTNESS, (Tag)p_270121_));
        }
    }

    @Override
    public Packet<ClientGamePacketListener> getAddEntityPacket() {
        return new ClientboundAddEntityPacket(this);
    }

    @Override
    public AABB getBoundingBoxForCulling() {
        return this.cullingBoundingBox;
    }

    @Override
    public PushReaction getPistonPushReaction() {
        return PushReaction.IGNORE;
    }

    @Override
    public boolean isIgnoringBlockTriggers() {
        return true;
    }

    public Quaternionf orientation() {
        return this.orientation;
    }

    @Nullable
    public RenderState renderState() {
        return this.renderState;
    }

    private void setInterpolationDuration(int p_270803_) {
        this.entityData.set(DATA_INTERPOLATION_DURATION_ID, p_270803_);
    }

    private int getInterpolationDuration() {
        return this.entityData.get(DATA_INTERPOLATION_DURATION_ID);
    }

    private void setInterpolationDelay(int p_276366_) {
        this.entityData.set(DATA_INTERPOLATION_START_DELTA_TICKS_ID, p_276366_, true);
    }

    private int getInterpolationDelay() {
        return this.entityData.get(DATA_INTERPOLATION_START_DELTA_TICKS_ID);
    }

    private void setBillboardConstraints(BillboardConstraints p_270345_) {
        this.entityData.set(DATA_BILLBOARD_RENDER_CONSTRAINTS_ID, p_270345_.getId());
    }

    private BillboardConstraints getBillboardConstraints() {
        return BillboardConstraints.BY_ID.apply(this.entityData.get(DATA_BILLBOARD_RENDER_CONSTRAINTS_ID).byteValue());
    }

    private void setBrightnessOverride(@Nullable Brightness p_270461_) {
        this.entityData.set(DATA_BRIGHTNESS_OVERRIDE_ID, p_270461_ != null ? p_270461_.pack() : -1);
    }

    @Nullable
    private Brightness getBrightnessOverride() {
        int i = this.entityData.get(DATA_BRIGHTNESS_OVERRIDE_ID);
        return i != -1 ? Brightness.unpack(i) : null;
    }

    private int getPackedBrightnessOverride() {
        return this.entityData.get(DATA_BRIGHTNESS_OVERRIDE_ID);
    }

    private void setViewRange(float p_270907_) {
        this.entityData.set(DATA_VIEW_RANGE_ID, Float.valueOf(p_270907_));
    }

    private float getViewRange() {
        return this.entityData.get(DATA_VIEW_RANGE_ID).floatValue();
    }

    private void setShadowRadius(float p_270122_) {
        this.entityData.set(DATA_SHADOW_RADIUS_ID, Float.valueOf(p_270122_));
    }

    private float getShadowRadius() {
        return this.entityData.get(DATA_SHADOW_RADIUS_ID).floatValue();
    }

    private void setShadowStrength(float p_270866_) {
        this.entityData.set(DATA_SHADOW_STRENGTH_ID, Float.valueOf(p_270866_));
    }

    private float getShadowStrength() {
        return this.entityData.get(DATA_SHADOW_STRENGTH_ID).floatValue();
    }

    private void setWidth(float p_270741_) {
        this.entityData.set(DATA_WIDTH_ID, Float.valueOf(p_270741_));
    }

    private float getWidth() {
        return this.entityData.get(DATA_WIDTH_ID).floatValue();
    }

    private void setHeight(float p_270716_) {
        this.entityData.set(DATA_HEIGHT_ID, Float.valueOf(p_270716_));
    }

    private int getGlowColorOverride() {
        return this.entityData.get(DATA_GLOW_COLOR_OVERRIDE_ID);
    }

    private void setGlowColorOverride(int p_270784_) {
        this.entityData.set(DATA_GLOW_COLOR_OVERRIDE_ID, p_270784_);
    }

    public float calculateInterpolationProgress(float p_272675_) {
        float f2;
        int i = this.interpolationDuration;
        if (i <= 0) {
            return 1.0f;
        }
        float f = (long)this.tickCount - this.interpolationStartClientTick;
        float f1 = f + p_272675_;
        this.lastProgress = f2 = Mth.clamp(Mth.inverseLerp(f1, 0.0f, i), 0.0f, 1.0f);
        return f2;
    }

    private float getHeight() {
        return this.entityData.get(DATA_HEIGHT_ID).floatValue();
    }

    @Override
    public void setPos(double p_270091_, double p_270983_, double p_270419_) {
        super.setPos(p_270091_, p_270983_, p_270419_);
        this.updateCulling();
    }

    private void updateCulling() {
        float f = this.getWidth();
        float f1 = this.getHeight();
        if (f != 0.0f && f1 != 0.0f) {
            this.noCulling = false;
            float f2 = f / 2.0f;
            double d0 = this.getX();
            double d1 = this.getY();
            double d2 = this.getZ();
            this.cullingBoundingBox = new AABB(d0 - (double)f2, d1, d2 - (double)f2, d0 + (double)f2, d1 + (double)f1, d2 + (double)f2);
        } else {
            this.noCulling = true;
        }
    }

    @Override
    public void setXRot(float p_270257_) {
        super.setXRot(p_270257_);
        this.updateOrientation();
    }

    @Override
    public void setYRot(float p_270921_) {
        super.setYRot(p_270921_);
        this.updateOrientation();
    }

    private void updateOrientation() {
        this.orientation.rotationYXZ((float)(-Math.PI) / 180 * this.getYRot(), (float)Math.PI / 180 * this.getXRot(), 0.0f);
    }

    @Override
    public boolean shouldRenderAtSqrDistance(double p_270991_) {
        return p_270991_ < Mth.square((double)this.getViewRange() * 64.0 * Display.getViewScale());
    }

    @Override
    public int getTeamColor() {
        int i = this.getGlowColorOverride();
        return i != -1 ? i : super.getTeamColor();
    }

    private RenderState createFreshRenderState() {
        return new RenderState(GenericInterpolator.constant(Display.createTransformation(this.entityData)), this.getBillboardConstraints(), this.getPackedBrightnessOverride(), FloatInterpolator.constant(this.getShadowRadius()), FloatInterpolator.constant(this.getShadowStrength()), this.getGlowColorOverride());
    }

    private RenderState createInterpolatedRenderState(RenderState p_277365_, float p_277948_) {
        Transformation transformation = p_277365_.transformation.get(p_277948_);
        float f = p_277365_.shadowRadius.get(p_277948_);
        float f1 = p_277365_.shadowStrength.get(p_277948_);
        return new RenderState(new TransformationInterpolator(transformation, Display.createTransformation(this.entityData)), this.getBillboardConstraints(), this.getPackedBrightnessOverride(), new LinearFloatInterpolator(f, this.getShadowRadius()), new LinearFloatInterpolator(f1, this.getShadowStrength()), this.getGlowColorOverride());
    }

    public record RenderState(GenericInterpolator<Transformation> transformation, BillboardConstraints billboardConstraints, int brightnessOverride, FloatInterpolator shadowRadius, FloatInterpolator shadowStrength, int glowColorOverride) {
    }

    public static enum BillboardConstraints implements StringRepresentable
    {
        FIXED(0, "fixed"),
        VERTICAL(1, "vertical"),
        HORIZONTAL(2, "horizontal"),
        CENTER(3, "center");

        public static final Codec<BillboardConstraints> CODEC;
        public static final IntFunction<BillboardConstraints> BY_ID;
        private final byte id;
        private final String name;

        private BillboardConstraints(byte p_270785_, String p_270544_) {
            this.name = p_270544_;
            this.id = p_270785_;
        }

        @Override
        public String getSerializedName() {
            return this.name;
        }

        byte getId() {
            return this.id;
        }

        static {
            CODEC = StringRepresentable.fromEnum(BillboardConstraints::values);
            BY_ID = ByIdMap.continuous(BillboardConstraints::getId, BillboardConstraints.values(), ByIdMap.OutOfBoundsStrategy.ZERO);
        }
    }

    @FunctionalInterface
    public static interface GenericInterpolator<T> {
        public static <T> GenericInterpolator<T> constant(T p_277718_) {
            return p_277907_ -> p_277718_;
        }

        public T get(float var1);
    }

    @FunctionalInterface
    public static interface FloatInterpolator {
        public static FloatInterpolator constant(float p_277894_) {
            return p_278040_ -> p_277894_;
        }

        public float get(float var1);
    }

    record TransformationInterpolator(Transformation previous, Transformation current) implements GenericInterpolator<Transformation>
    {
        @Override
        public Transformation get(float p_278027_) {
            return (double)p_278027_ >= 1.0 ? this.current : this.previous.slerp(this.current, p_278027_);
        }
    }

    record LinearFloatInterpolator(float previous, float current) implements FloatInterpolator
    {
        @Override
        public float get(float p_277511_) {
            return Mth.lerp(p_277511_, this.previous, this.current);
        }
    }

    public static class TextDisplay
    extends Display {
        public static final String TAG_TEXT = "text";
        private static final String TAG_LINE_WIDTH = "line_width";
        private static final String TAG_TEXT_OPACITY = "text_opacity";
        private static final String TAG_BACKGROUND_COLOR = "background";
        private static final String TAG_SHADOW = "shadow";
        private static final String TAG_SEE_THROUGH = "see_through";
        private static final String TAG_USE_DEFAULT_BACKGROUND = "default_background";
        private static final String TAG_ALIGNMENT = "alignment";
        public static final byte FLAG_SHADOW = 1;
        public static final byte FLAG_SEE_THROUGH = 2;
        public static final byte FLAG_USE_DEFAULT_BACKGROUND = 4;
        public static final byte FLAG_ALIGN_LEFT = 8;
        public static final byte FLAG_ALIGN_RIGHT = 16;
        private static final byte INITIAL_TEXT_OPACITY = -1;
        public static final int INITIAL_BACKGROUND = 0x40000000;
        private static final EntityDataAccessor<Component> DATA_TEXT_ID = SynchedEntityData.defineId(TextDisplay.class, EntityDataSerializers.COMPONENT);
        private static final EntityDataAccessor<Integer> DATA_LINE_WIDTH_ID = SynchedEntityData.defineId(TextDisplay.class, EntityDataSerializers.INT);
        private static final EntityDataAccessor<Integer> DATA_BACKGROUND_COLOR_ID = SynchedEntityData.defineId(TextDisplay.class, EntityDataSerializers.INT);
        private static final EntityDataAccessor<Byte> DATA_TEXT_OPACITY_ID = SynchedEntityData.defineId(TextDisplay.class, EntityDataSerializers.BYTE);
        private static final EntityDataAccessor<Byte> DATA_STYLE_FLAGS_ID = SynchedEntityData.defineId(TextDisplay.class, EntityDataSerializers.BYTE);
        private static final IntSet TEXT_RENDER_STATE_IDS = IntSet.of((int[])new int[]{DATA_TEXT_ID.getId(), DATA_LINE_WIDTH_ID.getId(), DATA_BACKGROUND_COLOR_ID.getId(), DATA_TEXT_OPACITY_ID.getId(), DATA_STYLE_FLAGS_ID.getId()});
        @Nullable
        private CachedInfo clientDisplayCache;
        @Nullable
        private TextRenderState textRenderState;

        public TextDisplay(EntityType<?> p_270708_, Level p_270736_) {
            super(p_270708_, p_270736_);
        }

        @Override
        protected void defineSynchedData() {
            super.defineSynchedData();
            this.entityData.define(DATA_TEXT_ID, Component.empty());
            this.entityData.define(DATA_LINE_WIDTH_ID, 200);
            this.entityData.define(DATA_BACKGROUND_COLOR_ID, 0x40000000);
            this.entityData.define(DATA_TEXT_OPACITY_ID, (byte)-1);
            this.entityData.define(DATA_STYLE_FLAGS_ID, (byte)0);
        }

        @Override
        public void onSyncedDataUpdated(EntityDataAccessor<?> p_270797_) {
            super.onSyncedDataUpdated(p_270797_);
            if (TEXT_RENDER_STATE_IDS.contains(p_270797_.getId())) {
                this.updateRenderState = true;
            }
        }

        private Component getText() {
            return this.entityData.get(DATA_TEXT_ID);
        }

        private void setText(Component p_270902_) {
            this.entityData.set(DATA_TEXT_ID, p_270902_);
        }

        private int getLineWidth() {
            return this.entityData.get(DATA_LINE_WIDTH_ID);
        }

        private void setLineWidth(int p_270545_) {
            this.entityData.set(DATA_LINE_WIDTH_ID, p_270545_);
        }

        private byte getTextOpacity() {
            return this.entityData.get(DATA_TEXT_OPACITY_ID);
        }

        private void setTextOpacity(byte p_270583_) {
            this.entityData.set(DATA_TEXT_OPACITY_ID, p_270583_);
        }

        private int getBackgroundColor() {
            return this.entityData.get(DATA_BACKGROUND_COLOR_ID);
        }

        private void setBackgroundColor(int p_270241_) {
            this.entityData.set(DATA_BACKGROUND_COLOR_ID, p_270241_);
        }

        private byte getFlags() {
            return this.entityData.get(DATA_STYLE_FLAGS_ID);
        }

        private void setFlags(byte p_270855_) {
            this.entityData.set(DATA_STYLE_FLAGS_ID, p_270855_);
        }

        private static byte loadFlag(byte p_270219_, CompoundTag p_270994_, String p_270958_, byte p_270701_) {
            return p_270994_.getBoolean(p_270958_) ? (byte)(p_270219_ | p_270701_) : p_270219_;
        }

        @Override
        protected void readAdditionalSaveData(CompoundTag p_270714_) {
            super.readAdditionalSaveData(p_270714_);
            if (p_270714_.contains(TAG_LINE_WIDTH, 99)) {
                this.setLineWidth(p_270714_.getInt(TAG_LINE_WIDTH));
            }
            if (p_270714_.contains(TAG_TEXT_OPACITY, 99)) {
                this.setTextOpacity(p_270714_.getByte(TAG_TEXT_OPACITY));
            }
            if (p_270714_.contains(TAG_BACKGROUND_COLOR, 99)) {
                this.setBackgroundColor(p_270714_.getInt(TAG_BACKGROUND_COLOR));
            }
            byte b0 = TextDisplay.loadFlag((byte)0, p_270714_, TAG_SHADOW, (byte)1);
            b0 = TextDisplay.loadFlag(b0, p_270714_, TAG_SEE_THROUGH, (byte)2);
            b0 = TextDisplay.loadFlag(b0, p_270714_, TAG_USE_DEFAULT_BACKGROUND, (byte)4);
            Optional<Align> optional = Align.CODEC.decode((DynamicOps)NbtOps.INSTANCE, (Object)p_270714_.get(TAG_ALIGNMENT)).resultOrPartial(Util.prefix("Display entity", arg_0 -> ((Logger)LOGGER).error(arg_0))).map(Pair::getFirst);
            if (optional.isPresent()) {
                b0 = switch (optional.get()) {
                    case Align.CENTER -> b0;
                    case Align.LEFT -> (byte)(b0 | 8);
                    case Align.RIGHT -> (byte)(b0 | 0x10);
                    default -> throw new IncompatibleClassChangeError();
                };
            }
            this.setFlags(b0);
            if (p_270714_.contains(TAG_TEXT, 8)) {
                String s = p_270714_.getString(TAG_TEXT);
                try {
                    MutableComponent component = Component.Serializer.fromJson(s);
                    if (component != null) {
                        CommandSourceStack commandsourcestack = this.createCommandSourceStack().withPermission(2);
                        MutableComponent component1 = ComponentUtils.updateForEntity(commandsourcestack, component, (Entity)this, 0);
                        this.setText(component1);
                    } else {
                        this.setText(Component.empty());
                    }
                }
                catch (Exception exception) {
                    LOGGER.warn("Failed to parse display entity text {}", (Object)s, (Object)exception);
                }
            }
        }

        private static void storeFlag(byte p_270879_, CompoundTag p_270177_, String p_270294_, byte p_270853_) {
            p_270177_.putBoolean(p_270294_, (p_270879_ & p_270853_) != 0);
        }

        @Override
        protected void addAdditionalSaveData(CompoundTag p_270268_) {
            super.addAdditionalSaveData(p_270268_);
            p_270268_.putString(TAG_TEXT, Component.Serializer.toJson(this.getText()));
            p_270268_.putInt(TAG_LINE_WIDTH, this.getLineWidth());
            p_270268_.putInt(TAG_BACKGROUND_COLOR, this.getBackgroundColor());
            p_270268_.putByte(TAG_TEXT_OPACITY, this.getTextOpacity());
            byte b0 = this.getFlags();
            TextDisplay.storeFlag(b0, p_270268_, TAG_SHADOW, (byte)1);
            TextDisplay.storeFlag(b0, p_270268_, TAG_SEE_THROUGH, (byte)2);
            TextDisplay.storeFlag(b0, p_270268_, TAG_USE_DEFAULT_BACKGROUND, (byte)4);
            Align.CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)TextDisplay.getAlign(b0)).result().ifPresent(p_271001_ -> p_270268_.put(TAG_ALIGNMENT, (Tag)p_271001_));
        }

        @Override
        protected void updateRenderSubState(boolean p_277565_, float p_277967_) {
            this.textRenderState = p_277565_ && this.textRenderState != null ? this.createInterpolatedTextRenderState(this.textRenderState, p_277967_) : this.createFreshTextRenderState();
            this.clientDisplayCache = null;
        }

        @Nullable
        public TextRenderState textRenderState() {
            return this.textRenderState;
        }

        private TextRenderState createFreshTextRenderState() {
            return new TextRenderState(this.getText(), this.getLineWidth(), IntInterpolator.constant(this.getTextOpacity()), IntInterpolator.constant(this.getBackgroundColor()), this.getFlags());
        }

        private TextRenderState createInterpolatedTextRenderState(TextRenderState p_278000_, float p_277646_) {
            int i = p_278000_.backgroundColor.get(p_277646_);
            int j = p_278000_.textOpacity.get(p_277646_);
            return new TextRenderState(this.getText(), this.getLineWidth(), new LinearIntInterpolator(j, this.getTextOpacity()), new ColorInterpolator(i, this.getBackgroundColor()), this.getFlags());
        }

        public CachedInfo cacheDisplay(LineSplitter p_270682_) {
            if (this.clientDisplayCache == null) {
                this.clientDisplayCache = this.textRenderState != null ? p_270682_.split(this.textRenderState.text(), this.textRenderState.lineWidth()) : new CachedInfo(List.of(), 0);
            }
            return this.clientDisplayCache;
        }

        public static Align getAlign(byte p_270911_) {
            if ((p_270911_ & 8) != 0) {
                return Align.LEFT;
            }
            return (p_270911_ & 0x10) != 0 ? Align.RIGHT : Align.CENTER;
        }

        public static enum Align implements StringRepresentable
        {
            CENTER("center"),
            LEFT("left"),
            RIGHT("right");

            public static final Codec<Align> CODEC;
            private final String name;

            private Align(String p_270554_) {
                this.name = p_270554_;
            }

            @Override
            public String getSerializedName() {
                return this.name;
            }

            static {
                CODEC = StringRepresentable.fromEnum(Align::values);
            }
        }

        public record TextRenderState(Component text, int lineWidth, IntInterpolator textOpacity, IntInterpolator backgroundColor, byte flags) {
        }

        public record CachedInfo(List<CachedLine> lines, int width) {
        }

        @FunctionalInterface
        public static interface LineSplitter {
            public CachedInfo split(Component var1, int var2);
        }

        public record CachedLine(FormattedCharSequence contents, int width) {
        }
    }

    record LinearIntInterpolator(int previous, int current) implements IntInterpolator
    {
        @Override
        public int get(float p_277960_) {
            return Mth.lerpInt(p_277960_, this.previous, this.current);
        }
    }

    public static class ItemDisplay
    extends Display {
        private static final String TAG_ITEM = "item";
        private static final String TAG_ITEM_DISPLAY = "item_display";
        private static final EntityDataAccessor<ItemStack> DATA_ITEM_STACK_ID = SynchedEntityData.defineId(ItemDisplay.class, EntityDataSerializers.ITEM_STACK);
        private static final EntityDataAccessor<Byte> DATA_ITEM_DISPLAY_ID = SynchedEntityData.defineId(ItemDisplay.class, EntityDataSerializers.BYTE);
        private final SlotAccess slot = new SlotAccess(){

            @Override
            public ItemStack get() {
                return this.getItemStack();
            }

            @Override
            public boolean set(ItemStack p_270697_) {
                this.setItemStack(p_270697_);
                return true;
            }
        };
        @Nullable
        private ItemRenderState itemRenderState;

        public ItemDisplay(EntityType<?> p_270104_, Level p_270735_) {
            super(p_270104_, p_270735_);
        }

        @Override
        protected void defineSynchedData() {
            super.defineSynchedData();
            this.entityData.define(DATA_ITEM_STACK_ID, ItemStack.EMPTY);
            this.entityData.define(DATA_ITEM_DISPLAY_ID, ItemDisplayContext.NONE.getId());
        }

        @Override
        public void onSyncedDataUpdated(EntityDataAccessor<?> p_277793_) {
            super.onSyncedDataUpdated(p_277793_);
            if (DATA_ITEM_STACK_ID.equals(p_277793_) || DATA_ITEM_DISPLAY_ID.equals(p_277793_)) {
                this.updateRenderState = true;
            }
        }

        ItemStack getItemStack() {
            return this.entityData.get(DATA_ITEM_STACK_ID);
        }

        void setItemStack(ItemStack p_270310_) {
            this.entityData.set(DATA_ITEM_STACK_ID, p_270310_);
        }

        private void setItemTransform(ItemDisplayContext p_270370_) {
            this.entityData.set(DATA_ITEM_DISPLAY_ID, p_270370_.getId());
        }

        private ItemDisplayContext getItemTransform() {
            return ItemDisplayContext.BY_ID.apply(this.entityData.get(DATA_ITEM_DISPLAY_ID).byteValue());
        }

        @Override
        protected void readAdditionalSaveData(CompoundTag p_270713_) {
            super.readAdditionalSaveData(p_270713_);
            this.setItemStack(ItemStack.of(p_270713_.getCompound(TAG_ITEM)));
            if (p_270713_.contains(TAG_ITEM_DISPLAY, 8)) {
                ItemDisplayContext.CODEC.decode((DynamicOps)NbtOps.INSTANCE, (Object)p_270713_.get(TAG_ITEM_DISPLAY)).resultOrPartial(Util.prefix("Display entity", arg_0 -> ((Logger)LOGGER).error(arg_0))).ifPresent(p_270456_ -> this.setItemTransform((ItemDisplayContext)p_270456_.getFirst()));
            }
        }

        @Override
        protected void addAdditionalSaveData(CompoundTag p_270669_) {
            super.addAdditionalSaveData(p_270669_);
            p_270669_.put(TAG_ITEM, this.getItemStack().save(new CompoundTag()));
            ItemDisplayContext.CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)this.getItemTransform()).result().ifPresent(p_270615_ -> p_270669_.put(TAG_ITEM_DISPLAY, (Tag)p_270615_));
        }

        @Override
        public SlotAccess getSlot(int p_270599_) {
            return p_270599_ == 0 ? this.slot : SlotAccess.NULL;
        }

        @Nullable
        public ItemRenderState itemRenderState() {
            return this.itemRenderState;
        }

        @Override
        protected void updateRenderSubState(boolean p_277976_, float p_277708_) {
            this.itemRenderState = new ItemRenderState(this.getItemStack(), this.getItemTransform());
        }

        public record ItemRenderState(ItemStack itemStack, ItemDisplayContext itemTransform) {
        }
    }

    @FunctionalInterface
    public static interface IntInterpolator {
        public static IntInterpolator constant(int p_277348_) {
            return p_277356_ -> p_277348_;
        }

        public int get(float var1);
    }

    record ColorInterpolator(int previous, int current) implements IntInterpolator
    {
        @Override
        public int get(float p_278012_) {
            return FastColor.ARGB32.lerp(p_278012_, this.previous, this.current);
        }
    }

    public static class BlockDisplay
    extends Display {
        public static final String TAG_BLOCK_STATE = "block_state";
        private static final EntityDataAccessor<BlockState> DATA_BLOCK_STATE_ID = SynchedEntityData.defineId(BlockDisplay.class, EntityDataSerializers.BLOCK_STATE);
        @Nullable
        private BlockRenderState blockRenderState;

        public BlockDisplay(EntityType<?> p_271022_, Level p_270442_) {
            super(p_271022_, p_270442_);
        }

        @Override
        protected void defineSynchedData() {
            super.defineSynchedData();
            this.entityData.define(DATA_BLOCK_STATE_ID, Blocks.AIR.defaultBlockState());
        }

        @Override
        public void onSyncedDataUpdated(EntityDataAccessor<?> p_277476_) {
            super.onSyncedDataUpdated(p_277476_);
            if (p_277476_.equals(DATA_BLOCK_STATE_ID)) {
                this.updateRenderState = true;
            }
        }

        private BlockState getBlockState() {
            return this.entityData.get(DATA_BLOCK_STATE_ID);
        }

        private void setBlockState(BlockState p_270267_) {
            this.entityData.set(DATA_BLOCK_STATE_ID, p_270267_);
        }

        @Override
        protected void readAdditionalSaveData(CompoundTag p_270139_) {
            super.readAdditionalSaveData(p_270139_);
            this.setBlockState(NbtUtils.readBlockState(this.level().holderLookup(Registries.BLOCK), p_270139_.getCompound(TAG_BLOCK_STATE)));
        }

        @Override
        protected void addAdditionalSaveData(CompoundTag p_270469_) {
            super.addAdditionalSaveData(p_270469_);
            p_270469_.put(TAG_BLOCK_STATE, NbtUtils.writeBlockState(this.getBlockState()));
        }

        @Nullable
        public BlockRenderState blockRenderState() {
            return this.blockRenderState;
        }

        @Override
        protected void updateRenderSubState(boolean p_277802_, float p_277688_) {
            this.blockRenderState = new BlockRenderState(this.getBlockState());
        }

        public record BlockRenderState(BlockState blockState) {
        }
    }
}

