/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.effect;

import com.google.common.collect.ComparisonChain;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.ints.Int2IntFunction;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.extensions.IForgeMobEffectInstance;
import net.minecraftforge.registries.ForgeRegistries;
import org.slf4j.Logger;

public class MobEffectInstance
implements Comparable<MobEffectInstance>,
IForgeMobEffectInstance {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final int INFINITE_DURATION = -1;
    private final MobEffect effect;
    private int duration;
    private int amplifier;
    private boolean ambient;
    private boolean visible;
    private boolean showIcon;
    @Nullable
    private MobEffectInstance hiddenEffect;
    private final Optional<FactorData> factorData;
    private List<ItemStack> curativeItems;

    public MobEffectInstance(MobEffect p_19513_) {
        this(p_19513_, 0, 0);
    }

    public MobEffectInstance(MobEffect p_19515_, int p_19516_) {
        this(p_19515_, p_19516_, 0);
    }

    public MobEffectInstance(MobEffect p_19518_, int p_19519_, int p_19520_) {
        this(p_19518_, p_19519_, p_19520_, false, true);
    }

    public MobEffectInstance(MobEffect p_19522_, int p_19523_, int p_19524_, boolean p_19525_, boolean p_19526_) {
        this(p_19522_, p_19523_, p_19524_, p_19525_, p_19526_, p_19526_);
    }

    public MobEffectInstance(MobEffect p_19528_, int p_19529_, int p_19530_, boolean p_19531_, boolean p_19532_, boolean p_19533_) {
        this(p_19528_, p_19529_, p_19530_, p_19531_, p_19532_, p_19533_, null, p_19528_.createFactorData());
    }

    public MobEffectInstance(MobEffect p_216887_, int p_216888_, int p_216889_, boolean p_216890_, boolean p_216891_, boolean p_216892_, @Nullable MobEffectInstance p_216893_, Optional<FactorData> p_216894_) {
        this.effect = p_216887_;
        this.duration = p_216888_;
        this.amplifier = p_216889_;
        this.ambient = p_216890_;
        this.visible = p_216891_;
        this.showIcon = p_216892_;
        this.hiddenEffect = p_216893_;
        this.factorData = p_216894_;
    }

    public MobEffectInstance(MobEffectInstance p_19543_) {
        this.effect = p_19543_.effect;
        this.factorData = this.effect.createFactorData();
        this.setDetailsFrom(p_19543_);
    }

    public Optional<FactorData> getFactorData() {
        return this.factorData;
    }

    void setDetailsFrom(MobEffectInstance p_19549_) {
        this.duration = p_19549_.duration;
        this.amplifier = p_19549_.amplifier;
        this.ambient = p_19549_.ambient;
        this.visible = p_19549_.visible;
        this.showIcon = p_19549_.showIcon;
        this.curativeItems = p_19549_.curativeItems == null ? null : new ArrayList<ItemStack>(p_19549_.curativeItems);
    }

    public boolean update(MobEffectInstance p_19559_) {
        if (this.effect != p_19559_.effect) {
            LOGGER.warn("This method should only be called for matching effects!");
        }
        int i = this.duration;
        boolean flag = false;
        if (p_19559_.amplifier > this.amplifier) {
            if (p_19559_.isShorterDurationThan(this)) {
                MobEffectInstance mobeffectinstance = this.hiddenEffect;
                this.hiddenEffect = new MobEffectInstance(this);
                this.hiddenEffect.hiddenEffect = mobeffectinstance;
            }
            this.amplifier = p_19559_.amplifier;
            this.duration = p_19559_.duration;
            flag = true;
        } else if (this.isShorterDurationThan(p_19559_)) {
            if (p_19559_.amplifier == this.amplifier) {
                this.duration = p_19559_.duration;
                flag = true;
            } else if (this.hiddenEffect == null) {
                this.hiddenEffect = new MobEffectInstance(p_19559_);
            } else {
                this.hiddenEffect.update(p_19559_);
            }
        }
        if (!p_19559_.ambient && this.ambient || flag) {
            this.ambient = p_19559_.ambient;
            flag = true;
        }
        if (p_19559_.visible != this.visible) {
            this.visible = p_19559_.visible;
            flag = true;
        }
        if (p_19559_.showIcon != this.showIcon) {
            this.showIcon = p_19559_.showIcon;
            flag = true;
        }
        return flag;
    }

    private boolean isShorterDurationThan(MobEffectInstance p_268133_) {
        return !this.isInfiniteDuration() && (this.duration < p_268133_.duration || p_268133_.isInfiniteDuration());
    }

    public boolean isInfiniteDuration() {
        return this.duration == -1;
    }

    public boolean endsWithin(int p_268088_) {
        return !this.isInfiniteDuration() && this.duration <= p_268088_;
    }

    public int mapDuration(Int2IntFunction p_268089_) {
        return !this.isInfiniteDuration() && this.duration != 0 ? p_268089_.applyAsInt(this.duration) : this.duration;
    }

    public MobEffect getEffect() {
        return this.effect == null ? null : (MobEffect)ForgeRegistries.MOB_EFFECTS.getDelegateOrThrow(this.effect).get();
    }

    public int getDuration() {
        return this.duration;
    }

    public int getAmplifier() {
        return this.amplifier;
    }

    public boolean isAmbient() {
        return this.ambient;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public boolean showIcon() {
        return this.showIcon;
    }

    public boolean tick(LivingEntity p_19553_, Runnable p_19554_) {
        if (this.hasRemainingDuration()) {
            int i;
            int n = i = this.isInfiniteDuration() ? p_19553_.tickCount : this.duration;
            if (this.effect.isDurationEffectTick(i, this.amplifier)) {
                this.applyEffect(p_19553_);
            }
            this.tickDownDuration();
            if (this.duration == 0 && this.hiddenEffect != null) {
                this.setDetailsFrom(this.hiddenEffect);
                this.hiddenEffect = this.hiddenEffect.hiddenEffect;
                p_19554_.run();
            }
        }
        this.factorData.ifPresent(p_267917_ -> p_267917_.tick(this));
        return this.hasRemainingDuration();
    }

    private boolean hasRemainingDuration() {
        return this.isInfiniteDuration() || this.duration > 0;
    }

    private int tickDownDuration() {
        if (this.hiddenEffect != null) {
            this.hiddenEffect.tickDownDuration();
        }
        this.duration = this.mapDuration(p_267916_ -> p_267916_ - 1);
        return this.duration;
    }

    public void applyEffect(LivingEntity p_19551_) {
        if (this.hasRemainingDuration()) {
            this.effect.applyEffectTick(p_19551_, this.amplifier);
        }
    }

    public String getDescriptionId() {
        return this.effect.getDescriptionId();
    }

    public String toString() {
        String s = this.amplifier > 0 ? this.getDescriptionId() + " x " + (this.amplifier + 1) + ", Duration: " + this.describeDuration() : this.getDescriptionId() + ", Duration: " + this.describeDuration();
        if (!this.visible) {
            s = s + ", Particles: false";
        }
        if (!this.showIcon) {
            s = s + ", Show Icon: false";
        }
        return s;
    }

    private String describeDuration() {
        return this.isInfiniteDuration() ? "infinite" : Integer.toString(this.duration);
    }

    public boolean equals(Object p_19574_) {
        if (this == p_19574_) {
            return true;
        }
        if (!(p_19574_ instanceof MobEffectInstance)) {
            return false;
        }
        MobEffectInstance mobeffectinstance = (MobEffectInstance)p_19574_;
        return this.duration == mobeffectinstance.duration && this.amplifier == mobeffectinstance.amplifier && this.ambient == mobeffectinstance.ambient && this.effect.equals(mobeffectinstance.effect);
    }

    public int hashCode() {
        int i = this.effect.hashCode();
        i = 31 * i + this.duration;
        i = 31 * i + this.amplifier;
        return 31 * i + (this.ambient ? 1 : 0);
    }

    public CompoundTag save(CompoundTag p_19556_) {
        p_19556_.putInt("Id", MobEffect.getId(this.getEffect()));
        ForgeHooks.saveMobEffect(p_19556_, "forge:id", this.getEffect());
        this.writeDetailsTo(p_19556_);
        return p_19556_;
    }

    private void writeDetailsTo(CompoundTag p_19568_) {
        p_19568_.putByte("Amplifier", (byte)this.getAmplifier());
        p_19568_.putInt("Duration", this.getDuration());
        p_19568_.putBoolean("Ambient", this.isAmbient());
        p_19568_.putBoolean("ShowParticles", this.isVisible());
        p_19568_.putBoolean("ShowIcon", this.showIcon());
        if (this.hiddenEffect != null) {
            CompoundTag compoundtag = new CompoundTag();
            this.hiddenEffect.save(compoundtag);
            p_19568_.put("HiddenEffect", compoundtag);
        }
        this.writeCurativeItems(p_19568_);
        this.factorData.ifPresent(p_216903_ -> FactorData.CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, p_216903_).resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0)).ifPresent(p_216906_ -> p_19568_.put("FactorCalculationData", (Tag)p_216906_)));
    }

    @Nullable
    public static MobEffectInstance load(CompoundTag p_19561_) {
        int i = p_19561_.getByte("Id") & 0xFF;
        MobEffect mobeffect = MobEffect.byId(i);
        return (mobeffect = ForgeHooks.loadMobEffect(p_19561_, "forge:id", mobeffect)) == null ? null : MobEffectInstance.loadSpecifiedEffect(mobeffect, p_19561_);
    }

    private static MobEffectInstance loadSpecifiedEffect(MobEffect p_19546_, CompoundTag p_19547_) {
        byte i = p_19547_.getByte("Amplifier");
        int j = p_19547_.getInt("Duration");
        boolean flag = p_19547_.getBoolean("Ambient");
        boolean flag1 = true;
        if (p_19547_.contains("ShowParticles", 1)) {
            flag1 = p_19547_.getBoolean("ShowParticles");
        }
        boolean flag2 = flag1;
        if (p_19547_.contains("ShowIcon", 1)) {
            flag2 = p_19547_.getBoolean("ShowIcon");
        }
        MobEffectInstance mobeffectinstance = null;
        if (p_19547_.contains("HiddenEffect", 10)) {
            mobeffectinstance = MobEffectInstance.loadSpecifiedEffect(p_19546_, p_19547_.getCompound("HiddenEffect"));
        }
        Optional optional = p_19547_.contains("FactorCalculationData", 10) ? FactorData.CODEC.parse(new Dynamic((DynamicOps)NbtOps.INSTANCE, (Object)p_19547_.getCompound("FactorCalculationData"))).resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0)) : Optional.empty();
        return MobEffectInstance.readCurativeItems(new MobEffectInstance(p_19546_, j, Math.max(0, i), flag, flag1, flag2, mobeffectinstance, optional), p_19547_);
    }

    @Override
    public int compareTo(MobEffectInstance p_19566_) {
        int i = 32147;
        return !(this.getDuration() > 32147 && p_19566_.getDuration() > 32147 || this.isAmbient() && p_19566_.isAmbient()) ? ComparisonChain.start().compare(Boolean.valueOf(this.isAmbient()), Boolean.valueOf(p_19566_.isAmbient())).compare(this.getDuration(), p_19566_.getDuration()).compare(this.getEffect().getSortOrder(this), p_19566_.getEffect().getSortOrder(this)).result() : ComparisonChain.start().compare(Boolean.valueOf(this.isAmbient()), Boolean.valueOf(p_19566_.isAmbient())).compare(this.getEffect().getSortOrder(this), p_19566_.getEffect().getSortOrder(this)).result();
    }

    @Override
    public List<ItemStack> getCurativeItems() {
        if (this.curativeItems == null) {
            this.curativeItems = this.getEffect().getCurativeItems();
        }
        return this.curativeItems;
    }

    @Override
    public void setCurativeItems(List<ItemStack> curativeItems) {
        this.curativeItems = curativeItems;
    }

    private static MobEffectInstance readCurativeItems(MobEffectInstance effect, CompoundTag nbt) {
        if (nbt.contains("CurativeItems", 9)) {
            ArrayList<ItemStack> items = new ArrayList<ItemStack>();
            ListTag list = nbt.getList("CurativeItems", 10);
            for (int i = 0; i < list.size(); ++i) {
                items.add(ItemStack.of(list.getCompound(i)));
            }
            effect.setCurativeItems(items);
        }
        return effect;
    }

    public static class FactorData {
        public static final Codec<FactorData> CODEC = RecordCodecBuilder.create(p_216933_ -> p_216933_.group((App)ExtraCodecs.NON_NEGATIVE_INT.fieldOf("padding_duration").forGetter(p_216945_ -> p_216945_.paddingDuration), (App)Codec.FLOAT.fieldOf("factor_start").orElse((Object)Float.valueOf(0.0f)).forGetter(p_216943_ -> Float.valueOf(p_216943_.factorStart)), (App)Codec.FLOAT.fieldOf("factor_target").orElse((Object)Float.valueOf(1.0f)).forGetter(p_216941_ -> Float.valueOf(p_216941_.factorTarget)), (App)Codec.FLOAT.fieldOf("factor_current").orElse((Object)Float.valueOf(0.0f)).forGetter(p_216939_ -> Float.valueOf(p_216939_.factorCurrent)), (App)ExtraCodecs.NON_NEGATIVE_INT.fieldOf("ticks_active").orElse((Object)0).forGetter(p_267918_ -> p_267918_.ticksActive), (App)Codec.FLOAT.fieldOf("factor_previous_frame").orElse((Object)Float.valueOf(0.0f)).forGetter(p_216935_ -> Float.valueOf(p_216935_.factorPreviousFrame)), (App)Codec.BOOL.fieldOf("had_effect_last_tick").orElse((Object)false).forGetter(p_216929_ -> p_216929_.hadEffectLastTick)).apply((Applicative)p_216933_, FactorData::new));
        private final int paddingDuration;
        private float factorStart;
        private float factorTarget;
        private float factorCurrent;
        private int ticksActive;
        private float factorPreviousFrame;
        private boolean hadEffectLastTick;

        public FactorData(int p_216919_, float p_216920_, float p_216921_, float p_216922_, int p_216923_, float p_216924_, boolean p_216925_) {
            this.paddingDuration = p_216919_;
            this.factorStart = p_216920_;
            this.factorTarget = p_216921_;
            this.factorCurrent = p_216922_;
            this.ticksActive = p_216923_;
            this.factorPreviousFrame = p_216924_;
            this.hadEffectLastTick = p_216925_;
        }

        public FactorData(int p_216917_) {
            this(p_216917_, 0.0f, 1.0f, 0.0f, 0, 0.0f, false);
        }

        public void tick(MobEffectInstance p_268212_) {
            this.factorPreviousFrame = this.factorCurrent;
            boolean flag = !p_268212_.endsWithin(this.paddingDuration);
            ++this.ticksActive;
            if (this.hadEffectLastTick != flag) {
                this.hadEffectLastTick = flag;
                this.ticksActive = 0;
                this.factorStart = this.factorCurrent;
                this.factorTarget = flag ? 1.0f : 0.0f;
            }
            float f = Mth.clamp((float)this.ticksActive / (float)this.paddingDuration, 0.0f, 1.0f);
            this.factorCurrent = Mth.lerp(f, this.factorStart, this.factorTarget);
        }

        public float getFactor(LivingEntity p_238414_, float p_238415_) {
            if (p_238414_.isRemoved()) {
                this.factorPreviousFrame = this.factorCurrent;
            }
            return Mth.lerp(p_238415_, this.factorPreviousFrame, this.factorCurrent);
        }
    }
}

