/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.valueproviders;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.FloatProvider;
import net.minecraft.util.valueproviders.FloatProviderType;

public class ConstantFloat
extends FloatProvider {
    public static final ConstantFloat ZERO = new ConstantFloat(0.0f);
    public static final Codec<ConstantFloat> CODEC = Codec.either((Codec)Codec.FLOAT, (Codec)RecordCodecBuilder.create(p_146465_ -> p_146465_.group((App)Codec.FLOAT.fieldOf("value").forGetter(p_146473_ -> Float.valueOf(p_146473_.value))).apply((Applicative)p_146465_, ConstantFloat::new))).xmap(p_146463_ -> (ConstantFloat)p_146463_.map(ConstantFloat::of, p_146470_ -> p_146470_), p_146461_ -> Either.left((Object)Float.valueOf(p_146461_.value)));
    private final float value;

    public static ConstantFloat of(float p_146459_) {
        return p_146459_ == 0.0f ? ZERO : new ConstantFloat(p_146459_);
    }

    private ConstantFloat(float p_146456_) {
        this.value = p_146456_;
    }

    public float getValue() {
        return this.value;
    }

    @Override
    public float sample(RandomSource p_216852_) {
        return this.value;
    }

    @Override
    public float getMinValue() {
        return this.value;
    }

    @Override
    public float getMaxValue() {
        return this.value + 1.0f;
    }

    @Override
    public FloatProviderType<?> getType() {
        return FloatProviderType.CONSTANT;
    }

    public String toString() {
        return Float.toString(this.value);
    }
}

