/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.profiling.jfr.serialize;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.LongSerializationPolicy;
import com.mojang.datafixers.util.Pair;
import java.time.Duration;
import java.util.DoubleSummaryStatistics;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.ToDoubleFunction;
import java.util.stream.DoubleStream;
import net.minecraft.Util;
import net.minecraft.util.profiling.jfr.Percentiles;
import net.minecraft.util.profiling.jfr.parse.JfrStatsResult;
import net.minecraft.util.profiling.jfr.stats.ChunkGenStat;
import net.minecraft.util.profiling.jfr.stats.CpuLoadStat;
import net.minecraft.util.profiling.jfr.stats.FileIOStat;
import net.minecraft.util.profiling.jfr.stats.GcHeapStat;
import net.minecraft.util.profiling.jfr.stats.NetworkPacketSummary;
import net.minecraft.util.profiling.jfr.stats.ThreadAllocationStat;
import net.minecraft.util.profiling.jfr.stats.TickTimeStat;
import net.minecraft.util.profiling.jfr.stats.TimedStatSummary;
import net.minecraft.world.level.chunk.ChunkStatus;

public class JfrResultJsonSerializer {
    private static final String BYTES_PER_SECOND = "bytesPerSecond";
    private static final String COUNT = "count";
    private static final String DURATION_NANOS_TOTAL = "durationNanosTotal";
    private static final String TOTAL_BYTES = "totalBytes";
    private static final String COUNT_PER_SECOND = "countPerSecond";
    final Gson gson = new GsonBuilder().setPrettyPrinting().setLongSerializationPolicy(LongSerializationPolicy.DEFAULT).create();

    public String format(JfrStatsResult p_185536_) {
        JsonObject jsonobject = new JsonObject();
        jsonobject.addProperty("startedEpoch", (Number)p_185536_.recordingStarted().toEpochMilli());
        jsonobject.addProperty("endedEpoch", (Number)p_185536_.recordingEnded().toEpochMilli());
        jsonobject.addProperty("durationMs", (Number)p_185536_.recordingDuration().toMillis());
        Duration duration = p_185536_.worldCreationDuration();
        if (duration != null) {
            jsonobject.addProperty("worldGenDurationMs", (Number)duration.toMillis());
        }
        jsonobject.add("heap", this.heap(p_185536_.heapSummary()));
        jsonobject.add("cpuPercent", this.cpu(p_185536_.cpuLoadStats()));
        jsonobject.add("network", this.network(p_185536_));
        jsonobject.add("fileIO", this.fileIO(p_185536_));
        jsonobject.add("serverTick", this.serverTicks(p_185536_.tickTimes()));
        jsonobject.add("threadAllocation", this.threadAllocations(p_185536_.threadAllocationSummary()));
        jsonobject.add("chunkGen", this.chunkGen(p_185536_.chunkGenSummary()));
        return this.gson.toJson((JsonElement)jsonobject);
    }

    private JsonElement heap(GcHeapStat.Summary p_185542_) {
        JsonObject jsonobject = new JsonObject();
        jsonobject.addProperty("allocationRateBytesPerSecond", (Number)p_185542_.allocationRateBytesPerSecond());
        jsonobject.addProperty("gcCount", (Number)p_185542_.totalGCs());
        jsonobject.addProperty("gcOverHeadPercent", (Number)Float.valueOf(p_185542_.gcOverHead()));
        jsonobject.addProperty("gcTotalDurationMs", (Number)p_185542_.gcTotalDuration().toMillis());
        return jsonobject;
    }

    private JsonElement chunkGen(List<Pair<ChunkStatus, TimedStatSummary<ChunkGenStat>>> p_185573_) {
        JsonObject jsonobject = new JsonObject();
        jsonobject.addProperty(DURATION_NANOS_TOTAL, (Number)p_185573_.stream().mapToDouble(p_185567_ -> ((TimedStatSummary)p_185567_.getSecond()).totalDuration().toNanos()).sum());
        JsonArray jsonarray = Util.make(new JsonArray(), p_185558_ -> jsonobject.add("status", (JsonElement)p_185558_));
        for (Pair<ChunkStatus, TimedStatSummary<ChunkGenStat>> pair : p_185573_) {
            TimedStatSummary timedstatsummary = (TimedStatSummary)pair.getSecond();
            JsonObject jsonobject1 = Util.make(new JsonObject(), arg_0 -> ((JsonArray)jsonarray).add(arg_0));
            jsonobject1.addProperty("state", ((ChunkStatus)pair.getFirst()).toString());
            jsonobject1.addProperty(COUNT, (Number)timedstatsummary.count());
            jsonobject1.addProperty(DURATION_NANOS_TOTAL, (Number)timedstatsummary.totalDuration().toNanos());
            jsonobject1.addProperty("durationNanosAvg", (Number)(timedstatsummary.totalDuration().toNanos() / (long)timedstatsummary.count()));
            JsonObject jsonobject2 = Util.make(new JsonObject(), p_185561_ -> jsonobject1.add("durationNanosPercentiles", (JsonElement)p_185561_));
            timedstatsummary.percentilesNanos().forEach((p_185584_, p_185585_) -> jsonobject2.addProperty("p" + p_185584_, (Number)p_185585_));
            Function<ChunkGenStat, JsonElement> function = p_185538_ -> {
                JsonObject jsonobject3 = new JsonObject();
                jsonobject3.addProperty("durationNanos", (Number)p_185538_.duration().toNanos());
                jsonobject3.addProperty("level", p_185538_.level());
                jsonobject3.addProperty("chunkPosX", (Number)p_185538_.chunkPos().x);
                jsonobject3.addProperty("chunkPosZ", (Number)p_185538_.chunkPos().z);
                jsonobject3.addProperty("worldPosX", (Number)p_185538_.worldPos().x());
                jsonobject3.addProperty("worldPosZ", (Number)p_185538_.worldPos().z());
                return jsonobject3;
            };
            jsonobject1.add("fastest", function.apply((ChunkGenStat)timedstatsummary.fastest()));
            jsonobject1.add("slowest", function.apply((ChunkGenStat)timedstatsummary.slowest()));
            jsonobject1.add("secondSlowest", (JsonElement)(timedstatsummary.secondSlowest() != null ? function.apply((ChunkGenStat)timedstatsummary.secondSlowest()) : JsonNull.INSTANCE));
        }
        return jsonobject;
    }

    private JsonElement threadAllocations(ThreadAllocationStat.Summary p_185546_) {
        JsonArray jsonarray = new JsonArray();
        p_185546_.allocationsPerSecondByThread().forEach((p_185554_, p_185555_) -> jsonarray.add((JsonElement)Util.make(new JsonObject(), p_185571_ -> {
            p_185571_.addProperty("thread", p_185554_);
            p_185571_.addProperty(BYTES_PER_SECOND, (Number)p_185555_);
        })));
        return jsonarray;
    }

    private JsonElement serverTicks(List<TickTimeStat> p_185587_) {
        if (p_185587_.isEmpty()) {
            return JsonNull.INSTANCE;
        }
        JsonObject jsonobject = new JsonObject();
        double[] adouble = p_185587_.stream().mapToDouble(p_185548_ -> (double)p_185548_.currentAverage().toNanos() / 1000000.0).toArray();
        DoubleSummaryStatistics doublesummarystatistics = DoubleStream.of(adouble).summaryStatistics();
        jsonobject.addProperty("minMs", (Number)doublesummarystatistics.getMin());
        jsonobject.addProperty("averageMs", (Number)doublesummarystatistics.getAverage());
        jsonobject.addProperty("maxMs", (Number)doublesummarystatistics.getMax());
        Map<Integer, Double> map = Percentiles.evaluate(adouble);
        map.forEach((p_185564_, p_185565_) -> jsonobject.addProperty("p" + p_185564_, (Number)p_185565_));
        return jsonobject;
    }

    private JsonElement fileIO(JfrStatsResult p_185578_) {
        JsonObject jsonobject = new JsonObject();
        jsonobject.add("write", this.fileIoSummary(p_185578_.fileWrites()));
        jsonobject.add("read", this.fileIoSummary(p_185578_.fileReads()));
        return jsonobject;
    }

    private JsonElement fileIoSummary(FileIOStat.Summary p_185540_) {
        JsonObject jsonobject = new JsonObject();
        jsonobject.addProperty(TOTAL_BYTES, (Number)p_185540_.totalBytes());
        jsonobject.addProperty(COUNT, (Number)p_185540_.counts());
        jsonobject.addProperty(BYTES_PER_SECOND, (Number)p_185540_.bytesPerSecond());
        jsonobject.addProperty(COUNT_PER_SECOND, (Number)p_185540_.countsPerSecond());
        JsonArray jsonarray = new JsonArray();
        jsonobject.add("topContributors", (JsonElement)jsonarray);
        p_185540_.topTenContributorsByTotalBytes().forEach(p_185581_ -> {
            JsonObject jsonobject1 = new JsonObject();
            jsonarray.add((JsonElement)jsonobject1);
            jsonobject1.addProperty("path", (String)p_185581_.getFirst());
            jsonobject1.addProperty(TOTAL_BYTES, (Number)p_185581_.getSecond());
        });
        return jsonobject;
    }

    private JsonElement network(JfrStatsResult p_185589_) {
        JsonObject jsonobject = new JsonObject();
        jsonobject.add("sent", this.packets(p_185589_.sentPacketsSummary()));
        jsonobject.add("received", this.packets(p_185589_.receivedPacketsSummary()));
        return jsonobject;
    }

    private JsonElement packets(NetworkPacketSummary p_185544_) {
        JsonObject jsonobject = new JsonObject();
        jsonobject.addProperty(TOTAL_BYTES, (Number)p_185544_.getTotalSize());
        jsonobject.addProperty(COUNT, (Number)p_185544_.getTotalCount());
        jsonobject.addProperty(BYTES_PER_SECOND, (Number)p_185544_.getSizePerSecond());
        jsonobject.addProperty(COUNT_PER_SECOND, (Number)p_185544_.getCountsPerSecond());
        JsonArray jsonarray = new JsonArray();
        jsonobject.add("topContributors", (JsonElement)jsonarray);
        p_185544_.largestSizeContributors().forEach(p_185551_ -> {
            JsonObject jsonobject1 = new JsonObject();
            jsonarray.add((JsonElement)jsonobject1);
            NetworkPacketSummary.PacketIdentification networkpacketsummary$packetidentification = (NetworkPacketSummary.PacketIdentification)p_185551_.getFirst();
            NetworkPacketSummary.PacketCountAndSize networkpacketsummary$packetcountandsize = (NetworkPacketSummary.PacketCountAndSize)p_185551_.getSecond();
            jsonobject1.addProperty("protocolId", (Number)networkpacketsummary$packetidentification.protocolId());
            jsonobject1.addProperty("packetId", (Number)networkpacketsummary$packetidentification.packetId());
            jsonobject1.addProperty("packetName", networkpacketsummary$packetidentification.packetName());
            jsonobject1.addProperty(TOTAL_BYTES, (Number)networkpacketsummary$packetcountandsize.totalSize());
            jsonobject1.addProperty(COUNT, (Number)networkpacketsummary$packetcountandsize.totalCount());
        });
        return jsonobject;
    }

    private JsonElement cpu(List<CpuLoadStat> p_185591_) {
        JsonObject jsonobject = new JsonObject();
        BiFunction<List, ToDoubleFunction, JsonObject> bifunction = (p_185575_, p_185576_) -> {
            JsonObject jsonobject1 = new JsonObject();
            DoubleSummaryStatistics doublesummarystatistics = p_185575_.stream().mapToDouble(p_185576_).summaryStatistics();
            jsonobject1.addProperty("min", (Number)doublesummarystatistics.getMin());
            jsonobject1.addProperty("average", (Number)doublesummarystatistics.getAverage());
            jsonobject1.addProperty("max", (Number)doublesummarystatistics.getMax());
            return jsonobject1;
        };
        jsonobject.add("jvm", (JsonElement)bifunction.apply(p_185591_, CpuLoadStat::jvm));
        jsonobject.add("userJvm", (JsonElement)bifunction.apply(p_185591_, CpuLoadStat::userJvm));
        jsonobject.add("system", (JsonElement)bifunction.apply(p_185591_, CpuLoadStat::system));
        return jsonobject;
    }
}

