/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.datafix.fixes;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.DSL;
import com.mojang.datafixers.DataFix;
import com.mojang.datafixers.DataFixUtils;
import com.mojang.datafixers.OpticFinder;
import com.mojang.datafixers.TypeRewriteRule;
import com.mojang.datafixers.Typed;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.datafixers.types.Type;
import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.util.datafix.fixes.References;

public class EntityRidingToPassengersFix
extends DataFix {
    public EntityRidingToPassengersFix(Schema p_15638_, boolean p_15639_) {
        super(p_15638_, p_15639_);
    }

    public TypeRewriteRule makeRule() {
        Schema schema = this.getInputSchema();
        Schema schema1 = this.getOutputSchema();
        Type type = schema.getTypeRaw(References.ENTITY_TREE);
        Type type1 = schema1.getTypeRaw(References.ENTITY_TREE);
        Type type2 = schema.getTypeRaw(References.ENTITY);
        return this.cap(schema, schema1, type, type1, type2);
    }

    private <OldEntityTree, NewEntityTree, Entity> TypeRewriteRule cap(Schema p_15642_, Schema p_15643_, Type<OldEntityTree> p_15644_, Type<NewEntityTree> p_15645_, Type<Entity> p_15646_) {
        Type type = DSL.named((String)References.ENTITY_TREE.typeName(), (Type)DSL.and((Type)DSL.optional((Type)DSL.field((String)"Riding", p_15644_)), p_15646_));
        Type type1 = DSL.named((String)References.ENTITY_TREE.typeName(), (Type)DSL.and((Type)DSL.optional((Type)DSL.field((String)"Passengers", (Type)DSL.list(p_15645_))), p_15646_));
        Type type2 = p_15642_.getType(References.ENTITY_TREE);
        Type type3 = p_15643_.getType(References.ENTITY_TREE);
        if (!Objects.equals(type2, type)) {
            throw new IllegalStateException("Old entity type is not what was expected.");
        }
        if (!type3.equals((Object)type1, true, true)) {
            throw new IllegalStateException("New entity type is not what was expected.");
        }
        OpticFinder opticfinder = DSL.typeFinder((Type)type);
        OpticFinder opticfinder1 = DSL.typeFinder((Type)type1);
        OpticFinder opticfinder2 = DSL.typeFinder(p_15645_);
        Type type4 = p_15642_.getType(References.PLAYER);
        Type type5 = p_15643_.getType(References.PLAYER);
        return TypeRewriteRule.seq((TypeRewriteRule)this.fixTypeEverywhere("EntityRidingToPassengerFix", type, type1, p_15653_ -> p_145320_ -> {
            Optional<Object> optional = Optional.empty();
            Pair pair = p_145320_;
            while (true) {
                Either either = (Either)DataFixUtils.orElse(optional.map(p_145326_ -> {
                    Typed typed = (Typed)p_15645_.pointTyped(p_15653_).orElseThrow(() -> new IllegalStateException("Could not create new entity tree"));
                    Object newentitytree = typed.set(opticfinder1, p_145326_).getOptional(opticfinder2).orElseThrow(() -> new IllegalStateException("Should always have an entity tree here"));
                    return Either.left((Object)ImmutableList.of(newentitytree));
                }), (Object)Either.right((Object)DSL.unit()));
                optional = Optional.of(Pair.of((Object)References.ENTITY_TREE.typeName(), (Object)Pair.of((Object)either, (Object)((Pair)pair.getSecond()).getSecond())));
                Optional optional1 = ((Either)((Pair)pair.getSecond()).getFirst()).left();
                if (!optional1.isPresent()) {
                    return (Pair)optional.orElseThrow(() -> new IllegalStateException("Should always have an entity tree here"));
                }
                pair = (Pair)new Typed(p_15644_, p_15653_, optional1.get()).getOptional(opticfinder).orElseThrow(() -> new IllegalStateException("Should always have an entity here"));
            }
        }), (TypeRewriteRule)this.writeAndRead("player RootVehicle injecter", type4, type5));
    }
}

