/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util;

import java.util.function.IntConsumer;
import javax.annotation.Nullable;
import net.minecraft.util.BitStorage;
import org.apache.commons.lang3.Validate;

public class SimpleBitStorage
implements BitStorage {
    private static final int[] MAGIC = new int[]{-1, -1, 0, Integer.MIN_VALUE, 0, 0, 0x55555555, 0x55555555, 0, Integer.MIN_VALUE, 0, 1, 0x33333333, 0x33333333, 0, 0x2AAAAAAA, 0x2AAAAAAA, 0, 0x24924924, 0x24924924, 0, Integer.MIN_VALUE, 0, 2, 0x1C71C71C, 0x1C71C71C, 0, 0x19999999, 0x19999999, 0, 390451572, 390451572, 0, 0x15555555, 0x15555555, 0, 0x13B13B13, 0x13B13B13, 0, 306783378, 306783378, 0, 0x11111111, 0x11111111, 0, Integer.MIN_VALUE, 0, 3, 0xF0F0F0F, 0xF0F0F0F, 0, 0xE38E38E, 0xE38E38E, 0, 226050910, 226050910, 0, 0xCCCCCCC, 0xCCCCCCC, 0, 0xC30C30C, 0xC30C30C, 0, 195225786, 195225786, 0, 186737708, 186737708, 0, 0xAAAAAAA, 0xAAAAAAA, 0, 171798691, 171798691, 0, 0x9D89D89, 0x9D89D89, 0, 159072862, 159072862, 0, 0x9249249, 0x9249249, 0, 148102320, 148102320, 0, 0x8888888, 0x8888888, 0, 138547332, 138547332, 0, Integer.MIN_VALUE, 0, 4, 130150524, 130150524, 0, 0x7878787, 0x7878787, 0, 0x7507507, 0x7507507, 0, 0x71C71C7, 0x71C71C7, 0, 116080197, 116080197, 0, 113025455, 113025455, 0, 0x6906906, 0x6906906, 0, 0x6666666, 0x6666666, 0, 104755299, 104755299, 0, 0x6186186, 0x6186186, 0, 99882960, 99882960, 0, 97612893, 97612893, 0, 0x5B05B05, 0x5B05B05, 0, 93368854, 93368854, 0, 91382282, 91382282, 0, 0x5555555, 0x5555555, 0, 87652393, 87652393, 0, 85899345, 85899345, 0, 0x5050505, 0x5050505, 0, 0x4EC4EC4, 0x4EC4EC4, 0, 81037118, 81037118, 0, 79536431, 79536431, 0, 78090314, 78090314, 0, 0x4924924, 0x4924924, 0, 75350303, 75350303, 0, 74051160, 74051160, 0, 72796055, 72796055, 0, 0x4444444, 0x4444444, 0, 70409299, 70409299, 0, 69273666, 69273666, 0, 0x4104104, 0x4104104, 0, Integer.MIN_VALUE, 0, 5};
    private final long[] data;
    private final int bits;
    private final long mask;
    private final int size;
    private final int valuesPerLong;
    private final int divideMul;
    private final int divideAdd;
    private final int divideShift;

    public SimpleBitStorage(int p_198164_, int p_198165_, int[] p_198166_) {
        this(p_198164_, p_198165_);
        int i;
        int j = 0;
        for (i = 0; i <= p_198165_ - this.valuesPerLong; i += this.valuesPerLong) {
            long k = 0L;
            for (int i1 = this.valuesPerLong - 1; i1 >= 0; --i1) {
                k <<= p_198164_;
                k |= (long)p_198166_[i + i1] & this.mask;
            }
            this.data[j++] = k;
        }
        int k1 = p_198165_ - i;
        if (k1 > 0) {
            long l = 0L;
            for (int j1 = k1 - 1; j1 >= 0; --j1) {
                l <<= p_198164_;
                l |= (long)p_198166_[i + j1] & this.mask;
            }
            this.data[j] = l;
        }
    }

    public SimpleBitStorage(int p_184717_, int p_184718_) {
        this(p_184717_, p_184718_, (long[])null);
    }

    public SimpleBitStorage(int p_184724_, int p_184725_, @Nullable long[] p_184726_) {
        Validate.inclusiveBetween((long)1L, (long)32L, (long)p_184724_);
        this.size = p_184725_;
        this.bits = p_184724_;
        this.mask = (1L << p_184724_) - 1L;
        this.valuesPerLong = (char)(64 / p_184724_);
        int i = 3 * (this.valuesPerLong - 1);
        this.divideMul = MAGIC[i + 0];
        this.divideAdd = MAGIC[i + 1];
        this.divideShift = MAGIC[i + 2];
        int j = (p_184725_ + this.valuesPerLong - 1) / this.valuesPerLong;
        if (p_184726_ != null) {
            if (p_184726_.length != j) {
                throw new InitializationException("Invalid length given for storage, got: " + p_184726_.length + " but expected: " + j);
            }
            this.data = p_184726_;
        } else {
            this.data = new long[j];
        }
    }

    private int cellIndex(int p_184740_) {
        long i = Integer.toUnsignedLong(this.divideMul);
        long j = Integer.toUnsignedLong(this.divideAdd);
        return (int)((long)p_184740_ * i + j >> 32 >> this.divideShift);
    }

    @Override
    public int getAndSet(int p_184731_, int p_184732_) {
        Validate.inclusiveBetween((long)0L, (long)(this.size - 1), (long)p_184731_);
        Validate.inclusiveBetween((long)0L, (long)this.mask, (long)p_184732_);
        int i = this.cellIndex(p_184731_);
        long j = this.data[i];
        int k = (p_184731_ - i * this.valuesPerLong) * this.bits;
        int l = (int)(j >> k & this.mask);
        this.data[i] = j & (this.mask << k ^ 0xFFFFFFFFFFFFFFFFL) | ((long)p_184732_ & this.mask) << k;
        return l;
    }

    @Override
    public void set(int p_184742_, int p_184743_) {
        Validate.inclusiveBetween((long)0L, (long)(this.size - 1), (long)p_184742_);
        Validate.inclusiveBetween((long)0L, (long)this.mask, (long)p_184743_);
        int i = this.cellIndex(p_184742_);
        long j = this.data[i];
        int k = (p_184742_ - i * this.valuesPerLong) * this.bits;
        this.data[i] = j & (this.mask << k ^ 0xFFFFFFFFFFFFFFFFL) | ((long)p_184743_ & this.mask) << k;
    }

    @Override
    public int get(int p_184729_) {
        Validate.inclusiveBetween((long)0L, (long)(this.size - 1), (long)p_184729_);
        int i = this.cellIndex(p_184729_);
        long j = this.data[i];
        int k = (p_184729_ - i * this.valuesPerLong) * this.bits;
        return (int)(j >> k & this.mask);
    }

    @Override
    public long[] getRaw() {
        return this.data;
    }

    @Override
    public int getSize() {
        return this.size;
    }

    @Override
    public int getBits() {
        return this.bits;
    }

    @Override
    public void getAll(IntConsumer p_184734_) {
        int i = 0;
        for (long j : this.data) {
            for (int k = 0; k < this.valuesPerLong; ++k) {
                p_184734_.accept((int)(j & this.mask));
                j >>= this.bits;
                if (++i < this.size) continue;
                return;
            }
        }
    }

    @Override
    public void unpack(int[] p_198168_) {
        int i = this.data.length;
        int j = 0;
        for (int k = 0; k < i - 1; ++k) {
            long l = this.data[k];
            for (int i1 = 0; i1 < this.valuesPerLong; ++i1) {
                p_198168_[j + i1] = (int)(l & this.mask);
                l >>= this.bits;
            }
            j += this.valuesPerLong;
        }
        int j1 = this.size - j;
        if (j1 > 0) {
            long k1 = this.data[i - 1];
            for (int l1 = 0; l1 < j1; ++l1) {
                p_198168_[j + l1] = (int)(k1 & this.mask);
                k1 >>= this.bits;
            }
        }
    }

    @Override
    public BitStorage copy() {
        return new SimpleBitStorage(this.bits, this.size, (long[])this.data.clone());
    }

    public static class InitializationException
    extends RuntimeException {
        InitializationException(String p_184746_) {
            super(p_184746_);
        }
    }
}

