/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.tags;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.tags.TagLoader;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraftforge.common.ForgeHooks;

public class TagManager
implements PreparableReloadListener {
    private static final Map<ResourceKey<? extends Registry<?>>, String> CUSTOM_REGISTRY_DIRECTORIES = Map.of(Registries.BLOCK, "tags/blocks", Registries.ENTITY_TYPE, "tags/entity_types", Registries.FLUID, "tags/fluids", Registries.GAME_EVENT, "tags/game_events", Registries.ITEM, "tags/items");
    private final RegistryAccess registryAccess;
    private List<LoadResult<?>> results = List.of();

    public TagManager(RegistryAccess p_144572_) {
        this.registryAccess = p_144572_;
    }

    public List<LoadResult<?>> getResult() {
        return this.results;
    }

    public static String getTagDir(ResourceKey<? extends Registry<?>> p_203919_) {
        String s = CUSTOM_REGISTRY_DIRECTORIES.get(p_203919_);
        return s != null ? s : "tags/" + ForgeHooks.prefixNamespace(p_203919_.location());
    }

    @Override
    public CompletableFuture<Void> reload(PreparableReloadListener.PreparationBarrier p_13482_, ResourceManager p_13483_, ProfilerFiller p_13484_, ProfilerFiller p_13485_, Executor p_13486_, Executor p_13487_) {
        List<CompletableFuture> list = this.registryAccess.registries().map(p_203927_ -> this.createLoader(p_13483_, p_13486_, (RegistryAccess.RegistryEntry)p_203927_)).toList();
        return ((CompletableFuture)CompletableFuture.allOf((CompletableFuture[])list.toArray(CompletableFuture[]::new)).thenCompose(p_13482_::wait)).thenAcceptAsync(p_203917_ -> {
            this.results = list.stream().map(CompletableFuture::join).collect(Collectors.toUnmodifiableList());
        }, p_13487_);
    }

    private <T> CompletableFuture<LoadResult<T>> createLoader(ResourceManager p_203908_, Executor p_203909_, RegistryAccess.RegistryEntry<T> p_203910_) {
        ResourceKey resourcekey = p_203910_.key();
        Registry registry = p_203910_.value();
        TagLoader tagloader = new TagLoader(p_258247_ -> registry.getHolder(ResourceKey.create(resourcekey, p_258247_)), TagManager.getTagDir(resourcekey));
        return CompletableFuture.supplyAsync(() -> new LoadResult(resourcekey, tagloader.loadAndBuild(p_203908_)), p_203909_);
    }

    public record LoadResult<T>(ResourceKey<? extends Registry<T>> key, Map<ResourceLocation, Collection<Holder<T>>> tags) {
    }
}

