/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.packs.repository;

import com.mojang.logging.LogUtils;
import java.io.File;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.FileUtil;
import net.minecraft.network.chat.Component;
import net.minecraft.server.packs.FilePackResources;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.PathPackResources;
import net.minecraft.server.packs.linkfs.LinkFileSystem;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.PackSource;
import net.minecraft.server.packs.repository.RepositorySource;
import org.slf4j.Logger;

public class FolderRepositorySource
implements RepositorySource {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final Path folder;
    private final PackType packType;
    private final PackSource packSource;

    public FolderRepositorySource(Path p_251796_, PackType p_251664_, PackSource p_250854_) {
        this.folder = p_251796_;
        this.packType = p_251664_;
        this.packSource = p_250854_;
    }

    private static String nameFromPath(Path p_248745_) {
        return p_248745_.getFileName().toString();
    }

    @Override
    public void loadPacks(Consumer<Pack> p_250965_) {
        try {
            FileUtil.createDirectoriesSafe(this.folder);
            FolderRepositorySource.discoverPacks(this.folder, false, (p_248243_, p_248244_) -> {
                String s = FolderRepositorySource.nameFromPath(p_248243_);
                Pack pack = Pack.readMetaAndCreate("file/" + s, Component.literal(s), false, p_248244_, this.packType, Pack.Position.TOP, this.packSource);
                if (pack != null) {
                    p_250965_.accept(pack);
                }
            });
        }
        catch (IOException ioexception) {
            LOGGER.warn("Failed to list packs in {}", (Object)this.folder, (Object)ioexception);
        }
    }

    public static void discoverPacks(Path p_248794_, boolean p_255987_, BiConsumer<Path, Pack.ResourcesSupplier> p_248580_) throws IOException {
        try (DirectoryStream<Path> directorystream = Files.newDirectoryStream(p_248794_);){
            for (Path path : directorystream) {
                Pack.ResourcesSupplier pack$resourcessupplier = FolderRepositorySource.detectPackResources(path, p_255987_);
                if (pack$resourcessupplier == null) continue;
                p_248580_.accept(path, pack$resourcessupplier);
            }
        }
    }

    @Nullable
    public static Pack.ResourcesSupplier detectPackResources(Path p_255665_, boolean p_255971_) {
        FileSystem filesystem;
        BasicFileAttributes basicfileattributes;
        try {
            basicfileattributes = Files.readAttributes(p_255665_, BasicFileAttributes.class, new LinkOption[0]);
        }
        catch (NoSuchFileException nosuchfileexception) {
            return null;
        }
        catch (IOException ioexception) {
            LOGGER.warn("Failed to read properties of '{}', ignoring", (Object)p_255665_, (Object)ioexception);
            return null;
        }
        if (basicfileattributes.isDirectory() && Files.isRegularFile(p_255665_.resolve("pack.mcmeta"), new LinkOption[0])) {
            return p_255538_ -> new PathPackResources(p_255538_, p_255665_, p_255971_);
        }
        if (basicfileattributes.isRegularFile() && p_255665_.getFileName().toString().endsWith(".zip") && ((filesystem = p_255665_.getFileSystem()) == FileSystems.getDefault() || filesystem instanceof LinkFileSystem)) {
            File file1 = p_255665_.toFile();
            return p_255541_ -> new FilePackResources(p_255541_, file1, p_255971_);
        }
        LOGGER.info("Found non-pack entry '{}', ignoring", (Object)p_255665_);
        return null;
    }
}

