/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.packs;

import com.google.common.collect.ImmutableMap;
import com.mojang.logging.LogUtils;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.nio.file.FileSystemAlreadyExistsException;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import net.minecraft.Util;
import net.minecraft.server.packs.BuiltInMetadata;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.VanillaPackResources;
import org.slf4j.Logger;

public class VanillaPackResourcesBuilder {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static Consumer<VanillaPackResourcesBuilder> developmentConfig = p_251787_ -> {};
    private static final Map<PackType, Path> ROOT_DIR_BY_TYPE = (Map)Util.make(() -> {
        Class<VanillaPackResources> clazz = VanillaPackResources.class;
        synchronized (VanillaPackResources.class) {
            ImmutableMap.Builder builder = ImmutableMap.builder();
            for (PackType packtype : PackType.values()) {
                String s = "/" + packtype.getDirectory() + "/.mcassetsroot";
                URL url = VanillaPackResources.class.getResource(s);
                if (url == null) {
                    LOGGER.error("File {} does not exist in classpath", (Object)s);
                    continue;
                }
                try {
                    URI uri = url.toURI();
                    String s1 = uri.getScheme();
                    if (!"jar".equals(s1) && !"file".equals(s1)) {
                        LOGGER.warn("Assets URL '{}' uses unexpected schema", (Object)uri);
                    }
                    Path path = VanillaPackResourcesBuilder.safeGetPath(uri);
                    builder.put((Object)packtype, (Object)path.getParent());
                }
                catch (Exception exception) {
                    LOGGER.error("Couldn't resolve path to vanilla assets", (Throwable)exception);
                }
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return builder.build();
        }
    });
    private final Set<Path> rootPaths = new LinkedHashSet<Path>();
    private final Map<PackType, Set<Path>> pathsForType = new EnumMap<PackType, Set<Path>>(PackType.class);
    private BuiltInMetadata metadata = BuiltInMetadata.of();
    private final Set<String> namespaces = new HashSet<String>();

    private static Path safeGetPath(URI p_248652_) throws IOException {
        try {
            return Paths.get(p_248652_);
        }
        catch (FileSystemNotFoundException fileSystemNotFoundException) {
        }
        catch (Throwable throwable) {
            LOGGER.warn("Unable to get path for: {}", (Object)p_248652_, (Object)throwable);
        }
        try {
            FileSystems.newFileSystem(p_248652_, Collections.emptyMap());
        }
        catch (FileSystemAlreadyExistsException fileSystemAlreadyExistsException) {
            // empty catch block
        }
        return Paths.get(p_248652_);
    }

    private boolean validateDirPath(Path p_249112_) {
        if (!Files.exists(p_249112_, new LinkOption[0])) {
            return false;
        }
        if (!Files.isDirectory(p_249112_, new LinkOption[0])) {
            throw new IllegalArgumentException("Path " + String.valueOf(p_249112_.toAbsolutePath()) + " is not directory");
        }
        return true;
    }

    private void pushRootPath(Path p_251084_) {
        if (this.validateDirPath(p_251084_)) {
            this.rootPaths.add(p_251084_);
        }
    }

    private void pushPathForType(PackType p_250073_, Path p_252259_) {
        if (this.validateDirPath(p_252259_)) {
            this.pathsForType.computeIfAbsent(p_250073_, p_250639_ -> new LinkedHashSet()).add(p_252259_);
        }
    }

    public VanillaPackResourcesBuilder pushJarResources() {
        ROOT_DIR_BY_TYPE.forEach((p_251514_, p_251979_) -> {
            this.pushRootPath(p_251979_.getParent());
            this.pushPathForType((PackType)((Object)p_251514_), (Path)p_251979_);
        });
        return this;
    }

    public VanillaPackResourcesBuilder pushClasspathResources(PackType p_251987_, Class<?> p_249062_) {
        Enumeration<URL> enumeration = null;
        try {
            enumeration = p_249062_.getClassLoader().getResources(p_251987_.getDirectory() + "/");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        while (enumeration != null && enumeration.hasMoreElements()) {
            URL url = enumeration.nextElement();
            try {
                URI uri = url.toURI();
                if (!"file".equals(uri.getScheme())) continue;
                Path path = Paths.get(uri);
                this.pushRootPath(path.getParent());
                this.pushPathForType(p_251987_, path);
            }
            catch (Exception exception) {
                LOGGER.error("Failed to extract path from {}", (Object)url, (Object)exception);
            }
        }
        return this;
    }

    public VanillaPackResourcesBuilder applyDevelopmentConfig() {
        developmentConfig.accept(this);
        return this;
    }

    public VanillaPackResourcesBuilder pushUniversalPath(Path p_249464_) {
        this.pushRootPath(p_249464_);
        for (PackType packtype : PackType.values()) {
            this.pushPathForType(packtype, p_249464_.resolve(packtype.getDirectory()));
        }
        return this;
    }

    public VanillaPackResourcesBuilder pushAssetPath(PackType p_248623_, Path p_250065_) {
        this.pushRootPath(p_250065_);
        this.pushPathForType(p_248623_, p_250065_);
        return this;
    }

    public VanillaPackResourcesBuilder setMetadata(BuiltInMetadata p_249597_) {
        this.metadata = p_249597_;
        return this;
    }

    public VanillaPackResourcesBuilder exposeNamespace(String ... p_250838_) {
        this.namespaces.addAll(Arrays.asList(p_250838_));
        return this;
    }

    public VanillaPackResources build() {
        EnumMap<PackType, List<Path>> map = new EnumMap<PackType, List<Path>>(PackType.class);
        for (PackType packtype : PackType.values()) {
            List<Path> list = VanillaPackResourcesBuilder.copyAndReverse(this.pathsForType.getOrDefault((Object)packtype, Set.of()));
            map.put(packtype, list);
        }
        return new VanillaPackResources(this.metadata, Set.copyOf(this.namespaces), VanillaPackResourcesBuilder.copyAndReverse(this.rootPaths), map);
    }

    private static List<Path> copyAndReverse(Collection<Path> p_252072_) {
        ArrayList<Path> list = new ArrayList<Path>(p_252072_);
        Collections.reverse(list);
        return List.copyOf(list);
    }
}

