/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.level;

import net.minecraft.server.level.FullChunkStatus;
import net.minecraft.world.level.chunk.ChunkStatus;

public class ChunkLevel {
    private static final int FULL_CHUNK_LEVEL = 33;
    private static final int BLOCK_TICKING_LEVEL = 32;
    private static final int ENTITY_TICKING_LEVEL = 31;
    public static final int MAX_LEVEL = 33 + ChunkStatus.maxDistance();

    public static ChunkStatus generationStatus(int p_287738_) {
        return p_287738_ < 33 ? ChunkStatus.FULL : ChunkStatus.getStatusAroundFullChunk(p_287738_ - 33);
    }

    public static int byStatus(ChunkStatus p_287771_) {
        return 33 + ChunkStatus.getDistance(p_287771_);
    }

    public static FullChunkStatus fullStatus(int p_287750_) {
        if (p_287750_ <= 31) {
            return FullChunkStatus.ENTITY_TICKING;
        }
        if (p_287750_ <= 32) {
            return FullChunkStatus.BLOCK_TICKING;
        }
        return p_287750_ <= 33 ? FullChunkStatus.FULL : FullChunkStatus.INACCESSIBLE;
    }

    public static int byStatus(FullChunkStatus p_287601_) {
        return switch (p_287601_) {
            case FullChunkStatus.INACCESSIBLE -> MAX_LEVEL;
            case FullChunkStatus.FULL -> 33;
            case FullChunkStatus.BLOCK_TICKING -> 32;
            case FullChunkStatus.ENTITY_TICKING -> 31;
            default -> throw new IncompatibleClassChangeError();
        };
    }

    public static boolean isEntityTicking(int p_287767_) {
        return p_287767_ <= 31;
    }

    public static boolean isBlockTicking(int p_287696_) {
        return p_287696_ <= 32;
    }

    public static boolean isLoaded(int p_287635_) {
        return p_287635_ <= MAX_LEVEL;
    }
}

