/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.logging.LogUtils;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.Locale;
import net.minecraft.Util;
import net.minecraft.commands.CommandFunction;
import net.minecraft.commands.CommandSource;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.item.FunctionArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.ServerFunctionManager;
import net.minecraft.server.commands.FunctionCommand;
import net.minecraft.util.TimeUtil;
import net.minecraft.util.profiling.ProfileResults;
import org.slf4j.Logger;

public class DebugCommand {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final SimpleCommandExceptionType ERROR_NOT_RUNNING = new SimpleCommandExceptionType((Message)Component.translatable("commands.debug.notRunning"));
    private static final SimpleCommandExceptionType ERROR_ALREADY_RUNNING = new SimpleCommandExceptionType((Message)Component.translatable("commands.debug.alreadyRunning"));

    public static void register(CommandDispatcher<CommandSourceStack> p_136906_) {
        p_136906_.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal("debug").requires(p_180073_ -> p_180073_.hasPermission(3))).then(Commands.literal("start").executes(p_180069_ -> DebugCommand.start((CommandSourceStack)p_180069_.getSource())))).then(Commands.literal("stop").executes(p_136918_ -> DebugCommand.stop((CommandSourceStack)p_136918_.getSource())))).then(((LiteralArgumentBuilder)Commands.literal("function").requires(p_180071_ -> p_180071_.hasPermission(3))).then(Commands.argument("name", FunctionArgument.functions()).suggests(FunctionCommand.SUGGEST_FUNCTION).executes(p_136908_ -> DebugCommand.traceFunction((CommandSourceStack)p_136908_.getSource(), FunctionArgument.getFunctions((CommandContext<CommandSourceStack>)p_136908_, "name"))))));
    }

    private static int start(CommandSourceStack p_136910_) throws CommandSyntaxException {
        MinecraftServer minecraftserver = p_136910_.getServer();
        if (minecraftserver.isTimeProfilerRunning()) {
            throw ERROR_ALREADY_RUNNING.create();
        }
        minecraftserver.startTimeProfiler();
        p_136910_.sendSuccess(() -> Component.translatable("commands.debug.started"), true);
        return 0;
    }

    private static int stop(CommandSourceStack p_136916_) throws CommandSyntaxException {
        MinecraftServer minecraftserver = p_136916_.getServer();
        if (!minecraftserver.isTimeProfilerRunning()) {
            throw ERROR_NOT_RUNNING.create();
        }
        ProfileResults profileresults = minecraftserver.stopTimeProfiler();
        double d0 = (double)profileresults.getNanoDuration() / (double)TimeUtil.NANOSECONDS_PER_SECOND;
        double d1 = (double)profileresults.getTickDuration() / d0;
        p_136916_.sendSuccess(() -> Component.translatable("commands.debug.stopped", String.format(Locale.ROOT, "%.2f", d0), profileresults.getTickDuration(), String.format(Locale.ROOT, "%.2f", d1)), true);
        return (int)d1;
    }

    private static int traceFunction(CommandSourceStack p_180066_, Collection<CommandFunction> p_180067_) {
        int i = 0;
        MinecraftServer minecraftserver = p_180066_.getServer();
        String s = "debug-trace-" + Util.getFilenameFormattedDateTime() + ".txt";
        try {
            Path path = minecraftserver.getFile("debug").toPath();
            Files.createDirectories(path, new FileAttribute[0]);
            try (BufferedWriter writer = Files.newBufferedWriter(path.resolve(s), StandardCharsets.UTF_8, new OpenOption[0]);){
                PrintWriter printwriter = new PrintWriter(writer);
                for (CommandFunction commandfunction : p_180067_) {
                    printwriter.println(commandfunction.getId());
                    Tracer debugcommand$tracer = new Tracer(printwriter);
                    i += p_180066_.getServer().getFunctions().execute(commandfunction, p_180066_.withSource(debugcommand$tracer).withMaximumPermission(2), debugcommand$tracer);
                }
            }
        }
        catch (IOException | UncheckedIOException uncheckedioexception) {
            LOGGER.warn("Tracing failed", (Throwable)uncheckedioexception);
            p_180066_.sendFailure(Component.translatable("commands.debug.function.traceFailed"));
        }
        int j = i;
        if (p_180067_.size() == 1) {
            p_180066_.sendSuccess(() -> Component.translatable("commands.debug.function.success.single", j, ((CommandFunction)p_180067_.iterator().next()).getId(), s), true);
        } else {
            p_180066_.sendSuccess(() -> Component.translatable("commands.debug.function.success.multiple", j, p_180067_.size(), s), true);
        }
        return i;
    }

    static class Tracer
    implements ServerFunctionManager.TraceCallbacks,
    CommandSource {
        public static final int INDENT_OFFSET = 1;
        private final PrintWriter output;
        private int lastIndent;
        private boolean waitingForResult;

        Tracer(PrintWriter p_180079_) {
            this.output = p_180079_;
        }

        private void indentAndSave(int p_180082_) {
            this.printIndent(p_180082_);
            this.lastIndent = p_180082_;
        }

        private void printIndent(int p_180098_) {
            for (int i = 0; i < p_180098_ + 1; ++i) {
                this.output.write("    ");
            }
        }

        private void newLine() {
            if (this.waitingForResult) {
                this.output.println();
                this.waitingForResult = false;
            }
        }

        @Override
        public void onCommand(int p_180084_, String p_180085_) {
            this.newLine();
            this.indentAndSave(p_180084_);
            this.output.print("[C] ");
            this.output.print(p_180085_);
            this.waitingForResult = true;
        }

        @Override
        public void onReturn(int p_180087_, String p_180088_, int p_180089_) {
            if (this.waitingForResult) {
                this.output.print(" -> ");
                this.output.println(p_180089_);
                this.waitingForResult = false;
            } else {
                this.indentAndSave(p_180087_);
                this.output.print("[R = ");
                this.output.print(p_180089_);
                this.output.print("] ");
                this.output.println(p_180088_);
            }
        }

        @Override
        public void onCall(int p_180091_, ResourceLocation p_180092_, int p_180093_) {
            this.newLine();
            this.indentAndSave(p_180091_);
            this.output.print("[F] ");
            this.output.print(p_180092_);
            this.output.print(" size=");
            this.output.println(p_180093_);
        }

        @Override
        public void onError(int p_180100_, String p_180101_) {
            this.newLine();
            this.indentAndSave(p_180100_ + 1);
            this.output.print("[E] ");
            this.output.print(p_180101_);
        }

        @Override
        public void sendSystemMessage(Component p_214427_) {
            this.newLine();
            this.printIndent(this.lastIndent + 1);
            this.output.print("[M] ");
            this.output.println(p_214427_.getString());
        }

        @Override
        public boolean acceptsSuccess() {
            return true;
        }

        @Override
        public boolean acceptsFailure() {
            return true;
        }

        @Override
        public boolean shouldInformAdmins() {
            return false;
        }

        @Override
        public boolean alwaysAccepts() {
            return true;
        }
    }
}

