/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.advancements;

import it.unimi.dsi.fastutil.Stack;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.function.Predicate;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.DisplayInfo;

public class AdvancementVisibilityEvaluator {
    private static final int VISIBILITY_DEPTH = 2;

    private static VisibilityRule evaluateVisibilityRule(Advancement p_265736_, boolean p_265426_) {
        DisplayInfo displayinfo = p_265736_.getDisplay();
        if (displayinfo == null) {
            return VisibilityRule.HIDE;
        }
        if (p_265426_) {
            return VisibilityRule.SHOW;
        }
        return displayinfo.isHidden() ? VisibilityRule.HIDE : VisibilityRule.NO_CHANGE;
    }

    private static boolean evaluateVisiblityForUnfinishedNode(Stack<VisibilityRule> p_265343_) {
        for (int i = 0; i <= 2; ++i) {
            VisibilityRule advancementvisibilityevaluator$visibilityrule = (VisibilityRule)((Object)p_265343_.peek(i));
            if (advancementvisibilityevaluator$visibilityrule == VisibilityRule.SHOW) {
                return true;
            }
            if (advancementvisibilityevaluator$visibilityrule != VisibilityRule.HIDE) continue;
            return false;
        }
        return false;
    }

    private static boolean evaluateVisibility(Advancement p_265202_, Stack<VisibilityRule> p_265086_, Predicate<Advancement> p_265561_, Output p_265381_) {
        boolean flag = p_265561_.test(p_265202_);
        VisibilityRule advancementvisibilityevaluator$visibilityrule = AdvancementVisibilityEvaluator.evaluateVisibilityRule(p_265202_, flag);
        boolean flag1 = flag;
        p_265086_.push((Object)advancementvisibilityevaluator$visibilityrule);
        for (Advancement advancement : p_265202_.getChildren()) {
            flag1 |= AdvancementVisibilityEvaluator.evaluateVisibility(advancement, p_265086_, p_265561_, p_265381_);
        }
        boolean flag2 = flag1 || AdvancementVisibilityEvaluator.evaluateVisiblityForUnfinishedNode(p_265086_);
        p_265086_.pop();
        p_265381_.accept(p_265202_, flag2);
        return flag1;
    }

    public static void evaluateVisibility(Advancement p_265578_, Predicate<Advancement> p_265359_, Output p_265303_) {
        Advancement advancement = p_265578_.getRoot();
        ObjectArrayList stack = new ObjectArrayList();
        for (int i = 0; i <= 2; ++i) {
            stack.push((Object)VisibilityRule.NO_CHANGE);
        }
        AdvancementVisibilityEvaluator.evaluateVisibility(advancement, (Stack<VisibilityRule>)stack, p_265359_, p_265303_);
    }

    public static boolean isVisible(Advancement advancement, Predicate<Advancement> test) {
        ObjectArrayList stack = new ObjectArrayList();
        for (int i = 0; i <= 2; ++i) {
            stack.push((Object)VisibilityRule.NO_CHANGE);
        }
        return AdvancementVisibilityEvaluator.evaluateVisibility(advancement.getRoot(), (Stack<VisibilityRule>)stack, test, (p_265639_, p_265580_) -> {});
    }

    static enum VisibilityRule {
        SHOW,
        HIDE,
        NO_CHANGE;

    }

    @FunctionalInterface
    public static interface Output {
        public void accept(Advancement var1, boolean var2);
    }
}

