/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.protocol.game;

import com.google.common.collect.Queues;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.tree.ArgumentCommandNode;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import com.mojang.brigadier.tree.RootCommandNode;
import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.ints.IntSets;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntMaps;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayDeque;
import java.util.List;
import java.util.function.BiPredicate;
import javax.annotation.Nullable;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.synchronization.ArgumentTypeInfo;
import net.minecraft.commands.synchronization.ArgumentTypeInfos;
import net.minecraft.commands.synchronization.SuggestionProviders;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.resources.ResourceLocation;

public class ClientboundCommandsPacket
implements Packet<ClientGamePacketListener> {
    private static final byte MASK_TYPE = 3;
    private static final byte FLAG_EXECUTABLE = 4;
    private static final byte FLAG_REDIRECT = 8;
    private static final byte FLAG_CUSTOM_SUGGESTIONS = 16;
    private static final byte TYPE_ROOT = 0;
    private static final byte TYPE_LITERAL = 1;
    private static final byte TYPE_ARGUMENT = 2;
    private final int rootIndex;
    private final List<Entry> entries;

    public ClientboundCommandsPacket(RootCommandNode<SharedSuggestionProvider> p_131861_) {
        Object2IntMap<CommandNode<SharedSuggestionProvider>> object2intmap = ClientboundCommandsPacket.enumerateNodes(p_131861_);
        this.entries = ClientboundCommandsPacket.createEntries(object2intmap);
        this.rootIndex = object2intmap.getInt(p_131861_);
    }

    public ClientboundCommandsPacket(FriendlyByteBuf p_178805_) {
        this.entries = p_178805_.readList(ClientboundCommandsPacket::readNode);
        this.rootIndex = p_178805_.readVarInt();
        ClientboundCommandsPacket.validateEntries(this.entries);
    }

    @Override
    public void write(FriendlyByteBuf p_131886_) {
        p_131886_.writeCollection(this.entries, (p_237642_, p_237643_) -> p_237643_.write((FriendlyByteBuf)p_237642_));
        p_131886_.writeVarInt(this.rootIndex);
    }

    private static void validateEntries(List<Entry> p_237631_, BiPredicate<Entry, IntSet> p_237632_) {
        IntOpenHashSet intset = new IntOpenHashSet((IntCollection)IntSets.fromTo((int)0, (int)p_237631_.size()));
        while (!intset.isEmpty()) {
            boolean flag = intset.removeIf(arg_0 -> ClientboundCommandsPacket.lambda$validateEntries$1(p_237632_, p_237631_, (IntSet)intset, arg_0));
            if (flag) continue;
            throw new IllegalStateException("Server sent an impossible command tree");
        }
    }

    private static void validateEntries(List<Entry> p_237629_) {
        ClientboundCommandsPacket.validateEntries(p_237629_, Entry::canBuild);
        ClientboundCommandsPacket.validateEntries(p_237629_, Entry::canResolve);
    }

    private static Object2IntMap<CommandNode<SharedSuggestionProvider>> enumerateNodes(RootCommandNode<SharedSuggestionProvider> p_131863_) {
        CommandNode commandnode;
        Object2IntOpenHashMap object2intmap = new Object2IntOpenHashMap();
        ArrayDeque queue = Queues.newArrayDeque();
        queue.add(p_131863_);
        while ((commandnode = (CommandNode)queue.poll()) != null) {
            if (object2intmap.containsKey((Object)commandnode)) continue;
            int i = object2intmap.size();
            object2intmap.put((Object)commandnode, i);
            queue.addAll(commandnode.getChildren());
            if (commandnode.getRedirect() == null) continue;
            queue.add(commandnode.getRedirect());
        }
        return object2intmap;
    }

    private static List<Entry> createEntries(Object2IntMap<CommandNode<SharedSuggestionProvider>> p_237627_) {
        ObjectArrayList objectarraylist = new ObjectArrayList(p_237627_.size());
        objectarraylist.size(p_237627_.size());
        for (Object2IntMap.Entry entry : Object2IntMaps.fastIterable(p_237627_)) {
            objectarraylist.set(entry.getIntValue(), (Object)ClientboundCommandsPacket.createEntry((CommandNode<SharedSuggestionProvider>)((CommandNode)entry.getKey()), p_237627_));
        }
        return objectarraylist;
    }

    private static Entry readNode(FriendlyByteBuf p_131888_) {
        byte b0 = p_131888_.readByte();
        int[] aint = p_131888_.readVarIntArray();
        int i = (b0 & 8) != 0 ? p_131888_.readVarInt() : 0;
        NodeStub clientboundcommandspacket$nodestub = ClientboundCommandsPacket.read(p_131888_, b0);
        return new Entry(clientboundcommandspacket$nodestub, b0, i, aint);
    }

    @Nullable
    private static NodeStub read(FriendlyByteBuf p_237639_, byte p_237640_) {
        int i = p_237640_ & 3;
        if (i == 2) {
            String s1 = p_237639_.readUtf();
            int j = p_237639_.readVarInt();
            ArgumentTypeInfo argumenttypeinfo = (ArgumentTypeInfo)BuiltInRegistries.COMMAND_ARGUMENT_TYPE.byId(j);
            if (argumenttypeinfo == null) {
                return null;
            }
            Object template = argumenttypeinfo.deserializeFromNetwork(p_237639_);
            ResourceLocation resourcelocation = (p_237640_ & 0x10) != 0 ? p_237639_.readResourceLocation() : null;
            return new ArgumentNodeStub(s1, (ArgumentTypeInfo.Template<?>)template, resourcelocation);
        }
        if (i == 1) {
            String s = p_237639_.readUtf();
            return new LiteralNodeStub(s);
        }
        return null;
    }

    private static Entry createEntry(CommandNode<SharedSuggestionProvider> p_237622_, Object2IntMap<CommandNode<SharedSuggestionProvider>> p_237623_) {
        NodeStub clientboundcommandspacket$nodestub;
        int j;
        int i = 0;
        if (p_237622_.getRedirect() != null) {
            i |= 8;
            j = p_237623_.getInt((Object)p_237622_.getRedirect());
        } else {
            j = 0;
        }
        if (p_237622_.getCommand() != null) {
            i |= 4;
        }
        if (p_237622_ instanceof RootCommandNode) {
            i |= 0;
            clientboundcommandspacket$nodestub = null;
        } else if (p_237622_ instanceof ArgumentCommandNode) {
            ArgumentCommandNode argumentcommandnode = (ArgumentCommandNode)p_237622_;
            clientboundcommandspacket$nodestub = new ArgumentNodeStub(argumentcommandnode);
            i |= 2;
            if (argumentcommandnode.getCustomSuggestions() != null) {
                i |= 0x10;
            }
        } else {
            if (!(p_237622_ instanceof LiteralCommandNode)) {
                throw new UnsupportedOperationException("Unknown node type " + String.valueOf(p_237622_));
            }
            LiteralCommandNode literalcommandnode = (LiteralCommandNode)p_237622_;
            clientboundcommandspacket$nodestub = new LiteralNodeStub(literalcommandnode.getLiteral());
            i |= 1;
        }
        int[] aint = p_237622_.getChildren().stream().mapToInt(arg_0 -> p_237623_.getInt(arg_0)).toArray();
        return new Entry(clientboundcommandspacket$nodestub, i, j, aint);
    }

    @Override
    public void handle(ClientGamePacketListener p_131878_) {
        p_131878_.handleCommands(this);
    }

    public RootCommandNode<SharedSuggestionProvider> getRoot(CommandBuildContext p_237625_) {
        return (RootCommandNode)new NodeResolver(p_237625_, this.entries).resolve(this.rootIndex);
    }

    private static /* synthetic */ boolean lambda$validateEntries$1(BiPredicate p_237632_, List p_237631_, IntSet intset, int p_237637_) {
        return p_237632_.test((Entry)p_237631_.get(p_237637_), intset);
    }

    static class Entry {
        @Nullable
        final NodeStub stub;
        final int flags;
        final int redirect;
        final int[] children;

        Entry(@Nullable NodeStub p_237668_, int p_237669_, int p_237670_, int[] p_237671_) {
            this.stub = p_237668_;
            this.flags = p_237669_;
            this.redirect = p_237670_;
            this.children = p_237671_;
        }

        public void write(FriendlyByteBuf p_237675_) {
            p_237675_.writeByte(this.flags);
            p_237675_.writeVarIntArray(this.children);
            if ((this.flags & 8) != 0) {
                p_237675_.writeVarInt(this.redirect);
            }
            if (this.stub != null) {
                this.stub.write(p_237675_);
            }
        }

        public boolean canBuild(IntSet p_237673_) {
            if ((this.flags & 8) != 0) {
                return !p_237673_.contains(this.redirect);
            }
            return true;
        }

        public boolean canResolve(IntSet p_237677_) {
            for (int i : this.children) {
                if (!p_237677_.contains(i)) continue;
                return false;
            }
            return true;
        }
    }

    static interface NodeStub {
        public ArgumentBuilder<SharedSuggestionProvider, ?> build(CommandBuildContext var1);

        public void write(FriendlyByteBuf var1);
    }

    static class ArgumentNodeStub
    implements NodeStub {
        private final String id;
        private final ArgumentTypeInfo.Template<?> argumentType;
        @Nullable
        private final ResourceLocation suggestionId;

        @Nullable
        private static ResourceLocation getSuggestionId(@Nullable SuggestionProvider<SharedSuggestionProvider> p_237654_) {
            return p_237654_ != null ? SuggestionProviders.getName(p_237654_) : null;
        }

        ArgumentNodeStub(String p_237650_, ArgumentTypeInfo.Template<?> p_237651_, @Nullable ResourceLocation p_237652_) {
            this.id = p_237650_;
            this.argumentType = p_237651_;
            this.suggestionId = p_237652_;
        }

        public ArgumentNodeStub(ArgumentCommandNode<SharedSuggestionProvider, ?> p_237648_) {
            this(p_237648_.getName(), ArgumentTypeInfos.unpack(p_237648_.getType()), ArgumentNodeStub.getSuggestionId((SuggestionProvider<SharedSuggestionProvider>)p_237648_.getCustomSuggestions()));
        }

        @Override
        public ArgumentBuilder<SharedSuggestionProvider, ?> build(CommandBuildContext p_237656_) {
            Object argumenttype = this.argumentType.instantiate(p_237656_);
            RequiredArgumentBuilder requiredargumentbuilder = RequiredArgumentBuilder.argument((String)this.id, argumenttype);
            if (this.suggestionId != null) {
                requiredargumentbuilder.suggests(SuggestionProviders.getProvider(this.suggestionId));
            }
            return requiredargumentbuilder;
        }

        @Override
        public void write(FriendlyByteBuf p_237658_) {
            p_237658_.writeUtf(this.id);
            ArgumentNodeStub.serializeCap(p_237658_, this.argumentType);
            if (this.suggestionId != null) {
                p_237658_.writeResourceLocation(this.suggestionId);
            }
        }

        private static <A extends ArgumentType<?>> void serializeCap(FriendlyByteBuf p_237660_, ArgumentTypeInfo.Template<A> p_237661_) {
            ArgumentNodeStub.serializeCap(p_237660_, p_237661_.type(), p_237661_);
        }

        private static <A extends ArgumentType<?>, T extends ArgumentTypeInfo.Template<A>> void serializeCap(FriendlyByteBuf p_237663_, ArgumentTypeInfo<A, T> p_237664_, ArgumentTypeInfo.Template<A> p_237665_) {
            p_237663_.writeVarInt(BuiltInRegistries.COMMAND_ARGUMENT_TYPE.getId(p_237664_));
            p_237664_.serializeToNetwork(p_237665_, p_237663_);
        }
    }

    static class LiteralNodeStub
    implements NodeStub {
        private final String id;

        LiteralNodeStub(String p_237680_) {
            this.id = p_237680_;
        }

        @Override
        public ArgumentBuilder<SharedSuggestionProvider, ?> build(CommandBuildContext p_237682_) {
            return LiteralArgumentBuilder.literal((String)this.id);
        }

        @Override
        public void write(FriendlyByteBuf p_237684_) {
            p_237684_.writeUtf(this.id);
        }
    }

    static class NodeResolver {
        private final CommandBuildContext context;
        private final List<Entry> entries;
        private final List<CommandNode<SharedSuggestionProvider>> nodes;

        NodeResolver(CommandBuildContext p_237689_, List<Entry> p_237690_) {
            this.context = p_237689_;
            this.entries = p_237690_;
            ObjectArrayList objectarraylist = new ObjectArrayList();
            objectarraylist.size(p_237690_.size());
            this.nodes = objectarraylist;
        }

        public CommandNode<SharedSuggestionProvider> resolve(int p_237692_) {
            RootCommandNode commandnode1;
            CommandNode<SharedSuggestionProvider> commandnode = this.nodes.get(p_237692_);
            if (commandnode != null) {
                return commandnode;
            }
            Entry clientboundcommandspacket$entry = this.entries.get(p_237692_);
            if (clientboundcommandspacket$entry.stub == null) {
                commandnode1 = new RootCommandNode();
            } else {
                ArgumentBuilder<SharedSuggestionProvider, ?> argumentbuilder = clientboundcommandspacket$entry.stub.build(this.context);
                if ((clientboundcommandspacket$entry.flags & 8) != 0) {
                    argumentbuilder.redirect(this.resolve(clientboundcommandspacket$entry.redirect));
                }
                if ((clientboundcommandspacket$entry.flags & 4) != 0) {
                    argumentbuilder.executes(p_237694_ -> 0);
                }
                commandnode1 = argumentbuilder.build();
            }
            this.nodes.set(p_237692_, (CommandNode<SharedSuggestionProvider>)commandnode1);
            for (int i : clientboundcommandspacket$entry.children) {
                CommandNode<SharedSuggestionProvider> commandnode2 = this.resolve(i);
                if (commandnode2 instanceof RootCommandNode) continue;
                commandnode1.addChild(commandnode2);
            }
            return commandnode1;
        }
    }
}

