/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.nbt;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.bytes.ByteCollection;
import it.unimi.dsi.fastutil.bytes.ByteOpenHashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.regex.Pattern;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.ByteArrayTag;
import net.minecraft.nbt.ByteTag;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.DoubleTag;
import net.minecraft.nbt.EndTag;
import net.minecraft.nbt.FloatTag;
import net.minecraft.nbt.IntArrayTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.LongArrayTag;
import net.minecraft.nbt.LongTag;
import net.minecraft.nbt.ShortTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.nbt.TagVisitor;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import org.slf4j.Logger;

public class TextComponentTagVisitor
implements TagVisitor {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final int INLINE_LIST_THRESHOLD = 8;
    private static final ByteCollection INLINE_ELEMENT_TYPES = new ByteOpenHashSet(Arrays.asList((byte)1, (byte)2, (byte)3, (byte)4, (byte)5, (byte)6));
    private static final ChatFormatting SYNTAX_HIGHLIGHTING_KEY = ChatFormatting.AQUA;
    private static final ChatFormatting SYNTAX_HIGHLIGHTING_STRING = ChatFormatting.GREEN;
    private static final ChatFormatting SYNTAX_HIGHLIGHTING_NUMBER = ChatFormatting.GOLD;
    private static final ChatFormatting SYNTAX_HIGHLIGHTING_NUMBER_TYPE = ChatFormatting.RED;
    private static final Pattern SIMPLE_VALUE = Pattern.compile("[A-Za-z0-9._+-]+");
    private static final String NAME_VALUE_SEPARATOR = String.valueOf(':');
    private static final String ELEMENT_SEPARATOR = String.valueOf(',');
    private static final String LIST_OPEN = "[";
    private static final String LIST_CLOSE = "]";
    private static final String LIST_TYPE_SEPARATOR = ";";
    private static final String ELEMENT_SPACING = " ";
    private static final String STRUCT_OPEN = "{";
    private static final String STRUCT_CLOSE = "}";
    private static final String NEWLINE = "\n";
    private final String indentation;
    private final int depth;
    private Component result = CommonComponents.EMPTY;

    public TextComponentTagVisitor(String p_178251_, int p_178252_) {
        this.indentation = p_178251_;
        this.depth = p_178252_;
    }

    public Component visit(Tag p_178282_) {
        p_178282_.accept(this);
        return this.result;
    }

    @Override
    public void visitString(StringTag p_178280_) {
        String s = StringTag.quoteAndEscape(p_178280_.getAsString());
        String s1 = s.substring(0, 1);
        MutableComponent component = Component.literal(s.substring(1, s.length() - 1)).withStyle(SYNTAX_HIGHLIGHTING_STRING);
        this.result = Component.literal(s1).append(component).append(s1);
    }

    @Override
    public void visitByte(ByteTag p_178258_) {
        MutableComponent component = Component.literal("b").withStyle(SYNTAX_HIGHLIGHTING_NUMBER_TYPE);
        this.result = Component.literal(String.valueOf(p_178258_.getAsNumber())).append(component).withStyle(SYNTAX_HIGHLIGHTING_NUMBER);
    }

    @Override
    public void visitShort(ShortTag p_178278_) {
        MutableComponent component = Component.literal("s").withStyle(SYNTAX_HIGHLIGHTING_NUMBER_TYPE);
        this.result = Component.literal(String.valueOf(p_178278_.getAsNumber())).append(component).withStyle(SYNTAX_HIGHLIGHTING_NUMBER);
    }

    @Override
    public void visitInt(IntTag p_178270_) {
        this.result = Component.literal(String.valueOf(p_178270_.getAsNumber())).withStyle(SYNTAX_HIGHLIGHTING_NUMBER);
    }

    @Override
    public void visitLong(LongTag p_178276_) {
        MutableComponent component = Component.literal("L").withStyle(SYNTAX_HIGHLIGHTING_NUMBER_TYPE);
        this.result = Component.literal(String.valueOf(p_178276_.getAsNumber())).append(component).withStyle(SYNTAX_HIGHLIGHTING_NUMBER);
    }

    @Override
    public void visitFloat(FloatTag p_178266_) {
        MutableComponent component = Component.literal("f").withStyle(SYNTAX_HIGHLIGHTING_NUMBER_TYPE);
        this.result = Component.literal(String.valueOf(p_178266_.getAsFloat())).append(component).withStyle(SYNTAX_HIGHLIGHTING_NUMBER);
    }

    @Override
    public void visitDouble(DoubleTag p_178262_) {
        MutableComponent component = Component.literal("d").withStyle(SYNTAX_HIGHLIGHTING_NUMBER_TYPE);
        this.result = Component.literal(String.valueOf(p_178262_.getAsDouble())).append(component).withStyle(SYNTAX_HIGHLIGHTING_NUMBER);
    }

    @Override
    public void visitByteArray(ByteArrayTag p_178256_) {
        MutableComponent component = Component.literal("B").withStyle(SYNTAX_HIGHLIGHTING_NUMBER_TYPE);
        MutableComponent mutablecomponent = Component.literal(LIST_OPEN).append(component).append(LIST_TYPE_SEPARATOR);
        byte[] abyte = p_178256_.getAsByteArray();
        for (int i = 0; i < abyte.length; ++i) {
            MutableComponent mutablecomponent1 = Component.literal(String.valueOf(abyte[i])).withStyle(SYNTAX_HIGHLIGHTING_NUMBER);
            mutablecomponent.append(ELEMENT_SPACING).append(mutablecomponent1).append(component);
            if (i == abyte.length - 1) continue;
            mutablecomponent.append(ELEMENT_SEPARATOR);
        }
        mutablecomponent.append(LIST_CLOSE);
        this.result = mutablecomponent;
    }

    @Override
    public void visitIntArray(IntArrayTag p_178268_) {
        MutableComponent component = Component.literal("I").withStyle(SYNTAX_HIGHLIGHTING_NUMBER_TYPE);
        MutableComponent mutablecomponent = Component.literal(LIST_OPEN).append(component).append(LIST_TYPE_SEPARATOR);
        int[] aint = p_178268_.getAsIntArray();
        for (int i = 0; i < aint.length; ++i) {
            mutablecomponent.append(ELEMENT_SPACING).append(Component.literal(String.valueOf(aint[i])).withStyle(SYNTAX_HIGHLIGHTING_NUMBER));
            if (i == aint.length - 1) continue;
            mutablecomponent.append(ELEMENT_SEPARATOR);
        }
        mutablecomponent.append(LIST_CLOSE);
        this.result = mutablecomponent;
    }

    @Override
    public void visitLongArray(LongArrayTag p_178274_) {
        MutableComponent component = Component.literal("L").withStyle(SYNTAX_HIGHLIGHTING_NUMBER_TYPE);
        MutableComponent mutablecomponent = Component.literal(LIST_OPEN).append(component).append(LIST_TYPE_SEPARATOR);
        long[] along = p_178274_.getAsLongArray();
        for (int i = 0; i < along.length; ++i) {
            MutableComponent component1 = Component.literal(String.valueOf(along[i])).withStyle(SYNTAX_HIGHLIGHTING_NUMBER);
            mutablecomponent.append(ELEMENT_SPACING).append(component1).append(component);
            if (i == along.length - 1) continue;
            mutablecomponent.append(ELEMENT_SEPARATOR);
        }
        mutablecomponent.append(LIST_CLOSE);
        this.result = mutablecomponent;
    }

    @Override
    public void visitList(ListTag p_178272_) {
        if (p_178272_.isEmpty()) {
            this.result = Component.literal("[]");
        } else if (INLINE_ELEMENT_TYPES.contains(p_178272_.getElementType()) && p_178272_.size() <= 8) {
            String s = ELEMENT_SEPARATOR + ELEMENT_SPACING;
            MutableComponent mutablecomponent2 = Component.literal(LIST_OPEN);
            for (int j = 0; j < p_178272_.size(); ++j) {
                if (j != 0) {
                    mutablecomponent2.append(s);
                }
                mutablecomponent2.append(new TextComponentTagVisitor(this.indentation, this.depth).visit(p_178272_.get(j)));
            }
            mutablecomponent2.append(LIST_CLOSE);
            this.result = mutablecomponent2;
        } else {
            MutableComponent mutablecomponent = Component.literal(LIST_OPEN);
            if (!this.indentation.isEmpty()) {
                mutablecomponent.append(NEWLINE);
            }
            for (int i = 0; i < p_178272_.size(); ++i) {
                MutableComponent mutablecomponent1 = Component.literal(Strings.repeat((String)this.indentation, (int)(this.depth + 1)));
                mutablecomponent1.append(new TextComponentTagVisitor(this.indentation, this.depth + 1).visit(p_178272_.get(i)));
                if (i != p_178272_.size() - 1) {
                    mutablecomponent1.append(ELEMENT_SEPARATOR).append(this.indentation.isEmpty() ? ELEMENT_SPACING : NEWLINE);
                }
                mutablecomponent.append(mutablecomponent1);
            }
            if (!this.indentation.isEmpty()) {
                mutablecomponent.append(NEWLINE).append(Strings.repeat((String)this.indentation, (int)this.depth));
            }
            mutablecomponent.append(LIST_CLOSE);
            this.result = mutablecomponent;
        }
    }

    @Override
    public void visitCompound(CompoundTag p_178260_) {
        if (p_178260_.isEmpty()) {
            this.result = Component.literal("{}");
        } else {
            MutableComponent mutablecomponent = Component.literal(STRUCT_OPEN);
            Collection<String> collection = p_178260_.getAllKeys();
            if (LOGGER.isDebugEnabled()) {
                ArrayList list = Lists.newArrayList(p_178260_.getAllKeys());
                Collections.sort(list);
                collection = list;
            }
            if (!this.indentation.isEmpty()) {
                mutablecomponent.append(NEWLINE);
            }
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                String s = (String)iterator.next();
                MutableComponent mutablecomponent1 = Component.literal(Strings.repeat((String)this.indentation, (int)(this.depth + 1))).append(TextComponentTagVisitor.handleEscapePretty(s)).append(NAME_VALUE_SEPARATOR).append(ELEMENT_SPACING).append(new TextComponentTagVisitor(this.indentation, this.depth + 1).visit(p_178260_.get(s)));
                if (iterator.hasNext()) {
                    mutablecomponent1.append(ELEMENT_SEPARATOR).append(this.indentation.isEmpty() ? ELEMENT_SPACING : NEWLINE);
                }
                mutablecomponent.append(mutablecomponent1);
            }
            if (!this.indentation.isEmpty()) {
                mutablecomponent.append(NEWLINE).append(Strings.repeat((String)this.indentation, (int)this.depth));
            }
            mutablecomponent.append(STRUCT_CLOSE);
            this.result = mutablecomponent;
        }
    }

    protected static Component handleEscapePretty(String p_178254_) {
        if (SIMPLE_VALUE.matcher(p_178254_).matches()) {
            return Component.literal(p_178254_).withStyle(SYNTAX_HIGHLIGHTING_KEY);
        }
        String s = StringTag.quoteAndEscape(p_178254_);
        String s1 = s.substring(0, 1);
        MutableComponent component = Component.literal(s.substring(1, s.length() - 1)).withStyle(SYNTAX_HIGHLIGHTING_KEY);
        return Component.literal(s1).append(component).append(s1);
    }

    @Override
    public void visitEnd(EndTag p_178264_) {
        this.result = CommonComponents.EMPTY;
    }
}

