/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.nbt;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import net.minecraft.nbt.ByteTag;
import net.minecraft.nbt.CollectionTag;
import net.minecraft.nbt.NbtAccounter;
import net.minecraft.nbt.NumericTag;
import net.minecraft.nbt.StreamTagVisitor;
import net.minecraft.nbt.Tag;
import net.minecraft.nbt.TagType;
import net.minecraft.nbt.TagVisitor;
import org.apache.commons.lang3.ArrayUtils;

public class ByteArrayTag
extends CollectionTag<ByteTag> {
    private static final int SELF_SIZE_IN_BYTES = 24;
    public static final TagType<ByteArrayTag> TYPE = new TagType.VariableSize<ByteArrayTag>(){

        @Override
        public ByteArrayTag load(DataInput p_128247_, int p_128248_, NbtAccounter p_128249_) throws IOException {
            p_128249_.accountBytes(24L);
            int i = p_128247_.readInt();
            p_128249_.accountBytes(1L * (long)i);
            byte[] abyte = new byte[i];
            p_128247_.readFully(abyte);
            return new ByteArrayTag(abyte);
        }

        @Override
        public StreamTagVisitor.ValueResult parse(DataInput p_197433_, StreamTagVisitor p_197434_) throws IOException {
            int i = p_197433_.readInt();
            byte[] abyte = new byte[i];
            p_197433_.readFully(abyte);
            return p_197434_.visit(abyte);
        }

        @Override
        public void skip(DataInput p_197431_) throws IOException {
            p_197431_.skipBytes(p_197431_.readInt() * 1);
        }

        @Override
        public String getName() {
            return "BYTE[]";
        }

        @Override
        public String getPrettyName() {
            return "TAG_Byte_Array";
        }
    };
    private byte[] data;

    public ByteArrayTag(byte[] p_128191_) {
        this.data = p_128191_;
    }

    public ByteArrayTag(List<Byte> p_128189_) {
        this(ByteArrayTag.toArray(p_128189_));
    }

    private static byte[] toArray(List<Byte> p_128207_) {
        byte[] abyte = new byte[p_128207_.size()];
        for (int i = 0; i < p_128207_.size(); ++i) {
            Byte obyte = p_128207_.get(i);
            abyte[i] = obyte == null ? (byte)0 : obyte;
        }
        return abyte;
    }

    @Override
    public void write(DataOutput p_128202_) throws IOException {
        p_128202_.writeInt(this.data.length);
        p_128202_.write(this.data);
    }

    @Override
    public int sizeInBytes() {
        return 24 + 1 * this.data.length;
    }

    @Override
    public byte getId() {
        return 7;
    }

    public TagType<ByteArrayTag> getType() {
        return TYPE;
    }

    @Override
    public String toString() {
        return this.getAsString();
    }

    @Override
    public Tag copy() {
        byte[] abyte = new byte[this.data.length];
        System.arraycopy(this.data, 0, abyte, 0, this.data.length);
        return new ByteArrayTag(abyte);
    }

    @Override
    public boolean equals(Object p_128233_) {
        if (this == p_128233_) {
            return true;
        }
        return p_128233_ instanceof ByteArrayTag && Arrays.equals(this.data, ((ByteArrayTag)p_128233_).data);
    }

    @Override
    public int hashCode() {
        return Arrays.hashCode(this.data);
    }

    @Override
    public void accept(TagVisitor p_177839_) {
        p_177839_.visitByteArray(this);
    }

    public byte[] getAsByteArray() {
        return this.data;
    }

    @Override
    public int size() {
        return this.data.length;
    }

    @Override
    public ByteTag get(int p_128194_) {
        return ByteTag.valueOf(this.data[p_128194_]);
    }

    @Override
    public ByteTag set(int p_128196_, ByteTag p_128197_) {
        byte b0 = this.data[p_128196_];
        this.data[p_128196_] = p_128197_.getAsByte();
        return ByteTag.valueOf(b0);
    }

    @Override
    public void add(int p_128215_, ByteTag p_128216_) {
        this.data = ArrayUtils.add((byte[])this.data, (int)p_128215_, (byte)p_128216_.getAsByte());
    }

    @Override
    public boolean setTag(int p_128199_, Tag p_128200_) {
        if (p_128200_ instanceof NumericTag) {
            this.data[p_128199_] = ((NumericTag)p_128200_).getAsByte();
            return true;
        }
        return false;
    }

    @Override
    public boolean addTag(int p_128218_, Tag p_128219_) {
        if (p_128219_ instanceof NumericTag) {
            this.data = ArrayUtils.add((byte[])this.data, (int)p_128218_, (byte)((NumericTag)p_128219_).getAsByte());
            return true;
        }
        return false;
    }

    @Override
    public ByteTag remove(int p_128213_) {
        byte b0 = this.data[p_128213_];
        this.data = ArrayUtils.remove((byte[])this.data, (int)p_128213_);
        return ByteTag.valueOf(b0);
    }

    @Override
    public byte getElementType() {
        return 1;
    }

    @Override
    public void clear() {
        this.data = new byte[0];
    }

    @Override
    public StreamTagVisitor.ValueResult accept(StreamTagVisitor p_197429_) {
        return p_197429_.visit(this.data);
    }
}

