/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.data.worldgen;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.function.Function;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BastionBridgePools;
import net.minecraft.data.worldgen.BastionHoglinStablePools;
import net.minecraft.data.worldgen.BastionHousingUnitsPools;
import net.minecraft.data.worldgen.BastionSharedPools;
import net.minecraft.data.worldgen.BastionTreasureRoomPools;
import net.minecraft.data.worldgen.BootstapContext;
import net.minecraft.data.worldgen.Pools;
import net.minecraft.data.worldgen.ProcessorLists;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.levelgen.structure.pools.StructurePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorList;

public class BastionPieces {
    public static final ResourceKey<StructureTemplatePool> START = Pools.createKey("bastion/starts");

    public static void bootstrap(BootstapContext<StructureTemplatePool> p_256429_) {
        HolderGetter<StructureProcessorList> holdergetter = p_256429_.lookup(Registries.PROCESSOR_LIST);
        Holder.Reference<StructureProcessorList> holder = holdergetter.getOrThrow(ProcessorLists.BASTION_GENERIC_DEGRADATION);
        HolderGetter<StructureTemplatePool> holdergetter1 = p_256429_.lookup(Registries.TEMPLATE_POOL);
        Holder.Reference<StructureTemplatePool> holder1 = holdergetter1.getOrThrow(Pools.EMPTY);
        p_256429_.register(START, new StructureTemplatePool(holder1, (List<Pair<Function<StructureTemplatePool.Projection, ? extends StructurePoolElement>, Integer>>)ImmutableList.of((Object)Pair.of(StructurePoolElement.single("bastion/units/air_base", holder), (Object)1), (Object)Pair.of(StructurePoolElement.single("bastion/hoglin_stable/air_base", holder), (Object)1), (Object)Pair.of(StructurePoolElement.single("bastion/treasure/big_air_full", holder), (Object)1), (Object)Pair.of(StructurePoolElement.single("bastion/bridge/starting_pieces/entrance_base", holder), (Object)1)), StructureTemplatePool.Projection.RIGID));
        BastionHousingUnitsPools.bootstrap(p_256429_);
        BastionHoglinStablePools.bootstrap(p_256429_);
        BastionTreasureRoomPools.bootstrap(p_256429_);
        BastionBridgePools.bootstrap(p_256429_);
        BastionSharedPools.bootstrap(p_256429_);
    }
}

