/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.data.structures;

import com.google.common.hash.Hashing;
import com.google.common.hash.HashingOutputStream;
import com.mojang.logging.LogUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.nbt.NbtIo;
import net.minecraft.nbt.NbtUtils;
import org.slf4j.Logger;

public class NbtToSnbt
implements DataProvider {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final Iterable<Path> inputFolders;
    private final PackOutput output;

    public NbtToSnbt(PackOutput p_250442_, Collection<Path> p_249158_) {
        this.inputFolders = p_249158_;
        this.output = p_250442_;
    }

    @Override
    public CompletableFuture<?> run(CachedOutput p_254274_) {
        Path path = this.output.getOutputFolder();
        ArrayList<CompletionStage> list = new ArrayList<CompletionStage>();
        for (Path path1 : this.inputFolders) {
            list.add(CompletableFuture.supplyAsync(() -> {
                CompletableFuture<Void> completableFuture;
                block8: {
                    Stream<Path> stream = Files.walk(path1, new FileVisitOption[0]);
                    try {
                        completableFuture = CompletableFuture.allOf((CompletableFuture[])stream.filter(p_126430_ -> p_126430_.toString().endsWith(".nbt")).map(p_253418_ -> CompletableFuture.runAsync(() -> NbtToSnbt.convertStructure(p_254274_, p_253418_, NbtToSnbt.getName(path1, p_253418_), path), Util.ioPool())).toArray(CompletableFuture[]::new));
                        if (stream == null) break block8;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (stream != null) {
                                try {
                                    stream.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (IOException ioexception) {
                            LOGGER.error("Failed to read structure input directory", (Throwable)ioexception);
                            return CompletableFuture.completedFuture(null);
                        }
                    }
                    stream.close();
                }
                return completableFuture;
            }, Util.backgroundExecutor()).thenCompose(p_253420_ -> p_253420_));
        }
        return CompletableFuture.allOf((CompletableFuture[])list.toArray(CompletableFuture[]::new));
    }

    @Override
    public final String getName() {
        return "NBT -> SNBT";
    }

    private static String getName(Path p_126436_, Path p_126437_) {
        String s = p_126436_.relativize(p_126437_).toString().replaceAll("\\\\", "/");
        return s.substring(0, s.length() - ".nbt".length());
    }

    @Nullable
    public static Path convertStructure(CachedOutput p_236382_, Path p_236383_, String p_236384_, Path p_236385_) {
        Path path;
        block8: {
            InputStream inputstream = Files.newInputStream(p_236383_, new OpenOption[0]);
            try {
                Path path2 = p_236385_.resolve(p_236384_ + ".snbt");
                NbtToSnbt.writeSnbt(p_236382_, path2, NbtUtils.structureToSnbt(NbtIo.readCompressed(inputstream)));
                LOGGER.info("Converted {} from NBT to SNBT", (Object)p_236384_);
                path = path2;
                if (inputstream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (inputstream != null) {
                        try {
                            inputstream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException ioexception) {
                    LOGGER.error("Couldn't convert {} from NBT to SNBT at {}", new Object[]{p_236384_, p_236383_, ioexception});
                    return null;
                }
            }
            inputstream.close();
        }
        return path;
    }

    public static void writeSnbt(CachedOutput p_236378_, Path p_236379_, String p_236380_) throws IOException {
        ByteArrayOutputStream bytearrayoutputstream = new ByteArrayOutputStream();
        HashingOutputStream hashingoutputstream = new HashingOutputStream(Hashing.sha1(), (OutputStream)bytearrayoutputstream);
        hashingoutputstream.write(p_236380_.getBytes(StandardCharsets.UTF_8));
        hashingoutputstream.write(10);
        p_236378_.writeIfNeeded(p_236379_, bytearrayoutputstream.toByteArray(), hashingoutputstream.hash());
    }
}

