/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.registries;

import com.google.common.collect.Maps;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.Lifecycle;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.Util;
import net.minecraft.commands.synchronization.ArgumentTypeInfo;
import net.minecraft.commands.synchronization.ArgumentTypeInfos;
import net.minecraft.core.DefaultedMappedRegistry;
import net.minecraft.core.DefaultedRegistry;
import net.minecraft.core.MappedRegistry;
import net.minecraft.core.Registry;
import net.minecraft.core.WritableRegistry;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.stats.StatType;
import net.minecraft.stats.Stats;
import net.minecraft.util.valueproviders.FloatProviderType;
import net.minecraft.util.valueproviders.IntProviderType;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.entity.ai.village.poi.PoiType;
import net.minecraft.world.entity.ai.village.poi.PoiTypes;
import net.minecraft.world.entity.animal.CatVariant;
import net.minecraft.world.entity.animal.FrogVariant;
import net.minecraft.world.entity.decoration.PaintingVariant;
import net.minecraft.world.entity.decoration.PaintingVariants;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.npc.VillagerType;
import net.minecraft.world.entity.schedule.Activity;
import net.minecraft.world.entity.schedule.Schedule;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Instrument;
import net.minecraft.world.item.Instruments;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.biome.BiomeSources;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BannerPattern;
import net.minecraft.world.level.block.entity.BannerPatterns;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.DecoratedPotPatterns;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.chunk.ChunkGenerators;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.gameevent.PositionSourceType;
import net.minecraft.world.level.levelgen.DensityFunction;
import net.minecraft.world.level.levelgen.DensityFunctions;
import net.minecraft.world.level.levelgen.SurfaceRules;
import net.minecraft.world.level.levelgen.blockpredicates.BlockPredicateType;
import net.minecraft.world.level.levelgen.carver.WorldCarver;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.featuresize.FeatureSizeType;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacerType;
import net.minecraft.world.level.levelgen.feature.rootplacers.RootPlacerType;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProviderType;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecoratorType;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacerType;
import net.minecraft.world.level.levelgen.heightproviders.HeightProviderType;
import net.minecraft.world.level.levelgen.placement.PlacementModifierType;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceType;
import net.minecraft.world.level.levelgen.structure.placement.StructurePlacementType;
import net.minecraft.world.level.levelgen.structure.pools.StructurePoolElementType;
import net.minecraft.world.level.levelgen.structure.templatesystem.PosRuleTestType;
import net.minecraft.world.level.levelgen.structure.templatesystem.RuleTestType;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorType;
import net.minecraft.world.level.levelgen.structure.templatesystem.rule.blockentity.RuleBlockEntityModifierType;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntries;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryType;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctions;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditions;
import net.minecraft.world.level.storage.loot.providers.nbt.LootNbtProviderType;
import net.minecraft.world.level.storage.loot.providers.nbt.NbtProviders;
import net.minecraft.world.level.storage.loot.providers.number.LootNumberProviderType;
import net.minecraft.world.level.storage.loot.providers.number.NumberProviders;
import net.minecraft.world.level.storage.loot.providers.score.LootScoreProviderType;
import net.minecraft.world.level.storage.loot.providers.score.ScoreboardNameProviders;
import net.minecraftforge.registries.GameData;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;

public class BuiltInRegistries {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final Map<ResourceLocation, Supplier<?>> LOADERS = Maps.newLinkedHashMap();
    public static final ResourceLocation ROOT_REGISTRY_NAME = new ResourceLocation("root");
    private static final WritableRegistry<WritableRegistry<?>> WRITABLE_REGISTRY = new MappedRegistry(ResourceKey.createRegistryKey(ROOT_REGISTRY_NAME), Lifecycle.stable());
    public static final DefaultedRegistry<GameEvent> GAME_EVENT = BuiltInRegistries.registerDefaultedWithIntrusiveHolders(Registries.GAME_EVENT, "step", p_260052_ -> GameEvent.STEP);
    @Deprecated
    public static final Registry<SoundEvent> SOUND_EVENT = BuiltInRegistries.forge(Registries.SOUND_EVENT, p_260167_ -> SoundEvents.ITEM_PICKUP);
    @Deprecated
    public static final DefaultedRegistry<Fluid> FLUID = BuiltInRegistries.forge(Registries.FLUID, "empty", (Registry<T> p_259453_) -> Fluids.EMPTY);
    @Deprecated
    public static final Registry<MobEffect> MOB_EFFECT = BuiltInRegistries.forge(Registries.MOB_EFFECT, p_259689_ -> MobEffects.LUCK);
    @Deprecated
    public static final DefaultedRegistry<Block> BLOCK = BuiltInRegistries.forge(Registries.BLOCK, "air", (Registry<T> p_259909_) -> Blocks.AIR);
    @Deprecated
    public static final Registry<Enchantment> ENCHANTMENT = BuiltInRegistries.forge(Registries.ENCHANTMENT, p_259104_ -> Enchantments.BLOCK_FORTUNE);
    @Deprecated
    public static final DefaultedRegistry<EntityType<?>> ENTITY_TYPE = BuiltInRegistries.forge(Registries.ENTITY_TYPE, "pig", (Registry<T> p_259175_) -> EntityType.PIG);
    @Deprecated
    public static final DefaultedRegistry<Item> ITEM = BuiltInRegistries.forge(Registries.ITEM, "air", (Registry<T> p_260227_) -> Items.AIR);
    @Deprecated
    public static final DefaultedRegistry<Potion> POTION = BuiltInRegistries.forge(Registries.POTION, "empty", (Registry<T> p_259869_) -> Potions.EMPTY);
    @Deprecated
    public static final Registry<ParticleType<?>> PARTICLE_TYPE = BuiltInRegistries.forge(Registries.PARTICLE_TYPE, p_260266_ -> ParticleTypes.BLOCK);
    @Deprecated
    public static final Registry<BlockEntityType<?>> BLOCK_ENTITY_TYPE = BuiltInRegistries.forge(Registries.BLOCK_ENTITY_TYPE, p_259434_ -> BlockEntityType.FURNACE);
    @Deprecated
    public static final DefaultedRegistry<PaintingVariant> PAINTING_VARIANT = BuiltInRegistries.forge(Registries.PAINTING_VARIANT, "kebab", PaintingVariants::bootstrap);
    public static final Registry<ResourceLocation> CUSTOM_STAT = BuiltInRegistries.registerSimple(Registries.CUSTOM_STAT, p_259833_ -> Stats.JUMP);
    @Deprecated
    public static final DefaultedRegistry<ChunkStatus> CHUNK_STATUS = BuiltInRegistries.forge(Registries.CHUNK_STATUS, "empty", (Registry<T> p_259971_) -> ChunkStatus.EMPTY);
    public static final Registry<RuleTestType<?>> RULE_TEST = BuiltInRegistries.registerSimple(Registries.RULE_TEST, p_259641_ -> RuleTestType.ALWAYS_TRUE_TEST);
    public static final Registry<RuleBlockEntityModifierType<?>> RULE_BLOCK_ENTITY_MODIFIER = BuiltInRegistries.registerSimple(Registries.RULE_BLOCK_ENTITY_MODIFIER, p_277237_ -> RuleBlockEntityModifierType.PASSTHROUGH);
    public static final Registry<PosRuleTestType<?>> POS_RULE_TEST = BuiltInRegistries.registerSimple(Registries.POS_RULE_TEST, p_259262_ -> PosRuleTestType.ALWAYS_TRUE_TEST);
    @Deprecated
    public static final Registry<MenuType<?>> MENU = BuiltInRegistries.forge(Registries.MENU, p_259341_ -> MenuType.ANVIL);
    @Deprecated
    public static final Registry<RecipeType<?>> RECIPE_TYPE = BuiltInRegistries.forge(Registries.RECIPE_TYPE, p_259086_ -> RecipeType.CRAFTING);
    @Deprecated
    public static final Registry<RecipeSerializer<?>> RECIPE_SERIALIZER = BuiltInRegistries.forge(Registries.RECIPE_SERIALIZER, p_260230_ -> RecipeSerializer.SHAPELESS_RECIPE);
    @Deprecated
    public static final Registry<Attribute> ATTRIBUTE = BuiltInRegistries.forge(Registries.ATTRIBUTE, p_260300_ -> Attributes.LUCK);
    public static final Registry<PositionSourceType<?>> POSITION_SOURCE_TYPE = BuiltInRegistries.registerSimple(Registries.POSITION_SOURCE_TYPE, p_259113_ -> PositionSourceType.BLOCK);
    @Deprecated
    public static final Registry<ArgumentTypeInfo<?, ?>> COMMAND_ARGUMENT_TYPE = BuiltInRegistries.forge(Registries.COMMAND_ARGUMENT_TYPE, ArgumentTypeInfos::bootstrap);
    @Deprecated
    public static final Registry<StatType<?>> STAT_TYPE = BuiltInRegistries.forge(Registries.STAT_TYPE, p_259967_ -> Stats.ITEM_USED);
    public static final DefaultedRegistry<VillagerType> VILLAGER_TYPE = BuiltInRegistries.registerDefaulted(Registries.VILLAGER_TYPE, "plains", p_259473_ -> VillagerType.PLAINS);
    @Deprecated
    public static final DefaultedRegistry<VillagerProfession> VILLAGER_PROFESSION = BuiltInRegistries.forge(Registries.VILLAGER_PROFESSION, "none", (Registry<T> p_259037_) -> VillagerProfession.NONE);
    @Deprecated
    public static final Registry<PoiType> POINT_OF_INTEREST_TYPE = BuiltInRegistries.forge(Registries.POINT_OF_INTEREST_TYPE, PoiTypes::bootstrap);
    @Deprecated
    public static final DefaultedRegistry<MemoryModuleType<?>> MEMORY_MODULE_TYPE = BuiltInRegistries.forge(Registries.MEMORY_MODULE_TYPE, "dummy", (Registry<T> p_259248_) -> MemoryModuleType.DUMMY);
    @Deprecated
    public static final DefaultedRegistry<SensorType<?>> SENSOR_TYPE = BuiltInRegistries.forge(Registries.SENSOR_TYPE, "dummy", (Registry<T> p_259757_) -> SensorType.DUMMY);
    @Deprecated
    public static final Registry<Schedule> SCHEDULE = BuiltInRegistries.forge(Registries.SCHEDULE, p_259540_ -> Schedule.EMPTY);
    @Deprecated
    public static final Registry<Activity> ACTIVITY = BuiltInRegistries.forge(Registries.ACTIVITY, p_260197_ -> Activity.IDLE);
    public static final Registry<LootPoolEntryType> LOOT_POOL_ENTRY_TYPE = BuiltInRegistries.registerSimple(Registries.LOOT_POOL_ENTRY_TYPE, p_260042_ -> LootPoolEntries.EMPTY);
    public static final Registry<LootItemFunctionType> LOOT_FUNCTION_TYPE = BuiltInRegistries.registerSimple(Registries.LOOT_FUNCTION_TYPE, p_259836_ -> LootItemFunctions.SET_COUNT);
    public static final Registry<LootItemConditionType> LOOT_CONDITION_TYPE = BuiltInRegistries.registerSimple(Registries.LOOT_CONDITION_TYPE, p_259742_ -> LootItemConditions.INVERTED);
    public static final Registry<LootNumberProviderType> LOOT_NUMBER_PROVIDER_TYPE = BuiltInRegistries.registerSimple(Registries.LOOT_NUMBER_PROVIDER_TYPE, p_259329_ -> NumberProviders.CONSTANT);
    public static final Registry<LootNbtProviderType> LOOT_NBT_PROVIDER_TYPE = BuiltInRegistries.registerSimple(Registries.LOOT_NBT_PROVIDER_TYPE, p_259862_ -> NbtProviders.CONTEXT);
    public static final Registry<LootScoreProviderType> LOOT_SCORE_PROVIDER_TYPE = BuiltInRegistries.registerSimple(Registries.LOOT_SCORE_PROVIDER_TYPE, p_259313_ -> ScoreboardNameProviders.CONTEXT);
    public static final Registry<FloatProviderType<?>> FLOAT_PROVIDER_TYPE = BuiltInRegistries.registerSimple(Registries.FLOAT_PROVIDER_TYPE, p_260093_ -> FloatProviderType.CONSTANT);
    public static final Registry<IntProviderType<?>> INT_PROVIDER_TYPE = BuiltInRegistries.registerSimple(Registries.INT_PROVIDER_TYPE, p_259607_ -> IntProviderType.CONSTANT);
    public static final Registry<HeightProviderType<?>> HEIGHT_PROVIDER_TYPE = BuiltInRegistries.registerSimple(Registries.HEIGHT_PROVIDER_TYPE, p_259663_ -> HeightProviderType.CONSTANT);
    public static final Registry<BlockPredicateType<?>> BLOCK_PREDICATE_TYPE = BuiltInRegistries.registerSimple(Registries.BLOCK_PREDICATE_TYPE, p_260006_ -> BlockPredicateType.NOT);
    @Deprecated
    public static final Registry<WorldCarver<?>> CARVER = BuiltInRegistries.forge(Registries.CARVER, p_260200_ -> WorldCarver.CAVE);
    @Deprecated
    public static final Registry<Feature<?>> FEATURE = BuiltInRegistries.forge(Registries.FEATURE, p_259143_ -> Feature.ORE);
    public static final Registry<StructurePlacementType<?>> STRUCTURE_PLACEMENT = BuiltInRegistries.registerSimple(Registries.STRUCTURE_PLACEMENT, p_259179_ -> StructurePlacementType.RANDOM_SPREAD);
    public static final Registry<StructurePieceType> STRUCTURE_PIECE = BuiltInRegistries.registerSimple(Registries.STRUCTURE_PIECE, p_259722_ -> StructurePieceType.MINE_SHAFT_ROOM);
    public static final Registry<StructureType<?>> STRUCTURE_TYPE = BuiltInRegistries.registerSimple(Registries.STRUCTURE_TYPE, p_259466_ -> StructureType.JIGSAW);
    public static final Registry<PlacementModifierType<?>> PLACEMENT_MODIFIER_TYPE = BuiltInRegistries.registerSimple(Registries.PLACEMENT_MODIFIER_TYPE, p_260335_ -> PlacementModifierType.COUNT);
    @Deprecated
    public static final Registry<BlockStateProviderType<?>> BLOCKSTATE_PROVIDER_TYPE = BuiltInRegistries.forge(Registries.BLOCK_STATE_PROVIDER_TYPE, p_259345_ -> BlockStateProviderType.SIMPLE_STATE_PROVIDER);
    @Deprecated
    public static final Registry<FoliagePlacerType<?>> FOLIAGE_PLACER_TYPE = BuiltInRegistries.forge(Registries.FOLIAGE_PLACER_TYPE, p_260329_ -> FoliagePlacerType.BLOB_FOLIAGE_PLACER);
    public static final Registry<TrunkPlacerType<?>> TRUNK_PLACER_TYPE = BuiltInRegistries.registerSimple(Registries.TRUNK_PLACER_TYPE, p_259690_ -> TrunkPlacerType.STRAIGHT_TRUNK_PLACER);
    public static final Registry<RootPlacerType<?>> ROOT_PLACER_TYPE = BuiltInRegistries.registerSimple(Registries.ROOT_PLACER_TYPE, p_259493_ -> RootPlacerType.MANGROVE_ROOT_PLACER);
    @Deprecated
    public static final Registry<TreeDecoratorType<?>> TREE_DECORATOR_TYPE = BuiltInRegistries.forge(Registries.TREE_DECORATOR_TYPE, p_259122_ -> TreeDecoratorType.LEAVE_VINE);
    public static final Registry<FeatureSizeType<?>> FEATURE_SIZE_TYPE = BuiltInRegistries.registerSimple(Registries.FEATURE_SIZE_TYPE, p_259370_ -> FeatureSizeType.TWO_LAYERS_FEATURE_SIZE);
    public static final Registry<Codec<? extends BiomeSource>> BIOME_SOURCE = BuiltInRegistries.registerSimple(Registries.BIOME_SOURCE, Lifecycle.stable(), BiomeSources::bootstrap);
    public static final Registry<Codec<? extends ChunkGenerator>> CHUNK_GENERATOR = BuiltInRegistries.registerSimple(Registries.CHUNK_GENERATOR, Lifecycle.stable(), ChunkGenerators::bootstrap);
    public static final Registry<Codec<? extends SurfaceRules.ConditionSource>> MATERIAL_CONDITION = BuiltInRegistries.registerSimple(Registries.MATERIAL_CONDITION, SurfaceRules.ConditionSource::bootstrap);
    public static final Registry<Codec<? extends SurfaceRules.RuleSource>> MATERIAL_RULE = BuiltInRegistries.registerSimple(Registries.MATERIAL_RULE, SurfaceRules.RuleSource::bootstrap);
    public static final Registry<Codec<? extends DensityFunction>> DENSITY_FUNCTION_TYPE = BuiltInRegistries.registerSimple(Registries.DENSITY_FUNCTION_TYPE, DensityFunctions::bootstrap);
    public static final Registry<StructureProcessorType<?>> STRUCTURE_PROCESSOR = BuiltInRegistries.registerSimple(Registries.STRUCTURE_PROCESSOR, p_259305_ -> StructureProcessorType.BLOCK_IGNORE);
    public static final Registry<StructurePoolElementType<?>> STRUCTURE_POOL_ELEMENT = BuiltInRegistries.registerSimple(Registries.STRUCTURE_POOL_ELEMENT, p_259361_ -> StructurePoolElementType.EMPTY);
    public static final Registry<CatVariant> CAT_VARIANT = BuiltInRegistries.registerSimple(Registries.CAT_VARIANT, CatVariant::bootstrap);
    public static final Registry<FrogVariant> FROG_VARIANT = BuiltInRegistries.registerSimple(Registries.FROG_VARIANT, p_259261_ -> FrogVariant.TEMPERATE);
    public static final Registry<BannerPattern> BANNER_PATTERN = BuiltInRegistries.registerSimple(Registries.BANNER_PATTERN, BannerPatterns::bootstrap);
    public static final Registry<Instrument> INSTRUMENT = BuiltInRegistries.registerSimple(Registries.INSTRUMENT, Instruments::bootstrap);
    public static final Registry<String> DECORATED_POT_PATTERNS = BuiltInRegistries.registerSimple(Registries.DECORATED_POT_PATTERNS, DecoratedPotPatterns::bootstrap);
    public static final Registry<CreativeModeTab> CREATIVE_MODE_TAB = BuiltInRegistries.registerSimple(Registries.CREATIVE_MODE_TAB, CreativeModeTabs::bootstrap);
    public static final Registry<? extends Registry<?>> REGISTRY = WRITABLE_REGISTRY;

    private static <T> Registry<T> registerSimple(ResourceKey<? extends Registry<T>> p_260095_, RegistryBootstrap<T> p_259057_) {
        return BuiltInRegistries.registerSimple(p_260095_, Lifecycle.stable(), p_259057_);
    }

    private static <T> Registry<T> forge(ResourceKey<? extends Registry<T>> key, RegistryBootstrap<T> def) {
        return BuiltInRegistries.forge(key, Lifecycle.stable(), def);
    }

    private static <T> DefaultedRegistry<T> registerDefaulted(ResourceKey<? extends Registry<T>> p_259887_, String p_259325_, RegistryBootstrap<T> p_259759_) {
        return BuiltInRegistries.registerDefaulted(p_259887_, p_259325_, Lifecycle.stable(), p_259759_);
    }

    private static <T> DefaultedRegistry<T> forge(ResourceKey<? extends Registry<T>> key, String defKey, RegistryBootstrap<T> def) {
        return BuiltInRegistries.forge(key, defKey, Lifecycle.stable(), def);
    }

    private static <T> DefaultedRegistry<T> registerDefaultedWithIntrusiveHolders(ResourceKey<? extends Registry<T>> p_259296_, String p_259101_, RegistryBootstrap<T> p_259485_) {
        return BuiltInRegistries.registerDefaultedWithIntrusiveHolders(p_259296_, p_259101_, Lifecycle.stable(), p_259485_);
    }

    private static <T> Registry<T> registerSimple(ResourceKey<? extends Registry<T>> p_259121_, Lifecycle p_259977_, RegistryBootstrap<T> p_259874_) {
        return BuiltInRegistries.internalRegister(p_259121_, new MappedRegistry(p_259121_, p_259977_, false), p_259874_, p_259977_);
    }

    private static <T> Registry<T> forge(ResourceKey<? extends Registry<T>> key, Lifecycle cycle, RegistryBootstrap<T> def) {
        return BuiltInRegistries.internalRegister(key, GameData.getWrapper(key, cycle), def, cycle);
    }

    private static <T> DefaultedRegistry<T> registerDefaulted(ResourceKey<? extends Registry<T>> p_259400_, String p_259678_, Lifecycle p_259157_, RegistryBootstrap<T> p_259806_) {
        return BuiltInRegistries.internalRegister(p_259400_, new DefaultedMappedRegistry(p_259678_, p_259400_, p_259157_, false), p_259806_, p_259157_);
    }

    private static <T> DefaultedRegistry<T> forge(ResourceKey<? extends Registry<T>> key, String defKey, Lifecycle cycle, RegistryBootstrap<T> def) {
        return (DefaultedRegistry)((Object)BuiltInRegistries.internalRegister(key, GameData.getWrapper(key, cycle, defKey), def, cycle));
    }

    private static <T> DefaultedRegistry<T> registerDefaultedWithIntrusiveHolders(ResourceKey<? extends Registry<T>> p_260010_, String p_260220_, Lifecycle p_260139_, RegistryBootstrap<T> p_260185_) {
        return BuiltInRegistries.internalRegister(p_260010_, new DefaultedMappedRegistry(p_260220_, p_260010_, p_260139_, true), p_260185_, p_260139_);
    }

    private static <T, R extends WritableRegistry<T>> R internalRegister(ResourceKey<? extends Registry<T>> p_259230_, R p_260327_, RegistryBootstrap<T> p_259210_, Lifecycle p_259258_) {
        ResourceLocation resourcelocation = p_259230_.location();
        LOADERS.put(resourcelocation, () -> p_259210_.run(p_260327_));
        WRITABLE_REGISTRY.register(p_259230_, p_260327_, p_259258_);
        return p_260327_;
    }

    public static void bootStrap() {
        BuiltInRegistries.createContents();
        BuiltInRegistries.freeze();
        BuiltInRegistries.validate(REGISTRY);
    }

    private static void createContents() {
        LOADERS.forEach((p_259863_, p_259387_) -> {
            if (p_259387_.get() == null) {
                LOGGER.error("Unable to bootstrap registry '{}'", p_259863_);
            }
        });
    }

    private static void freeze() {
        REGISTRY.freeze();
        for (Registry registry : REGISTRY) {
            registry.freeze();
        }
    }

    private static <T extends Registry<?>> void validate(Registry<T> p_260209_) {
        p_260209_.forEach(p_259410_ -> {
            if (p_259410_.keySet().isEmpty()) {
                Util.logAndPauseIfInIde("Registry '" + String.valueOf(p_260209_.getKey(p_259410_)) + "' was empty after loading");
            }
            if (p_259410_ instanceof DefaultedRegistry) {
                ResourceLocation resourcelocation = ((DefaultedRegistry)p_259410_).getDefaultKey();
                Validate.notNull(p_259410_.get(resourcelocation), (String)("Missing default of DefaultedMappedRegistry: " + String.valueOf(p_260209_.key()) + ", Entry: " + String.valueOf(resourcelocation)), (Object[])new Object[0]);
            }
        });
    }

    @FunctionalInterface
    static interface RegistryBootstrap<T> {
        public T run(Registry<T> var1);
    }
}

