/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.dispenser;

import net.minecraft.core.BlockSource;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.DispenserBlock;

public abstract class AbstractProjectileDispenseBehavior
extends DefaultDispenseItemBehavior {
    @Override
    public ItemStack execute(BlockSource p_123366_, ItemStack p_123367_) {
        ServerLevel level = p_123366_.getLevel();
        Position position = DispenserBlock.getDispensePosition(p_123366_);
        Direction direction = p_123366_.getBlockState().getValue(DispenserBlock.FACING);
        Projectile projectile = this.getProjectile(level, position, p_123367_);
        projectile.shoot(direction.getStepX(), (float)direction.getStepY() + 0.1f, direction.getStepZ(), this.getPower(), this.getUncertainty());
        level.addFreshEntity(projectile);
        p_123367_.shrink(1);
        return p_123367_;
    }

    @Override
    protected void playSound(BlockSource p_123364_) {
        p_123364_.getLevel().levelEvent(1002, p_123364_.getPos(), 0);
    }

    protected abstract Projectile getProjectile(Level var1, Position var2, ItemStack var3);

    protected float getUncertainty() {
        return 6.0f;
    }

    protected float getPower() {
        return 1.1f;
    }
}

