/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core;

import com.mojang.datafixers.DataFixUtils;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.Keyable;
import com.mojang.serialization.Lifecycle;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderOwner;
import net.minecraft.core.HolderSet;
import net.minecraft.core.IdMap;
import net.minecraft.core.WritableRegistry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.RandomSource;

public interface Registry<T>
extends Keyable,
IdMap<T> {
    public ResourceKey<? extends Registry<T>> key();

    default public Codec<T> byNameCodec() {
        Codec codec = ResourceLocation.CODEC.flatXmap(p_258170_ -> Optional.ofNullable(this.get((ResourceLocation)p_258170_)).map(DataResult::success).orElseGet(() -> DataResult.error(() -> "Unknown registry key in " + String.valueOf(this.key()) + ": " + String.valueOf(p_258170_))), p_258177_ -> this.getResourceKey(p_258177_).map(ResourceKey::location).map(DataResult::success).orElseGet(() -> DataResult.error(() -> "Unknown registry element in " + String.valueOf(this.key()) + ":" + String.valueOf(p_258177_))));
        Codec<Object> codec1 = ExtraCodecs.idResolverCodec(p_258179_ -> this.getResourceKey(p_258179_).isPresent() ? this.getId(p_258179_) : -1, this::byId, -1);
        return ExtraCodecs.overrideLifecycle(ExtraCodecs.orCompressed(codec, codec1), this::lifecycle, this::lifecycle);
    }

    default public Codec<Holder<T>> holderByNameCodec() {
        Codec codec = ResourceLocation.CODEC.flatXmap(p_258174_ -> this.getHolder(ResourceKey.create(this.key(), p_258174_)).map(DataResult::success).orElseGet(() -> DataResult.error(() -> "Unknown registry key in " + String.valueOf(this.key()) + ": " + String.valueOf(p_258174_))), p_206061_ -> p_206061_.unwrapKey().map(ResourceKey::location).map(DataResult::success).orElseGet(() -> DataResult.error(() -> "Unknown registry element in " + String.valueOf(this.key()) + ":" + String.valueOf(p_206061_))));
        return ExtraCodecs.overrideLifecycle(codec, p_258178_ -> this.lifecycle(p_258178_.value()), p_258171_ -> this.lifecycle(p_258171_.value()));
    }

    default public <U> Stream<U> keys(DynamicOps<U> p_123030_) {
        return this.keySet().stream().map(p_235784_ -> p_123030_.createString(p_235784_.toString()));
    }

    @Nullable
    public ResourceLocation getKey(T var1);

    public Optional<ResourceKey<T>> getResourceKey(T var1);

    @Override
    public int getId(@Nullable T var1);

    @Nullable
    public T get(@Nullable ResourceKey<T> var1);

    @Nullable
    public T get(@Nullable ResourceLocation var1);

    public Lifecycle lifecycle(T var1);

    public Lifecycle registryLifecycle();

    default public Optional<T> getOptional(@Nullable ResourceLocation p_123007_) {
        return Optional.ofNullable(this.get(p_123007_));
    }

    default public Optional<T> getOptional(@Nullable ResourceKey<T> p_123010_) {
        return Optional.ofNullable(this.get(p_123010_));
    }

    default public T getOrThrow(ResourceKey<T> p_123014_) {
        T t = this.get(p_123014_);
        if (t == null) {
            throw new IllegalStateException("Missing key in " + String.valueOf(this.key()) + ": " + String.valueOf(p_123014_));
        }
        return t;
    }

    public Set<ResourceLocation> keySet();

    public Set<Map.Entry<ResourceKey<T>, T>> entrySet();

    public Set<ResourceKey<T>> registryKeySet();

    public Optional<Holder.Reference<T>> getRandom(RandomSource var1);

    default public Stream<T> stream() {
        return StreamSupport.stream(this.spliterator(), false);
    }

    public boolean containsKey(ResourceLocation var1);

    public boolean containsKey(ResourceKey<T> var1);

    public static <T> T register(Registry<? super T> p_122962_, String p_122963_, T p_122964_) {
        return Registry.register(p_122962_, new ResourceLocation(p_122963_), p_122964_);
    }

    public static <V, T extends V> T register(Registry<V> p_122966_, ResourceLocation p_122967_, T p_122968_) {
        return Registry.register(p_122966_, ResourceKey.create(p_122966_.key(), p_122967_), p_122968_);
    }

    public static <V, T extends V> T register(Registry<V> p_194580_, ResourceKey<V> p_194581_, T p_194582_) {
        ((WritableRegistry)p_194580_).register(p_194581_, p_194582_, Lifecycle.stable());
        return p_194582_;
    }

    public static <T> Holder.Reference<T> registerForHolder(Registry<T> p_263347_, ResourceKey<T> p_263355_, T p_263428_) {
        return ((WritableRegistry)p_263347_).register(p_263355_, p_263428_, Lifecycle.stable());
    }

    public static <T> Holder.Reference<T> registerForHolder(Registry<T> p_263351_, ResourceLocation p_263363_, T p_263423_) {
        return Registry.registerForHolder(p_263351_, ResourceKey.create(p_263351_.key(), p_263363_), p_263423_);
    }

    public static <V, T extends V> T registerMapping(Registry<V> p_122957_, int p_122958_, String p_122959_, T p_122960_) {
        ((WritableRegistry)p_122957_).registerMapping(p_122958_, ResourceKey.create(p_122957_.key(), new ResourceLocation(p_122959_)), p_122960_, Lifecycle.stable());
        return p_122960_;
    }

    public Registry<T> freeze();

    public Holder.Reference<T> createIntrusiveHolder(T var1);

    public Optional<Holder.Reference<T>> getHolder(int var1);

    public Optional<Holder.Reference<T>> getHolder(ResourceKey<T> var1);

    public Holder<T> wrapAsHolder(T var1);

    default public Holder.Reference<T> getHolderOrThrow(ResourceKey<T> p_249087_) {
        return this.getHolder(p_249087_).orElseThrow(() -> new IllegalStateException("Missing key in " + String.valueOf(this.key()) + ": " + String.valueOf(p_249087_)));
    }

    public Stream<Holder.Reference<T>> holders();

    public Optional<HolderSet.Named<T>> getTag(TagKey<T> var1);

    default public Iterable<Holder<T>> getTagOrEmpty(TagKey<T> p_206059_) {
        return (Iterable)DataFixUtils.orElse(this.getTag(p_206059_), List.of());
    }

    public HolderSet.Named<T> getOrCreateTag(TagKey<T> var1);

    public Stream<Pair<TagKey<T>, HolderSet.Named<T>>> getTags();

    public Stream<TagKey<T>> getTagNames();

    public void resetTags();

    public void bindTags(Map<TagKey<T>, List<Holder<T>>> var1);

    default public IdMap<Holder<T>> asHolderIdMap() {
        return new IdMap<Holder<T>>(){

            @Override
            public int getId(Holder<T> p_259992_) {
                return Registry.this.getId(p_259992_.value());
            }

            @Override
            @Nullable
            public Holder<T> byId(int p_259972_) {
                return Registry.this.getHolder(p_259972_).orElse(null);
            }

            @Override
            public int size() {
                return Registry.this.size();
            }

            @Override
            public Iterator<Holder<T>> iterator() {
                return Registry.this.holders().map(p_260061_ -> p_260061_).iterator();
            }
        };
    }

    public HolderOwner<T> holderOwner();

    public HolderLookup.RegistryLookup<T> asLookup();

    default public HolderLookup.RegistryLookup<T> asTagAddingLookup() {
        return new HolderLookup.RegistryLookup.Delegate<T>(){

            @Override
            protected HolderLookup.RegistryLookup<T> parent() {
                return Registry.this.asLookup();
            }

            @Override
            public Optional<HolderSet.Named<T>> get(TagKey<T> p_259111_) {
                return Optional.of(this.getOrThrow(p_259111_));
            }

            @Override
            public HolderSet.Named<T> getOrThrow(TagKey<T> p_259653_) {
                return Registry.this.getOrCreateTag(p_259653_);
            }
        };
    }
}

